//
//  GSVodListTableViewController.m
//  PlayerSDKDemo
//
//  Created by 张俞 on 2023/8/16.
//  Copyright © 2023 Geensee. All rights reserved.
//

#import "GSVodListTableViewController.h"
#import "GSVodVideoTableViewCell.h"
#import "GSVodInfo.h"
#import "GSVodTools.h"


/// 点播缓存个数（上下各5个,最多缓存11个点播）
#define GSVodCacheNumber 5
/// 点播数据缓存总个数
#define GSVodData_CacheTotalNumber (GSVodCacheNumber*2+1)


#define VodHeight (self.view.frame.size.height)
#define VodWidth (self.view.frame.size.width)

@interface GSVodListTableViewController ()<UITableViewDelegate,UITableViewDataSource,GSVodInfoDelegate>
@property (nonatomic, strong) UITableView * vodListTableView;
@property (nonatomic, strong) NSMutableArray * dataArray;
@property (nonatomic, assign) NSInteger currentPlayRow;

@end

@implementation GSVodListTableViewController
- (void)dealloc{
 
    NSLog(@"GSVodListTableViewController - dealloc");
}
- (void)viewDidLoad {
    [super viewDidLoad];
    // 设置音频会话
    [GSVodObject vodSetDefaultAudioSessionCategory];
    
    _currentPlayRow = 0;
    // Do any additional setup after loading the view.
    self.view.backgroundColor = [UIColor blackColor];
    self.dataArray = [[NSMutableArray alloc] init];
    self.vodListTableView = [[UITableView alloc] initWithFrame:CGRectMake(0, -(VodHeight*GSVodCacheNumber), VodWidth, VodHeight*GSVodData_CacheTotalNumber) style:UITableViewStylePlain];
    if (@available(iOS 15.0, *)) {
        self.vodListTableView.sectionHeaderTopPadding = 0;
    } else {
        // Fallback on earlier versions
    }
    self.vodListTableView.delegate = self;
    self.vodListTableView.dataSource = self;
    self.vodListTableView.pagingEnabled = NO;
    self.vodListTableView.showsVerticalScrollIndicator = NO;
    self.vodListTableView.showsHorizontalScrollIndicator = NO;
    [self.vodListTableView setScrollsToTop:NO];
    self.vodListTableView.backgroundColor = [UIColor blackColor];
    
    self.vodListTableView.contentInset = UIEdgeInsetsMake(VodHeight*GSVodCacheNumber,0, VodHeight*GSVodCacheNumber,0);
    self.vodListTableView.contentOffset = CGPointMake(0, -(VodHeight*GSVodCacheNumber)+64+[GSVodTools statusBarHeight]);

    [self.view addSubview:self.vodListTableView];
    
    /// 创建点播数据
    [self createAllData];

}

-(CGFloat)tableView:(UITableView *)tableView heightForRowAtIndexPath:(NSIndexPath *)indexPath{
    return VodHeight;
}
- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section{
    return self.dataArray.count;
}
- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath{
    
    NSString * cellID = [NSString stringWithFormat:@"GSVodVideoTableViewCellID"];
    GSVodVideoTableViewCell * cell = [tableView dequeueReusableCellWithIdentifier:cellID];
    if(cell == nil){
        cell = [[GSVodVideoTableViewCell alloc] initWithStyle:UITableViewCellStyleDefault reuseIdentifier:cellID renderMode:self.renderMode VideoMode:self.videoMode];
    }
    GSVodInfo * vodInfo = self.dataArray[indexPath.row];
    cell.vodInfo = vodInfo;
    cell.vodTitleLabel.text = [NSString stringWithFormat:@"第%ld个视频,%@",indexPath.row+1,vodInfo.params.roomNumber];
    NSLog(@"cell(%@) 播放:%ld",cellID,indexPath.row+1);

    return cell;
}
#pragma mark - ScrollView delegate
- (void)scrollViewDidEndDragging:(UIScrollView *)scrollView willDecelerate:(BOOL)decelerate{
    dispatch_async(dispatch_get_main_queue(), ^{
        CGPoint translatedPoint = [scrollView.panGestureRecognizer translationInView:scrollView];
        //UITableView禁止响应其他滑动手势
        scrollView.panGestureRecognizer.enabled = NO;
        CGFloat height = 50;
        if(translatedPoint.y < -height && self.currentPlayRow < self.dataArray.count ) {
            //向下滑动索引递增
            self.currentPlayRow ++;
            [self playRowDown:self.currentPlayRow];
        }
        if(translatedPoint.y > height && self.currentPlayRow > 0) {
            //向上滑动索引递减
            self.currentPlayRow --;
            [self playRowUp:self.currentPlayRow];
        }
        if(self.currentPlayRow >= 0 && self.currentPlayRow < self.dataArray.count){
            [UIView animateWithDuration:0.2
                                  delay:0.0
                                options:UIViewAnimationOptionCurveEaseOut animations:^{
                //UITableView滑动到指定cell
                [self.vodListTableView scrollToRowAtIndexPath:[NSIndexPath indexPathForRow:self.currentPlayRow inSection:0] atScrollPosition:UITableViewScrollPositionBottom animated:NO];
                
            } completion:^(BOOL finished) {
                            
                scrollView.panGestureRecognizer.enabled = YES;
                
            }];
        }
    });
}
#pragma mark -- 设置当前播放的row
- (void)setCurrentPlayRow:(NSInteger)currentPlayRow{
    if(currentPlayRow >= self.dataArray.count || currentPlayRow < 0){
        return;
    }
//    if(_currentPlayRow == currentPlayRow){
//        return;
//    }
    // 暂停之前的
    if(_currentPlayRow >= 0 && _currentPlayRow < self.dataArray.count){
        GSVodInfo * lastVodInfo = self.dataArray[_currentPlayRow];
        lastVodInfo.isPlay = NO;
        [lastVodInfo.vodObj.player seekTo:0];
        [lastVodInfo.vodObj.player pause];
        NSLog(@"暂停播放点播：%ld",_currentPlayRow+1);
        [self.vodListTableView reloadRowsAtIndexPaths:@[[NSIndexPath indexPathForRow:_currentPlayRow inSection:0]] withRowAnimation:UITableViewRowAnimationNone];

    }

    // 播放当前的
    _currentPlayRow = currentPlayRow;
    GSVodInfo * vodInfo = self.dataArray[_currentPlayRow];
    if(vodInfo.isCreatePlayerSuccess == NO || vodInfo.vodObj.player == nil){
        if(vodInfo.vodObj.player == nil){
            NSLog(@"当前点播播放器没有创建成功，重新加载 %ld",(long)currentPlayRow+1);
        }else{
            NSLog(@"当前点播没有创建成功，重新加载 %ld",(long)currentPlayRow+1);
        }
        // 重新请求点播
        vodInfo.item = nil;
        [vodInfo destroyVodPlayer];
        [self loadVodPlayerWithRow:currentPlayRow];
    }else{
        vodInfo.isPlay = YES;
        [vodInfo.vodObj.player seekTo:0];
        NSLog(@"开始播放点播：%ld",_currentPlayRow+1);
        [self.vodListTableView reloadRowsAtIndexPaths:@[[NSIndexPath indexPathForRow:_currentPlayRow inSection:0]] withRowAnimation:UITableViewRowAnimationNone];
    }
  
}
#pragma mark -- 往上滑动，创建+1，销毁-2
- (void)playRowUp:(NSInteger)row{
    for (NSInteger i = 1 ; i <= GSVodCacheNumber; i++) {
        /// 需要销毁的row
        NSInteger destroyRow = row + (GSVodCacheNumber + 1);
        [self destroyVodPlayerWithRow:destroyRow];

        /// 需要加载的row
        NSInteger loadRow = row - i;
        [self loadVodPlayerWithRow:loadRow];

    }
    
}
#pragma mark -- 往下滑动，创建+1，销毁-2
- (void)playRowDown:(NSInteger)row{
    for (NSInteger i = 1 ; i <= GSVodCacheNumber; i++) {
        /// 需要销毁的row
        NSInteger destroyRow = row - (GSVodCacheNumber + 1);
        [self destroyVodPlayerWithRow:destroyRow];

        /// 需要加载的row
        NSInteger loadRow = row + i;
        [self loadVodPlayerWithRow:loadRow];

    }
}
#pragma mark -- 加载第row个点播
- (void)loadVodPlayerWithRow:(NSInteger)row{
    if(row < 0 || row>=self.roomNumbers.count){
        return;
    }
    GSVodInfo * vodInfo = nil;
    if(row < self.dataArray.count){
        // 修改原来的
        vodInfo = self.dataArray[row];
        if(vodInfo.isCreatePlayerSuccess){
            return;
        }
    }else{
        // 添加新的
        vodInfo = [[GSVodInfo alloc] initWitParam:self.params];
        vodInfo.params.roomNumber = self.roomNumbers[row];
        vodInfo.params.watchPassword = self.passwordNumbers[row];
        [self.dataArray addObject:vodInfo];
        [self.vodListTableView reloadData];
    }
    // 请求downitem 并创建播放器
    [vodInfo requestVodItemAndCreatePlayer];
}
#pragma mark -- 点播播放器创建结果回调
- (void)onVodPlayerCreate:(BOOL)isSuccess Row:(NSInteger)row Error:(int)error{
    if(isSuccess){
        if(self.currentPlayRow == row){
            NSLog(@"缓存了第%ld个播放点播，并开始播放",row+1);
            self.currentPlayRow = row;
        }else{
            NSLog(@"缓存了第%ld个播放点播",row+1);
            [self.vodListTableView reloadRowsAtIndexPaths:@[[NSIndexPath indexPathForRow:row inSection:0]] withRowAnimation:UITableViewRowAnimationNone];
        }
    }else{
        [MBProgressHUD showHint:[NSString stringWithFormat:@"第%ld播放点播失败:%d",row+1,error] toView:self.view];
    }

}
/*
 *监听video 的开始
 */
- (void)onVideoStartWithRow:(NSInteger)row{
    NSLog(@"监听video 的开始 %ld",(long)row+1);

    [self.vodListTableView reloadRowsAtIndexPaths:@[[NSIndexPath indexPathForRow:row inSection:0]] withRowAnimation:UITableViewRowAnimationNone];
}

/*
 *监听video的结束
 */
-(void)onVideoEndWithRow:(NSInteger)row{
    NSLog(@"监听video 的结束 %ld",(long)row+1);

    [self.vodListTableView reloadRowsAtIndexPaths:@[[NSIndexPath indexPathForRow:row inSection:0]] withRowAnimation:UITableViewRowAnimationNone];

}
#pragma mark -- 销毁第row个点播
- (void)destroyVodPlayerWithRow:(NSInteger)row{
    if(row < 0 || row >= self.dataArray.count){
        return;
    }
    GSVodInfo * vodInfo = self.dataArray[row];
    if(vodInfo.isCreatePlayerSuccess == NO){
        return;
    }
    NSLog(@"销毁了第%ld个播放点播",row+1);
    [vodInfo destroyVodPlayer];

}

#pragma mark -- 创建所有的数据，并开始加载点播数据和播放器
- (void)createAllData{
    for (int i = 0; i < self.roomNumbers.count; i++) {
        GSVodInfo * vodInfo = [[GSVodInfo alloc] initWitParam:self.params];
        vodInfo.params.roomNumber = self.roomNumbers[i];
        vodInfo.params.watchPassword = self.passwordNumbers[i];
        vodInfo.row = i ;
        vodInfo.vodObj.cacheNum_Max = GSVodData_CacheTotalNumber;
        vodInfo.vodObj.isFlv = self.isFlv;
        vodInfo.vodObj.hardwareAccelerate = self.hardwareAccelerate;
        vodInfo.vodObj.isHttps =  self.isHttps;
        vodInfo.vodObj.sessionCategoryOption = AVAudioSessionCategoryOptionDefaultToSpeaker |AVAudioSessionCategoryOptionAllowBluetooth;
        vodInfo.vodInfoDelegate = self;
        [self.dataArray addObject:vodInfo];
    }
    [self.vodListTableView reloadData];
    
    // 首次加载前9个点播 用于测试
    [self firstLoadData];

}
#pragma mark -- 首次加载前N个点播
- (void)firstLoadData{
    /// 需要加载的row
    for (int i = 0; i <= GSVodCacheNumber; i++) {
        if(i >= self.roomNumbers.count){
            break;
        }
        [self loadVodPlayerWithRow:i];
    }
}
#pragma mark -- 返回
- (void)back {

    [self.navigationController popViewControllerAnimated:YES];

}


@end
