//
//  GSVodInfo.m
//  PlayerSDKDemo
//
//  Created by 张俞 on 2023/8/8.
//  Copyright © 2023 Geensee. All rights reserved.
//

#import "GSVodInfo.h"
@interface GSVodInfo()<VodPlayDelegate>


@end
@implementation GSVodInfo
- (void)dealloc{
    NSLog(@"GSVodInfo -- dealloc");
}
- (instancetype)initWitParam:(GSConnectInfo *)params{
    if(self = [super init]){
        self.isPlay = NO;
        self.vodObj = [[GSVodObject alloc]init];
        //param
        GSConnectInfo * paramsInfo = [[GSConnectInfo alloc] init];
        paramsInfo.domain = params.domain;
        paramsInfo.nickName = params.nickName;
        paramsInfo.serviceType = params.serviceType;
        paramsInfo.userData = params.userData;
        self.params = paramsInfo;
    }
    return self;
}
- (instancetype)initWith:(NSString *)domain nickName:(NSString *)nickName serviceType:(GSBroadcastServiceType)serviceType roomNumber:(NSString *)roomNumber watchPassword:(NSString *)watchPassword{
    if(self = [super init]){
        self.isPlay = NO;
        self.vodObj = [[GSVodObject alloc]init];
        //param
        GSConnectInfo *params = [[GSConnectInfo alloc] init];
        params.domain = domain;
        params.nickName = nickName;
        params.serviceType = serviceType;
        params.roomNumber = roomNumber;
        params.watchPassword = watchPassword;
        self.params = params;
    }
    return self;
}

#pragma mark -- 请求点播item，并创建播放器
- (void)requestVodItemAndCreatePlayer{
    self.isCreatePlayerSuccess = NO;
    if(self.item != nil){
        // 已经存在item，创建播放器，默认是暂停播放
        [self.vodObj createVodPlayerWithDownItem:self.item VodPlayDelegate:self];
    }else{
        [self.vodObj request:self.params completion:^(downItem *item, GSVodWebaccessError type) {
            
            if(type == GSVodWebaccessSuccess){
                self.item = item;
                // 创建播放器，默认是暂停播放
                [self.vodObj createVodPlayerWithDownItem:self.item VodPlayDelegate:self];
            }else{
                NSLog(@"downitem 请求点播失败 %@ :%lu",self.params.roomNumber,type);
                self.isCreatePlayerSuccess = NO;
                if(self.vodInfoDelegate && [self.vodInfoDelegate respondsToSelector:@selector(onVodPlayerCreate:Row:Error:)]){
                    [self.vodInfoDelegate onVodPlayerCreate:self.isCreatePlayerSuccess Row:self.row Error:(int)type];
                }
            }
        }];
    }
}
#pragma mark -- 播放器初始化成功回调
- (void)onInit:(int)result haveVideo:(BOOL)haveVideo duration:(int)duration docInfos:(NSArray *)docInfos{
    self.duration = duration;
    self.isHaveVideo = NO;
    if(result == 0){
        self.isCreatePlayerSuccess = YES;
    }else{
        self.isCreatePlayerSuccess = NO;
    }
    if(self.vodInfoDelegate && [self.vodInfoDelegate respondsToSelector:@selector(onVodPlayerCreate:Row:Error:)]){
        [self.vodInfoDelegate onVodPlayerCreate:self.isCreatePlayerSuccess Row:self.row Error:400];
    }

    if(self.playerDelegate && [self.playerDelegate respondsToSelector:@selector(onVodPlayeronInitWithDuration:)]){
        [self.playerDelegate onVodPlayeronInitWithDuration:duration];
    }

}
/**
 * 自动播放完成停止通知，
 */
- (void) onStop{
    if(self.playerDelegate && [self.playerDelegate respondsToSelector:@selector(onStop)]){
        [self.playerDelegate onStop];
    }
}

/**
 * 进度通知
 * @param position 当前播放进度
 */
- (void) onPosition:(int) position{
    if(self.playerDelegate && [self.playerDelegate respondsToSelector:@selector(onPosition:)]){
        [self.playerDelegate onPosition:position];
    }
}
/*
 *监听video 的开始
 */
- (void)onVideoStart{
    self.isHaveVideo = YES;
    if(self.vodInfoDelegate && [self.vodInfoDelegate respondsToSelector:@selector(onVideoStartWithRow:)]){
        [self.vodInfoDelegate onVideoStartWithRow:self.row];
    }
}

/*
 *监听video的结束
 */
-(void)onVideoEnd{
    self.isHaveVideo = NO;
    if(self.vodInfoDelegate && [self.vodInfoDelegate respondsToSelector:@selector(onVideoEndWithRow:)]){
        [self.vodInfoDelegate onVideoEndWithRow:self.row];
    }
}
#pragma mark -- 首帧耗时回调
- (void)onFirstVideoUsedTime:(double)time{
    self.firstVideoUsedTime = time;
    if(self.playerDelegate && [self.playerDelegate respondsToSelector:@selector(onFirstVideoUsedTime:)]){
        [self.playerDelegate onFirstVideoUsedTime:time];
    }
}
#pragma mark -- 销毁播放器
- (void)destroyVodPlayer{
    self.isCreatePlayerSuccess = NO;
    [self.vodObj destroyVodPlayer];
}

@end
