//
//  GSChatModel.m
//  RtSDKDemo
//
//  Created by Sheng on 2017/11/14.
//  Copyright © 2017年 gensee. All rights reserved.
//

#import "GSVodChatModel.h"
#import <GSCommonKit/GSChatContentParse.h>

#define WIDTH (MIN([UIScreen mainScreen].bounds.size.width, [UIScreen mainScreen].bounds.size.height) - 20)

@implementation GSVodChatModel

- (instancetype)initWithModel:(VodChatInfo*)obj{
    if (self = [super init]) {
        
        if (obj) {
            self.info = obj.senderName;
            self.infoHeight = [GSBaseModel heightWithString:self.info LabelFont:[UIFont boldSystemFontOfSize:18.f] withLabelWidth:WIDTH];
            
            NSAttributedString *attribute = [[GSChatContentParse sharedInstance] attributeStringFromHtml:obj.text textFont:[UIFont fontWithName:@"Heiti SC" size:14.f] imageType:@"png"];
            
            self.message = attribute;

            CGRect rect = [self.message boundingRectWithSize:CGSizeMake(WIDTH, CGFLOAT_MAX) options:NSStringDrawingUsesLineFragmentOrigin|NSStringDrawingUsesFontLeading context:nil];
            self.messageHeight = rect.size.height;
            self.msgID = obj.chatid;
            self.chatMessage = obj;
//            
//            NSDate *currentDate = [NSDate date:obj.timestamp];
//            NSDateFormatter *dateFormatter = [[NSDateFormatter alloc] init];
//            [dateFormatter setDateFormat:@"HH:mm:ss"];
//            NSString *dateString = [dateFormatter stringFromDate:currentDate];
            int hours = obj.timestamp/60/60;

            if(hours > 48){
                NSDateFormatter *formatter = [[NSDateFormatter alloc] init];
                NSTimeZone* timeZone = [NSTimeZone timeZoneWithName:@"Asia/Beijing"];
                [formatter setTimeZone:timeZone];
                [formatter setDateFormat:@"yyyy-MM-dd HH:mm:ss"];
             
                NSString * messageTime =  [formatter stringFromDate:[NSDate dateWithTimeIntervalSince1970:obj.utctimestamp]];
                self.timeStr = messageTime;
                
            }else{
                self.timeStr = [self timeFormat:obj.timestamp*1000];

            }
        }
       
        self.totalHeight = self.infoHeight + self.messageHeight;
        
    }
    return self;
}

- (NSString*)timeFormat:(int)time {
    int t = time;
    int hours = t/1000/60/60;
    int minutes = (t/1000/60)%60;
    int seconds = (t/1000)%60;
    return [NSString stringWithFormat:@"%02d:%02d:%02d",hours,minutes,seconds];
    
}



@end
