//
//  GSUserInfo.h
//  RtSDK
//
//  Created by Gaojin Hsu on 3/12/15.
//  Copyright (c) 2015 Geensee. All rights reserved.
//

#import <Foundation/Foundation.h>
#define UC_ROSTER_INFO_ORIG_KEY @"originfo"
#define UC_ROSTER_INFO_DBL_TEACHER_KEY @"dblteacher"
/**
 * 用户在直播中的身份
 */
typedef NS_ENUM(NSInteger, GSUserRole) {
    /**
     *  组织者
     */
    GSUserRoleOrganizer = 1 << 0,
    /**
     *  主讲人
     */
    GSUserRoleLecturer = 1 << 1,
    /**
     *  嘉宾
     */
    GSUserRolePanelist = 1 << 2,
    /**
     *  普通参加者
     */
    GSUserRoleAttendee = 1 << 3,
    /**
     *  普通参加者web用户
     */
    GSUserRoleAttendeeWeb = 1 << 4,
    
    /**
     *插播用户
     */
    GSUserRoleLod = 0x20
};


/**
 *   用户使用的平台
 */
typedef NS_ENUM(NSInteger, GSUserType){
    
    /**
     *   PC 客户端
     */
    GSUserTypePCClient = 0,
    
    /**
     *   Web 嵌入flash
     */
    GSUserTypeWebHttpFlash = 1,   //pc web, flv( flash ) + data( rtmp )
    
    /**
     *   纯http
     */
    GSUserTypeWebHttp = 2,  //pc web, flv( flash ) + data( http/websocket )
    
    /**
     *   iPad web
     */
    GSUserTypeIPadWeb = 3,
    
    /**
     *   iPhone web
     */
    GSUserTypeIPhoneWeb = 4,
    
    /**
     *   Adroid pad web
     */
    GSUserTypeAndroidPadWeb = 5,
    
    /**
     *   Android phone web
     */
    GSUserTypeAndroidPhoneWeb = 6,
    
    /**
     *   iPad app
     */
    GSUserTypeIPadApp = 7,
    
    /**
     *   iPhone app
     */
    GSUserTypeIPhoneApp = 8,
    
    /**
     *   Android pad app
     */
    GSUserTypeAndroidPadApp = 9,
    
    /**
     *   Android phone app
     */
    GSUserTypeAndroidPhoneApp = 10,
    
    /**
     *   Mac client
     */
    GSUserTypeMacClient = 11,
    
    /**
     *   Telephone
     */
    GSUserTypeTelephone = 12,
    
    /**
     *   web flash
     */
    GSUserTypeFlash = 13,
    
    /**
     *  mobile sdk
     */
    GSUserTypeMobileSDK = 14,
    
    /**
     *  pc sdk
     */
    GSUserTypePCSDK = 15,
    
    /**
     *  ios playerSDK
     */
    GSUserTypeIOSPlayerSDK = 16,
    
    /**
     *  android playerSDK
     */
    GSUserTypeAndroidPlayerSDK = 17,
    
    GSUserTypeWinPlayerSDK = 18,
    
    GSUserTypeClientPexip = 19,// pexip video clint
    
    UGSUserTypeAndroidPlayerSDKTV =20,
    
    GSUserTypeIOSPlaySDKTV =21,
    
    GSUserTypeWebH5 = 22  //pc web, flv(H5) + data( http/websocket )
    
};

/**
 *   用户使用的平台
 */
typedef NS_ENUM(NSUInteger, GSUserStatus){
    GSRT_HAVE_AUDIO = (1<<0),    //1
    GSRT_HAVE_VIDEO = (1<<1), //2
    GSRT_OPEN_AUDIO = (1<<2), //4
    GSRT_OPEN_VIDEO = (1<<3), //8
    GSRT_MUTE_AUDIO = (1<<4), //16
    GSRT_MUTE_VIDEO = (1<<5),
    GSRT_REQUEST_UPGRADE = (1<<6),
    GSRT_MUTE_CHAT  = (1<<7),
    GSRT_ATTENTION  = (1<<8),
    GSRT_ROLLCALL1 = (1<<9),
    GSRT_ROLLCALL2 = (1<<10),
    GSRT_WEB_AUDIO_INVITING = (1<<11),
    GSRT_WEB_AUDIO = (1<<12),
    GSRT_ACTIVED_VIDEO = (1<<13),
    GSRT_REQUEST_WEBVOICE = (1<<14),
    GSRT_HANDUP = (1<<15),
    GSRT_WEB_VIDEO_INVITING = (1<<16),
    GSRT_WEB_VIDEO = (1<<17),
    GSRT_ANNOTATION = (1<<18),

    GSRT_APPLY_MASK = 0xffff0000,
};


/**
 *  插播视频的ID，插播视频的ID是固定的，其他摄像头视频的ID是对应用户的userID
 */
#define LOD_USER_ID (0x7f00000000000000)






/**
 *  直播中的用户信息类
 */
@interface GSUserInfo : NSObject

/**
 *  用户ID
 */
@property(assign, nonatomic)long long userID;

/**
 *  用户名
 */
@property(strong, nonatomic)NSString* userName;


/**
 *用户角色实际的值
 */
@property(assign, nonatomic)int userRole;

/**
 *  用户角色
 *  @see  GSUserRole
 */
@property(assign, nonatomic)GSUserRole role DEPRECATED_MSG_ATTRIBUTE("已经有单独的属性判断各种角色，该值判断角色不准确");

/**
 *  用户状态
 *  如麦克风是否打开等状态
 */
@property(assign, nonatomic)unsigned status;

/**
 *  用户使用平台类型
 *  @see GSUserType
 */
@property(assign, nonatomic)GSUserType userType;

@property(assign, nonatomic)long long Order;

/**
 *权限
 */
@property(assign, nonatomic)long long pri;


#pragma mark - room state

/**
 *  用户是否有麦克风设备
 */
@property (assign, nonatomic)BOOL hasMicrophone;

/**
 *  用户是否有摄像头设备
 */
@property (assign, nonatomic)BOOL hasCamera;
/**
 *  用户麦克风是否打开
 */
@property (assign, nonatomic)BOOL isMicrophoneOpen;
/**
 *  麦克风是否静音
 */
@property (assign, nonatomic)BOOL isMicrophoneMute;
/**
 *  摄像头是否打开
 */
@property (assign, nonatomic)BOOL isCameraOpen;

@property (assign, nonatomic)BOOL isCameraMute;

/**
 *  此用户的视频是否为直播视频
 */
@property (assign, nonatomic)BOOL isVideoActivated;
/**
 *  该用户是否举手
 */
@property (assign, nonatomic)BOOL isHandup;
/**
 *  该用户是否被禁止聊天或提问
 */
@property (assign, nonatomic)BOOL isChatForbidden;

/**
 *该用户是否有标注权限
 */
@property (assign, nonatomic) BOOL isAnnotation;



@property (assign, nonatomic)BOOL isRollcall_1;

@property (assign, nonatomic)BOOL isRollcall_2;

/**
 *web用户语音邀请中
 */
@property (assign, nonatomic)BOOL isWebAudioInvite;


/**
 *web用户是否打开了MIC
 */
@property (assign, nonatomic)BOOL isWebAudio;


@property (assign, nonatomic)BOOL isRequestUpgrade;
@property (assign, nonatomic)BOOL isRequestVoice;

/**
 *web用户视频邀请中
 */
@property (assign, nonatomic)BOOL isWebVideoInvite;

/**
 *web用户是否打开了视频
 */
@property (assign, nonatomic)BOOL isWebVideo;




#pragma mark - role 角色相关
@property (assign, nonatomic) BOOL isOrganizer; //判断是否为组织者
@property (assign, nonatomic) BOOL isPresentor;//判断是否为主讲人
@property (assign, nonatomic) BOOL isPanelist; //是否为嘉宾
@property (assign, nonatomic) BOOL isAttendee; //是否为参加者
@property (assign, nonatomic) BOOL isAttendeeWeb; //是否为web参加者
@property (assign, nonatomic) BOOL isLodUser; //是否为插播用户
@property (assign, nonatomic) BOOL isMiniClassTeacher;//是否为小小班老师

/**
 *用户权限相关
 */
@property (assign, nonatomic, readonly) BOOL isCanDocCreate;
@property (assign, nonatomic, readonly) BOOL isCanDocAnno;
@property (assign, nonatomic, readonly) BOOL isCanDocSyncPage;
@property (assign, nonatomic, readonly) BOOL isCanVideoOpenSelf;
@property (assign, nonatomic, readonly) BOOL isCanVideoSetMain;
@property (assign, nonatomic, readonly) BOOL isCanAudioOpenSelf;
@property (assign, nonatomic, readonly) BOOL isCanASOpen;
@property (assign, nonatomic, readonly) BOOL isCanChatPublic;
@property (assign, nonatomic, readonly) BOOL isCanChatPrivate;
@property (assign, nonatomic, readonly) BOOL isCanVoteCreateDel;
@property (assign, nonatomic, readonly) BOOL isCanVotePublish;
@property (assign, nonatomic, readonly) BOOL isCanVotePublishResult;
@property (assign, nonatomic, readonly) BOOL isCanVoteVote;
@property (assign, nonatomic, readonly) BOOL isCanVotePublishPopup;
@property (assign, nonatomic, readonly) BOOL isCanQAReply;
@property (assign, nonatomic, readonly) BOOL isCanQAPublish;
@property (assign, nonatomic, readonly) BOOL isCanLvodBeginEnd;
@property (assign, nonatomic, readonly) BOOL isCanUserShowOverview;
@property (assign, nonatomic, readonly) BOOL isCanUserCtrlOtherMedia;
@property (assign, nonatomic, readonly) BOOL isCanUserGrantRole;
@property (assign, nonatomic, readonly) BOOL isCanUserAllowUpgradeFromWeb;
@property (assign, nonatomic, readonly) BOOL isCanUserKickout;
@property (assign, nonatomic, readonly) BOOL isCanGlobalCtrlBroadcast;
@property (assign, nonatomic, readonly) BOOL isCanGlobalCtrlRecord;;
@property (assign, nonatomic, readonly) BOOL isCanGlobalSwitchLayoutOnWeb;
@property (assign, nonatomic, readonly) BOOL isCanGlobalLiveText;
@property (assign, nonatomic, readonly) BOOL isCanGlobalMessage;
@property (assign, nonatomic, readonly) BOOL isCanGlobalLottery;
@property (assign, nonatomic, readonly) BOOL isCanVideoWatchWall;
@property (assign, nonatomic, readonly) BOOL isCanQADispatchQuestion;
@property (assign, nonatomic, readonly) BOOL isCanDocChangePage;
@property (assign, nonatomic, readonly) BOOL isCanVoiceChat;

#pragma mark - clientType
-(BOOL) IsPcClient;
-(BOOL) IsMacClient;
-(BOOL) IsWebClient;
-(BOOL) IsPlaySDK;
-(BOOL) isWebHttpClient ;
-(BOOL) isIPadWebClient;
-(BOOL) isIPhoneWebClient;
-(BOOL) isAndroidPadWebClient;
-(BOOL) isAndroidPhoneWebClient;
-(BOOL) isAndroidPadClient;
-(BOOL) isAndroidPhoneClient;
-(BOOL) isIPadClient;
-(BOOL) isIPhoneClient;

#pragma mark - other
@property (copy, nonatomic) NSString *userData;

@property(copy, nonatomic) NSString *groupCode;

@end
