//
//  GSVodInfo.h
//  PlayerSDKDemo
//
//  Created by 张俞 on 2023/8/8.
//  Copyright © 2023 Geensee. All rights reserved.
//

#import <Foundation/Foundation.h>

NS_ASSUME_NONNULL_BEGIN

@protocol GSVodInfoPlayerDelegate <NSObject>
/**
 * 点播播放器创建成功回调
 */
- (void)onVodPlayeronInitWithDuration:(int)duration;

/**
 * 自动播放完成停止通知，
 */
- (void) onStop;

/**
 * 进度通知
 * @param position 当前播放进度
 */
- (void) onPosition:(int) position;

///首帧耗时回调
- (void)onFirstVideoUsedTime:(double)time;

@end

@protocol GSVodInfoDelegate <NSObject>
/**
 * 点播播放器创建结果回调
 */
- (void)onVodPlayerCreate:(BOOL)isSuccess Row:(NSInteger)row Error:(int)error;

/*
 *监听video 的开始
 */
- (void)onVideoStartWithRow:(NSInteger)row;

/*
 *监听video的结束
 */
-(void)onVideoEndWithRow:(NSInteger)row;

@end
@interface GSVodInfo : NSObject
/// 初始化
- (instancetype)initWith:(NSString *)domain nickName:(NSString *)nickName serviceType:(GSBroadcastServiceType)serviceType roomNumber:(NSString *)roomNumber watchPassword:(NSString *)watchPassword;

/// 用参数对象初始化
- (instancetype)initWitParam:(GSConnectInfo *)params;

/// 用于请求点播信息的参数对象
@property (nonatomic, strong) GSConnectInfo * params;

/// 点播对象
@property (nonatomic, strong) GSVodObject * vodObj;

@property (nonatomic, strong) downItem * item;


@property (nonatomic, weak) id<GSVodInfoPlayerDelegate> playerDelegate;
@property (nonatomic, weak) id<GSVodInfoDelegate> vodInfoDelegate;

/// 创建播放器是否成功
@property (nonatomic, assign) BOOL isCreatePlayerSuccess;

/// 第几个点播
@property (nonatomic, assign) NSInteger row;

/// 视频总时长
@property (nonatomic, assign) int duration;

/// 是否播放
@property (nonatomic, assign) BOOL isPlay;
/// 是否关闭视频
@property (nonatomic, assign) BOOL isClosedVideo;
/// 是否有视频
@property (nonatomic, assign) BOOL isHaveVideo;

/// 请求点播item，并创建播放器
- (void)requestVodItemAndCreatePlayer;

/// 销毁播放器
- (void)destroyVodPlayer;
/// 首帧耗时
@property (nonatomic, assign) double firstVideoUsedTime;


@end

NS_ASSUME_NONNULL_END
