//
//  GSVideoViewController.m
//  PlayerSDKDemo
//
//  Created by Sheng on 2018/8/15.
//  Copyright © 2018年 Geensee. All rights reserved.
//

#import "GSVideoViewController.h"
#import "UIView+GSSetRect.h"
#import "UIAlertController+Blocks.h"
#import <GSCommonKit/GSCommonKit.h>
#import "InfoEditViewController.h"
#import <UserNotifications/UserNotifications.h>
#import "GSVodTools.h"

@interface GSVideoViewController () <GSPPlayerManagerDelegate,GSDocViewDelegate,UITableViewDelegate,UITableViewDataSource>

@property (nonatomic, strong) UIView *videoArea;
@property (nonatomic, strong) UIView *cameraArea;
@property (nonatomic, strong) UIView *docArea;

@property (nonatomic, strong) GSPVideoView *videoView;
@property (nonatomic, strong) GSPVideoView *preView;

@property (nonatomic, strong) GSDocView *docView;
@property (nonatomic, weak) GSPUserInfo *userInfo;

//audioPlayer test
@property (nonatomic, strong) AVAudioPlayer *audioPlayer;
@property (nonatomic, strong) GSTagsContentView* tagContent;
@property (nonatomic, strong) UILabel *layoutShow;
@property (nonatomic, strong) UITextField *textfield;
@property (nonatomic, strong) NSTimer *micLevelTimer;

@property (nonatomic, strong) UITableView * netWorkTableView;
@property (nonatomic, strong) NSMutableArray * networkDataArray;
/// 缓冲次数
@property (nonatomic, assign) NSInteger bufferCount;

@property (nonatomic, assign) BOOL isCloseVideo;
@property (nonatomic, assign) BOOL isCloseAudio;
@property (nonatomic, strong) UIButton * stopScrollButton;

@property (nonatomic, strong) UILabel * memoryLabel;
@property (nonatomic, strong, nullable) dispatch_source_t requestTimer;

@property (nonatomic, strong) NSMutableString * logTextStr;
@property (nonatomic, assign) CGFloat scrollHeight;

@end

@implementation GSVideoViewController
{
    BOOL bRate;
    //结构体 位域
    struct {
        unsigned int isFullScreen : 1;  //是否全屏 1位
        unsigned int isDocFullScreen : 1;
        unsigned int isVideoFullScreen : 1;
    } _state;
}
- (void)viewDidLoad {
    [super viewDidLoad];
    self.logTextStr = [[NSMutableString alloc] init];
    [[NSNotificationCenter defaultCenter] addObserver:self selector:@selector(addTestMessage:) name:@"GSPPlayerManagerTestMessageNoti" object:nil];
    // Do any additional setup after loading the view.
//    self.navigationItem.rightBarButtonItem = [[UIBarButtonItem alloc]initWithTitle:@"切换比特率(Normal)" style:UIBarButtonItemStyleDone target:self action:@selector(switchRate:)];
    
    UIBarButtonItem * idcButton = [[UIBarButtonItem alloc]
                               initWithTitle:@"优选网络"
                               style:UIBarButtonItemStylePlain
                               target:self
                               action:@selector(switchNetSub:)];

    UIBarButtonItem * cdnButton = [[UIBarButtonItem alloc]
                               initWithTitle:@"切换线路"
                               style:UIBarButtonItemStylePlain
                               target:self
                               action:@selector(switchNetSub:)];

    self.navigationItem.rightBarButtonItems = @[idcButton, cdnButton];

    CGFloat top = 64 + 5 + UIView.additionaliPhoneXTopSafeHeight;
        
    _videoArea = [[UIView alloc] initWithFrame:CGRectMake(5, top, Width - 10, (Width - 10)*9/16)];
    _videoArea.backgroundColor = [UIColor groupTableViewBackgroundColor];
    [self.view addSubview:_videoArea];
    top = _videoArea.bottom + 10;

    
    self.videoView = [[GSPVideoView alloc]initWithFrame:_videoArea.bounds renderMode:GSVideoRenderOpenGL];
    self.videoView.translatesAutoresizingMaskIntoConstraints = NO;
    self.videoView.clipsToBounds = YES;
    self.videoView.contentMode = self.contentMode;

    [self.videoArea addSubview:_videoView];
    
    //to fix autolayout case if you need
    [_videoArea addConstraints:[NSLayoutConstraint constraintsWithVisualFormat:@"V:|[_videoView]|" options:0 metrics:nil views:NSDictionaryOfVariableBindings(_videoView)]];
    [_videoArea addConstraints:[NSLayoutConstraint constraintsWithVisualFormat:@"H:|[_videoView]|" options:0 metrics:nil views:NSDictionaryOfVariableBindings(_videoView)]];
    
    UITapGestureRecognizer *tapGR = [[UITapGestureRecognizer alloc]initWithTarget:self action:@selector(tapAction:)];
    tapGR.numberOfTapsRequired = 2;
    [_videoArea addGestureRecognizer:tapGR];
    self.manager.videoView = _videoView;
    
    _cameraArea = [[UIView alloc] initWithFrame:CGRectMake(5, top, Width/2 - 10, (Width/2 - 10)*3/4)];
    //    _cameraArea.layer.cornerRadius         = 3.f;
    _cameraArea.layer.borderColor          = UICOLOR16(0x009BD8).CGColor;
    _cameraArea.layer.borderWidth          = 0.5f;
    _cameraArea.backgroundColor = [UIColor groupTableViewBackgroundColor];
    [self.view addSubview:_cameraArea];
    
    
    _docArea = [[UIView alloc] initWithFrame:CGRectMake((Width/2 - 10) + 10, top, Width/2 - 10, (Width/2 - 10)*3.0/4)];
    _docArea.layer.borderColor          = UICOLOR16(0x009BD8).CGColor;
    _docArea.layer.borderWidth          = 0.5f;
    _docArea.backgroundColor = [UIColor groupTableViewBackgroundColor];
    [self.view addSubview:_docArea];
    _docView = [[GSDocView alloc]initWithFrame:_docArea.bounds];
    _docView.translatesAutoresizingMaskIntoConstraints = NO;
    //    [_docView setBackgroundColor:0.5 green:0.5 blue:0];
    self.docView.showMode = GSDocViewShowModeWidthFit;
    [_docArea addSubview:_docView];
    self.docView.delegate = self;
    
    
    
    //to fix autolayout case if you need
    [_docArea addConstraints:[NSLayoutConstraint constraintsWithVisualFormat:@"V:|[_docView]|" options:0 metrics:nil views:NSDictionaryOfVariableBindings(_docView)]];
    [_docArea addConstraints:[NSLayoutConstraint constraintsWithVisualFormat:@"H:|[_docView]|" options:0 metrics:nil views:NSDictionaryOfVariableBindings(_docView)]];
    
    UITapGestureRecognizer *tapGR1 = [[UITapGestureRecognizer alloc]initWithTarget:self action:@selector(docTapAction:)];
    tapGR1.numberOfTapsRequired = 2;
    [_docArea addGestureRecognizer:tapGR1];
    top = top + _docArea.height + 5;
    // 注意下列代码的顺序
    NSLog(@"self.docView=%@",self.docView);  //打印一下
    self.manager.docView = self.docView;
    __weak typeof(self) wself = self;  //must use wself

    _tagContent = [[GSTagsContentView alloc] initWithFrame:CGRectMake(5, top, Width - 10, 30) tags:@[@"修改昵称",@"播放音频文件Wav测试",@"推出Navigation视图",@"切换前后摄像头",@"接收前台通知",@"远端视频:开启",@"远端音频:开启"] handler:^(NSInteger index, NSString *text, BOOL isSelect) {
        switch (index) {
            case 0:
                {
                    if (wself.userInfo) {
                        InfoEditViewController *new = [[InfoEditViewController alloc] initWithChangeInfo:wself.userInfo.userName Completion:^(NSString *result) {
                            BOOL success = [[GSPPlayerManager sharedManager] changeuserName:result];
                            if (success) {
                                dispatch_async(dispatch_get_main_queue(), ^{
                                    [MBProgressHUD showHint:@"修改成功"];
                                });
                            }
                        }];
                        [wself.navigationController pushViewController:new animated:YES];
                    }else{
                        dispatch_async(dispatch_get_main_queue(), ^{
                            [MBProgressHUD showHint:@"还在加入直播中..."];
                        });
                    }

                }
                break;
            case 1:
            {
                if (!wself.audioPlayer) {
                    NSString *soundPath = [[NSBundle mainBundle]pathForResource:@"shake_something" ofType:@"wav"];
                    NSURL *soundUrl = [NSURL fileURLWithPath:soundPath];
                    //初始化播放器对象
                    wself.audioPlayer = [[AVAudioPlayer alloc]initWithContentsOfURL:soundUrl error:nil];
                    //设置声音的大小
                    wself.audioPlayer.volume = 0.5;//范围为（0到1）；
                    //设置循环次数，如果为负数，就是无限循环
                    wself.audioPlayer.numberOfLoops = 1;
                    //设置播放进度
                    wself.audioPlayer.currentTime = 0;
                    //准备播放
                }

                [wself.audioPlayer prepareToPlay];
                [wself.audioPlayer play];
            }
                break;
            case 2:
            {
                UIViewController *test = [[UIViewController alloc] init];
                [wself.navigationController pushViewController:test animated:YES];
            }
                break;
            case 3:
            {
                [[GSPPlayerManager sharedManager] rotateCamera];
            }
                break;
            case 4:
            {
                UNMutableNotificationContent *content = [[UNMutableNotificationContent alloc] init];
                content.title = @"测试通知";
                content.body = @"这是一条测试通知";
                //            content.userInfo = @"userInfo111";
                content.sound = [UNNotificationSound defaultSound];
                //            ios 12 后失败，会导致闪退
                //            [content setValue:@(YES) forKeyPath:@"shouldAlwaysAlertWhileAppIsForeground"];
                
                UNNotificationRequest *request = [UNNotificationRequest requestWithIdentifier:@"Notif" content:content trigger:nil];
                [[UNUserNotificationCenter currentNotificationCenter] addNotificationRequest:request withCompletionHandler:^(NSError * _Nullable error) {
                }];
            }
                break;
            case 5:{
                if(self.isCloseVideo){
                    [_tagContent changedLabelTextWithTag:5 NewText:@"远端视频:开启"];
                }else{
                    [_tagContent changedLabelTextWithTag:5 NewText:@"远端视频:关闭"];
                }
                [[GSPPlayerManager sharedManager] enableVideo:self.isCloseVideo];
                self.isCloseVideo = !self.isCloseVideo;

            }
                break;
                
            case 6:{
                if(self.isCloseAudio){
                    [_tagContent changedLabelTextWithTag:6 NewText:@"远端音频:开启"];
                }else{
                    [_tagContent changedLabelTextWithTag:6 NewText:@"远端音频:关闭"];
                }
                [[GSPPlayerManager sharedManager] enableAudio:self.isCloseAudio];
                self.isCloseAudio = !self.isCloseAudio;

            }
                break;
            default:
                break;
        }
    }];
    [self.view addSubview:_tagContent];
    
    UITextField *textfield = [[UITextField alloc] initWithFrame:CGRectMake(5, _tagContent.bottom + 5, Width - 10, 30)];
    textfield.borderStyle = UITextBorderStyleLine;
    [self.view addSubview:textfield];
    _textfield = textfield;
    [[NSNotificationCenter defaultCenter] addObserver:self selector:@selector(rotationAction) name:UIApplicationDidChangeStatusBarFrameNotification object:nil];
    
    _layoutShow = [[UILabel alloc] initWithFrame:CGRectMake(10, 74, 40, 20)];
    _layoutShow.layer.cornerRadius = 5;
    _layoutShow.clipsToBounds = YES;
    _layoutShow.textAlignment = NSTextAlignmentCenter;
    _layoutShow.userInteractionEnabled = NO;
    _layoutShow.backgroundColor = [UIColor whiteColor];
    _layoutShow.text = @"布局显示";
    _layoutShow.font = [UIFont systemFontOfSize:14.f];
    _layoutShow.textColor = [UIColor blackColor];
    [_layoutShow sizeToFit];
    _layoutShow.width += 5;
    _layoutShow.height += 5;
    [self.view addSubview:_layoutShow];
    
    
    self.logTextView = [[UITextView alloc] initWithFrame:CGRectMake(5, _textfield.bottom + 5, Width - 10, Height - _textfield.bottom - 20)];
    self.logTextView.editable = NO;
    self.logTextView.textColor = [UIColor blackColor];
    self.logTextView.backgroundColor = [UIColor whiteColor];
    self.logTextView.font = [UIFont systemFontOfSize:13];
    [self.view addSubview:self.logTextView];
    
    self.stopScrollButton = [[UIButton alloc] initWithFrame:CGRectMake(self.logTextView.frame.size.width - 100, self.logTextView.frame.origin.y , 80, 40)];
    self.stopScrollButton.titleLabel.font = [UIFont systemFontOfSize:14];
    [self.stopScrollButton setTitle:@"停止滚动" forState:UIControlStateNormal];
    [self.stopScrollButton setTitle:@"继续滚动" forState:UIControlStateSelected];
    [self.stopScrollButton setTitleColor:[UIColor whiteColor] forState:UIControlStateNormal];
    self.stopScrollButton.backgroundColor = [UIColor blueColor];
    [self.stopScrollButton addTarget:self action:@selector(clickStopScrollButton:) forControlEvents:UIControlEventTouchUpInside];
    [self.view addSubview:self.stopScrollButton];
    
    [self addLogMessage:[NSString stringWithFormat:@"请求开始，选择的是 %@",self.param.playerType == GSBroadcastPlayerTypeHLS?@"HLS":@"RTMP"]];
    
    [self createMemoryTimer];

}
- (void)clickStopScrollButton:(UIButton *)sender{
    self.stopScrollButton.selected = !self.stopScrollButton.selected;
}
#pragma mark -- sdk通知的测试日志，用于测试
- (void)addTestMessage:(NSNotification *)noti{
    dispatch_async(dispatch_get_main_queue(), ^{
        NSString * notiStr = noti.object;
        [self addLogMessage:[NSString stringWithFormat:@"[TestLog] %@",notiStr]];
    });
   
}
#pragma mark -- 添加日志
- (void)addLogMessage:(NSString *)logMessage{
    dispatch_async(dispatch_get_main_queue(), ^{
        NSDateFormatter *fmt = [[NSDateFormatter alloc] init];
        [fmt setDateFormat:@"HH:mm:ss"];
        NSDate *currentDate = [NSDate date];
        NSString * currentTime = [fmt stringFromDate:currentDate];
        [self.logTextStr appendString:[NSString stringWithFormat:@"[%@] %@\n",currentTime,logMessage]];
        self.logTextView.text = self.logTextStr;

        if(!self.stopScrollButton.selected){
            [self scrollToBottomOfTextView:self.logTextView animated:NO];
        }
    });
}
- (void)scrollToBottomOfTextView:(UITextView *)textView animated:(BOOL)animated {
    if (!textView || textView.text.length == 0) {
        return;
    }
    dispatch_async(dispatch_get_main_queue(), ^{
        // 计算可滚动的高度
        CGFloat scrollHeight = textView.contentSize.height - textView.bounds.size.height + textView.contentInset.bottom;
        if(scrollHeight <= self.scrollHeight){
            scrollHeight = self.scrollHeight + 40;
        }else{
            self.scrollHeight = scrollHeight;
        }
        // 确保不会滚动到负值位置
        if (self.scrollHeight > 0) {
            [textView setContentOffset:CGPointMake(0, self.scrollHeight) animated:animated];
        } else {
            [textView setContentOffset:CGPointZero animated:animated];
        }
    });
}

- (void)rotationAction {
    UIInterfaceOrientation statusOrient = [UIApplication sharedApplication].statusBarOrientation;
    
    if (statusOrient == UIInterfaceOrientationLandscapeRight){
        _state.isFullScreen = 1;
        [self.manager setCameraOrientation:YES];
        
//        _display.hidden = YES;
//        _speaker.hidden = YES;
        
        self.navigationController.navigationBar.hidden = YES;
        CGRect full = CGRectMake(0, 0, Width, Height);
        CGRect lsmall = CGRectMake(5, 5, Width/3 - 10, (Width/3 - 10)*3.0/4);
        CGRect rsmall = CGRectMake(Width - (Width/3 - 10) - 5, 5, Width/3 - 10, (Width/3 - 10)*3.0/4);
        if (_state.isVideoFullScreen) {
            _videoArea.frame = full;
            _cameraArea.frame = lsmall;
            _docArea.frame = rsmall;
            [self.view bringSubviewToFront:_docArea];
            [self.view bringSubviewToFront:_cameraArea];
        }else if (_state.isDocFullScreen){
            _docArea.frame = full;
            _cameraArea.frame = lsmall;
            _videoArea.frame = rsmall;
            [self.view bringSubviewToFront:_videoArea];
            [self.view bringSubviewToFront:_cameraArea];
        }
//        _videoView.frame = _videoArea.bounds;
        _preView.frame = _cameraArea.bounds;
//        _docView.frame = _docArea.bounds;
        
        _layoutShow.x = 10;
        _layoutShow.y = 30;
        
        [self.view bringSubviewToFront:_layoutShow];
    }else if (statusOrient == UIInterfaceOrientationPortrait){
        _state.isFullScreen = 0;
        [[UIApplication sharedApplication] setStatusBarHidden:NO];
        [self.manager setCameraOrientation:NO];
        self.navigationController.navigationBar.hidden = NO;
        CGFloat top = 64 + 5 + UIView.additionaliPhoneXTopSafeHeight;
        _videoArea.frame = CGRectMake(5, top, Width - 10, (Width - 10)*3.0/4);
//        _videoView.frame = _videoArea.bounds;
        top = _videoArea.bottom + 5;
        _cameraArea.frame = CGRectMake(5, top, Width/2 - 10, (Width/2 - 10)*3.0/4);
        _preView.frame = _cameraArea.bounds;
        _docArea.frame = CGRectMake((Width/2 - 10) + 10, top, Width/2 - 10, (Width/2 - 10)*3.0/4);
//        _docView.frame = _docArea.bounds;
        _tagContent.top = _docArea.bottom + 5;
        _textfield.top = _tagContent.bottom + 5;
        _layoutShow.x = 10;
        _layoutShow.y = 74;
        [self.view bringSubviewToFront:_layoutShow];
    }
    
}

- (void)tapAction:(UIGestureRecognizer *)sender {
    if (_state.isDocFullScreen) {
        return;
    }
    if (_state.isFullScreen) {
        _state.isVideoFullScreen = 0;
        [self updateScreenOriention:UIDeviceOrientationPortrait];
    }else{
        _state.isVideoFullScreen = 1;
        [self updateScreenOriention:UIDeviceOrientationLandscapeLeft];
    }
}

- (void)docTapAction:(UIGestureRecognizer *)sender {
    if (_state.isVideoFullScreen) {
        return;
    }
    if (_state.isFullScreen) {
        _state.isDocFullScreen = 0;
        [self updateScreenOriention:UIDeviceOrientationPortrait];
    }else{
        _state.isDocFullScreen = 1;
        [self updateScreenOriention:UIDeviceOrientationLandscapeLeft];
    }
}

- (void)updateScreenOriention:(UIDeviceOrientation)oriention{
    if ([[UIDevice currentDevice] respondsToSelector:@selector(setOrientation:)]) {
        SEL selector = NSSelectorFromString(@"setOrientation:");
        NSInvocation *invocation = [NSInvocation invocationWithMethodSignature:[UIDevice instanceMethodSignatureForSelector:selector]];
        [invocation setSelector:selector];
        [invocation setTarget:[UIDevice currentDevice]];
        int val = oriention;
        [invocation setArgument:&val atIndex:2];
        [invocation invoke];
    }
}

- (void)didPlayerJoinSuccess {
    self.bufferCount = 0;
    _userInfo = [GSPPlayerManager sharedManager].selfUserInfo;
    self.netWorkTableView.hidden = YES;

}
- (void)playerManager:(GSPPlayerManager *)playerManager onCDNConfig:(GSPCDNConfig *)cdnConfig{
    self.cdnConfig = cdnConfig;
    if(cdnConfig.isUseCdn){
        [self addLogMessage:[NSString stringWithFormat:@"当前使用的CDN线路为：%@",cdnConfig.usingCdnLine]];
    }else{
        [self addLogMessage:@"当前没有使用CDN模式"];
    }
}

- (void)didPlayerleave {
    self.tagContent.handler = nil;
    self.tagContent = nil;
    
    if(self.requestTimer){
        dispatch_cancel(self.requestTimer);
        self.requestTimer = nil;
    }
    if(self.micLevelTimer)
    {
        [self.micLevelTimer invalidate];
        self.micLevelTimer = nil;
    }
    _videoView = nil;
    if (self.audioPlayer) {
        [self.audioPlayer stop];
        self.audioPlayer = nil;
    }
    _preView = nil;
    _userInfo = nil;
    [GSPPlayerManager sharedManager].videoView = nil;
}

- (void)switchRate:(id)sender
{
    [self.manager getUserInfoById:@[[NSNumber numberWithLongLong:self.manager.selfUserInfo.userID]]];
    
    bRate = !bRate;
    [self.manager switchRate:bRate?GSRateLow:GSRateNormal];
    
    if (bRate) {
        self.navigationItem.rightBarButtonItem.title = @"切换比特率(Low)";
    }else{
        self.navigationItem.rightBarButtonItem.title = @"切换比特率(Normal)";
    }
}
#pragma mark --- 切换节点
- (void)switchNetSub:(id)sender{
    UIBarButtonItem * item = (UIBarButtonItem *)sender;
    if([item.title isEqualToString:@"优选网络"]){
        self.networkDataArray = [[NSMutableArray alloc] initWithArray:[self.manager getIDCArray]];
    }else{
        self.networkDataArray = [[NSMutableArray alloc] initWithArray:self.cdnConfig.cdnLineArray];
        [self.networkDataArray addObject:@""];
        [self.networkDataArray addObject:@"cdnTest"];
    }
    CGFloat top = 64 + 5 + UIView.additionaliPhoneXTopSafeHeight + 15;
    if(self.networkDataArray.count <= 10){
        self.netWorkTableView.frame = CGRectMake(Width- 260, top, 250, self.networkDataArray.count * 40);
    }else{
        self.netWorkTableView.frame = CGRectMake(Width- 260, top, 250, 400);
    }
    [self.netWorkTableView reloadData];
    if(self.networkDataArray.count == 0){
        [MBProgressHUD showError:@"列表数据为空"];
    }else{
        self.netWorkTableView.hidden = !self.netWorkTableView.hidden;
    }
}
- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning];
    NSLog(@"GSCustomViewController -- 收到内存警告");

}

/**
 *  收到音视频邀请
 *  @param playerManager 调用该代理的直播管理实例
 *  @param type          邀请类型
 *  @param on            打开或关闭
 */
- (void)playerManager:(GSPPlayerManager *)playerManager  didReceiveMediaInvitation:(GSPMediaInvitationType)type action:(BOOL)on
{
    NSLog(@"didReceiveMediaInvitation------");
    if (GSPMediaInvitationTypeAudioOnly == type) {
        if (on) {
            [self showAlterWithType:GSPMediaInvitationTypeAudioOnly message:@"直播间邀请您语音对话"];
        }else{
//            [playerManager activateMicrophone:NO];
            [playerManager acceptMediaInvitation:NO type:type];
            if(self.micLevelTimer)
            {
                [self.micLevelTimer invalidate];
                self.micLevelTimer = nil;
            }
        }
    }else if (GSPMediaInvitationTypeVideoOnly == type) {
        if (on) {
            [self showAlterWithType:GSPMediaInvitationTypeVideoOnly message:@"直播间邀请您视频对话"];
        }else{
            [_preView removeFromSuperview];
            [playerManager acceptMediaInvitation:NO type:type];
        }
    }
}
-(void)showAlterWithType:(GSPMediaInvitationType)type message:(NSString *)message{
    [UIAlertController showAlertInViewController:self withTitle:nil  message:message cancelButtonTitle:@"取消" destructiveButtonTitle:nil otherButtonTitles:@[@"确定"] tapBlock:^(UIAlertController * _Nonnull controller, UIAlertAction * _Nonnull action, NSInteger buttonIndex) {
        if (buttonIndex==controller.cancelButtonIndex) {//取消
            if (type==GSPMediaInvitationTypeVideoOnly) {
                [_preView removeFromSuperview];
                [self.manager acceptMediaInvitation:NO type:GSPMediaInvitationTypeVideoOnly];
            }else if (type==GSPMediaInvitationTypeAudioOnly){
                [self.manager acceptMediaInvitation:NO type:GSPMediaInvitationTypeAudioOnly];
                if(self.micLevelTimer)
                {
                    [self.micLevelTimer invalidate];
                    self.micLevelTimer = nil;
                }
            }
        }else{//确认
            if (type==GSPMediaInvitationTypeVideoOnly) {
                [_preView removeFromSuperview];
                //                _videoView = nil;
                _preView = [[GSPVideoView alloc]initWithFrame:self.cameraArea.bounds];
                [self.cameraArea addSubview:_preView];
                _preView.contentMode = UIViewContentModeScaleAspectFit;
                self.manager.previewVideoView = _preView;
                [self.manager acceptMediaInvitation:YES type:GSPMediaInvitationTypeVideoOnly];
            }else if (type==GSPMediaInvitationTypeAudioOnly){
                [self.manager acceptMediaInvitation:YES type:GSPMediaInvitationTypeAudioOnly];
                if(self.micLevelTimer)
                {
                    [self.micLevelTimer invalidate];
                    self.micLevelTimer = nil;
                }
                self.micLevelTimer = [NSTimer scheduledTimerWithTimeInterval:0.1 target:self selector:@selector(micLevel:) userInfo:nil repeats:YES];

            }
        }
    }];
}

-(void)micLevel:(NSTimer*)timer{
    NSLog(@"micLevel:%d", [self.manager getCurrentAudioMicLevel]);
}

- (void)playerManager:(GSPPlayerManager *)playerManager didReceiveVideoData:(const unsigned char *)data height:(int)height width:(int)width {
    
}

- (void)playerManager:(GSPPlayerManager *)playerManager didReceiveMediaModuleFocus:(GSModuleFocusType)focus {
    if (focus == 2) {
        _state.isDocFullScreen = 1;
        _state.isVideoFullScreen = 0;
        UIInterfaceOrientation statusOrient = [UIApplication sharedApplication].statusBarOrientation;
        if (statusOrient == UIInterfaceOrientationLandscapeRight) {
            [self rotationAction];
        }else {
            [self updateScreenOriention:UIDeviceOrientationLandscapeLeft];
        }
    }else if (focus == 1) {
        _state.isVideoFullScreen = 1;
        _state.isDocFullScreen = 0;
        UIInterfaceOrientation statusOrient = [UIApplication sharedApplication].statusBarOrientation;
        
        if (statusOrient == UIInterfaceOrientationLandscapeRight) {
            [self rotationAction];
        }else {
            [self updateScreenOriention:UIDeviceOrientationLandscapeLeft];
        }
        
        
    }else if (focus == 3) {
        _state.isVideoFullScreen = 0;
        _state.isDocFullScreen = 0;
        [self updateScreenOriention:UIDeviceOrientationPortrait];
        
    }
    NSString *hint;
    switch (focus) {
        case 0:
            hint = @"文档为主(0)[暂未适配]";
            break;
        case 1:
            hint = @"视频最大化(1)";
            break;
        case 2:
            hint = @"文档最大化(2)";
            break;
        case 3:
            hint = @"视频为主(3)";
            break;
        default:
            break;
    }
    
    [_layoutShow setText:hint];
    [_layoutShow sizeToFit];
    _layoutShow.width += 5;
    _layoutShow.height += 5;
}
/**
 *  在直播中开始缓冲，会调用此代理，表示将要缓冲
 *
 *  @param playerManager 调用该代理的直播管理实例
 */
- (void)playerManagerWillBuffer:(GSPPlayerManager *)playerManager isBuffering:(BOOL)isBuffering{

}
#pragma mark -- 自动优选网络成功回调
- (void)playerManager:(GSPPlayerManager *)playerManager didAutoChangedIDCSuccess:(NSString *)currentIdcKey{
    [self addLogMessage:[NSString stringWithFormat:@"自动优选网络成功，当前节点：%@",currentIdcKey]];

}

- (void)playerManagerWillReconnect:(GSPPlayerManager *)playerManager {
    if(self.logTextView){
        [self addLogMessage:[NSString stringWithFormat:@"重连中..."]];
    }
}
- (void)playerManager:(GSPPlayerManager *)playerManager isPaused:(BOOL)isPaused{
    [self addLogMessage:isPaused?@"直播暂停":@"直播中"];

}
#pragma mark - rotation

- (UIInterfaceOrientationMask)supportedInterfaceOrientations {
    return UIInterfaceOrientationMaskPortrait|UIInterfaceOrientationMaskLandscapeRight;
}
- (UIInterfaceOrientation)preferredInterfaceOrientationForPresentation {
    return UIInterfaceOrientationPortrait|UIInterfaceOrientationLandscapeRight;
}

- (BOOL)shouldAutorotate {
    return YES;
}
- (UITableView *)netWorkTableView{
    if(_netWorkTableView == nil){
        _netWorkTableView = [[UITableView alloc] initWithFrame:CGRectMake(0, 0, 250, 200) style:UITableViewStylePlain];
        _netWorkTableView.backgroundColor = [UIColor clearColor];
        _netWorkTableView.delegate = self;
        _netWorkTableView.dataSource = self;
        _netWorkTableView.hidden = YES;
        [self.view addSubview:_netWorkTableView];
    }
    return _netWorkTableView;
}

- (void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath{
    if(tableView == self.netWorkTableView){
        id obj = self.networkDataArray[indexPath.row];
        if([obj isKindOfClass:[NSString class]]){
            NSString * cdnLine = self.networkDataArray[indexPath.row];
            __weak typeof(self) weakSelf = self;
            [self.manager setCurrentCDN:cdnLine completion:^(NSError *error) {
                __strong typeof(weakSelf) strongSelf = weakSelf;
                if(error == nil){
                    strongSelf.cdnConfig.usingCdnLine = cdnLine;
                    [strongSelf.netWorkTableView reloadData];
                    [strongSelf addLogMessage:[NSString stringWithFormat:@""@"切换%@线路成功",cdnLine]];

                }else{
                    
                    [strongSelf addLogMessage:[NSString stringWithFormat:@""@"切换%@线路失败：%@",cdnLine,error.description]];
                }
            }];
        }else{
            NSDictionary * dict = self.networkDataArray[indexPath.row];
            NSString * idcKey = [dict objectForKey:@"idcKey"];
            [self.manager setCurrentIDC:idcKey];
        }

    }

}
- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath{
    UITableViewCell * cell = [tableView dequeueReusableCellWithIdentifier:@"NetWorkTableViewCellID"];
    if(cell == nil){
        cell = [[UITableViewCell alloc] initWithStyle:UITableViewCellStyleDefault reuseIdentifier:@"NetWorkTableViewCellID"];
        cell.textLabel.textAlignment = NSTextAlignmentCenter;
        cell.selectionStyle = UITableViewCellSelectionStyleNone;
        cell.textLabel.font = [UIFont systemFontOfSize:12];
        cell.textLabel.lineBreakMode = NSLineBreakByTruncatingMiddle;
    }
    id obj = self.networkDataArray[indexPath.row];
    if([obj isKindOfClass:[NSString class]]){
        NSString * cdnLine = self.networkDataArray[indexPath.row];
        cell.textLabel.text = [NSString stringWithFormat:@"%@",cdnLine];
        if([self.cdnConfig.usingCdnLine isEqualToString:cdnLine]){
            cell.textLabel.textColor = [UIColor blueColor];
        }else{
            cell.textLabel.textColor = [UIColor blackColor];
        }
    }else{
        NSDictionary * dict = self.networkDataArray[indexPath.row];
        cell.textLabel.text = [NSString stringWithFormat:@"%@:%@",[dict objectForKey:@"idcKey"],[dict objectForKey:@"idcDescription"]];
        if([self.currentIdcKey isEqualToString:[dict objectForKey:@"idcKey"]]){
            cell.textLabel.textColor = [UIColor blueColor];
        }else{
            cell.textLabel.textColor = [UIColor blackColor];
        }
    }

    return cell;
}
- (CGFloat)tableView:(UITableView *)tableView heightForRowAtIndexPath:(NSIndexPath *)indexPath{

    return 40;
}
- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section{
    return self.networkDataArray.count;
}
#pragma mark -- 创建内存检测计时器
- (void)createMemoryTimer{
    self.memoryLabel = [[UILabel alloc] init];
    self.memoryLabel.textColor = [UIColor redColor];
    self.memoryLabel.textAlignment = NSTextAlignmentCenter;
    self.memoryLabel.frame = CGRectMake(0, 64+[GSVodTools statusBarHeight], self.view.frame.size.width , 50);
    self.memoryLabel.text = @"";
    [self.view addSubview:self.memoryLabel];
    
    dispatch_queue_t queue = dispatch_get_global_queue(DISPATCH_QUEUE_PRIORITY_DEFAULT, 0);
    self.requestTimer = dispatch_source_create(DISPATCH_SOURCE_TYPE_TIMER, 0, 0, queue);
    //开始时间
    dispatch_time_t start = dispatch_time(DISPATCH_TIME_NOW, 0 * NSEC_PER_SEC);
    //间隔时间
    uint64_t interval = 1 * NSEC_PER_SEC;//0.2 * NSEC_PER_SEC;
    dispatch_source_set_timer(self.requestTimer, start, interval, 0);
    __weak typeof(self) weakSelf = self;
    dispatch_source_set_event_handler(self.requestTimer, ^{
        __strong typeof(weakSelf) strongSelf = weakSelf;
        dispatch_async(dispatch_get_main_queue(), ^{
            strongSelf.memoryLabel.text = [NSString stringWithFormat:@"%@",[GSVodTools getCupAndMemory]];
            NSLog(@"监测 : %@",strongSelf.memoryLabel.text);
        });
    });
    dispatch_resume(self.requestTimer);
}
@end
