//
//  GSLogMonitor.m
//  PlayerSDKDemo
//
//  Created by 230222 on 2025/11/10.
//  Copyright © 2025 Geensee. All rights reserved.
//

#import "GSLogMonitor.h"

@implementation GSLogMonitor
- (instancetype)initAndStart{
    if(self = [super init]){
        _lastFileOffset = 0;
        self.logFilePath = [[GSDiagnosisInfo shareInstance] getAppLogFilePath];
        [self startMonitoring];
        
    }
    return self;
}
- (void)startMonitoring {
    // 初始化文件偏移量
    [self initLastFileOffset];
    
    // 创建定时器，每秒执行一次
    self.timer = [NSTimer scheduledTimerWithTimeInterval:1.0
                                                  target:self
                                                selector:@selector(readNewLogs)
                                                userInfo:nil
                                                 repeats:YES];
}
- (void)initLastFileOffset {
    NSFileHandle *fileHandle = [NSFileHandle fileHandleForReadingAtPath:self.logFilePath];
    if (fileHandle) {
        [fileHandle seekToEndOfFile];
        self.lastFileOffset = [fileHandle offsetInFile];
        [fileHandle closeFile];
    }
}
- (void)readNewLogs {
    NSFileHandle *fileHandle = [NSFileHandle fileHandleForReadingAtPath:self.logFilePath];
    if (!fileHandle) {
        [self.timer invalidate];
         self.timer = nil;
        return;
    }
    
    // 移动到上次读取的位置
    [fileHandle seekToFileOffset:self.lastFileOffset];
    
    // 读取新数据
    NSData *newData = [fileHandle readDataToEndOfFile];
    
    if (newData.length > 0) {
        NSString *newLogs = [[NSString alloc] initWithData:newData encoding:NSUTF8StringEncoding];
        if (newLogs) {
            // 处理新日志
            [self processNewLogs:newLogs];
            
            // 更新文件偏移量
            self.lastFileOffset = [fileHandle offsetInFile];
        }
    }
    
    [fileHandle closeFile];
}

- (void)processNewLogs:(NSString *)newLogs {
    // 按行分割日志
    NSArray *logLines = [newLogs componentsSeparatedByString:@"\n"];
    for (NSString *line in logLines) {
        if (line.length > 0) {
            if([line containsString:@"CNetHttpRequest::OnReceive"] && ([line containsString:@"m3u8"] || [line containsString:@"flv"] )){
                NSArray * lineSubArray = [line componentsSeparatedByString:@"url="];
                if(lineSubArray.count != 0){
                    NSString * text = [NSString stringWithFormat:@"%@",lineSubArray.lastObject];
                    [[NSNotificationCenter defaultCenter] postNotificationName:@"GSPPlayerManagerTestMessageNoti" object:text];
                }
            }
        }
    }
}



@end
