//
//  GSPPlayerManager+PraiseMedal.h
//  PlayerSDK
//
//  Created by net263 on 2021/7/9.
//  Copyright © 2021 Geensee. All rights reserved.
//

#import <PlayerSDK/PlayerSDK.h>

NS_ASSUME_NONNULL_BEGIN

@interface GSPPlayerManager (PraiseMedal)
//点赞勋章
@property (nonatomic, assign) BOOL medalEnabled;
@property (nonatomic, assign) BOOL praiseEnabled;

/**
 默认的打赏设置数值(在不设置打赏数目时，自动设置此值)
 */
@property (nonatomic, assign) int favour;
/**
 默认的勋章设置数值(在不设置勋章数目时，自动设置此值)
 */
@property (nonatomic, assign) int medal;



/**
 设置 点赞/勋章 的总个数
 @param strPraiseType 枚举类型 分别表示点赞和勋章类型
 @param dwTotal 总个数
 @return 是否发送设置指令成功
 */
- (BOOL)SetPraiseInfo:(GSPraiseType)strPraiseType total:(unsigned int)dwTotal;


/**
 获取 某人 的 点赞/勋章 的信息

 @param strPraiseType 枚举类型 分别表示点赞和勋章类型
 @param llUserID 用户id
 @return 是否发送指令成功
 */
- (BOOL)GetPraiseInfo:(GSPraiseType)strPraiseType llUserID:(long long )llUserID;

/**
 发送点赞/勋章 给某人
 @param strPraiseType 枚举类型 分别表示点赞和勋章类型
 @param llToUserID 自己id <发送者>
 @param strToUserName 用户名
 @param strComment 附加信息评论
 @return 是否发送指令成功
 */
- (BOOL)SendPraise:(GSPraiseType)strPraiseType userID:(long long )llToUserID strToUserName:(nonnull NSString * )strToUserName strComment:(NSString*)strComment;
/**
 获取 点赞/勋章 的总个数

 @param strPraiseType 枚举类型 分别表示点赞和勋章类型
 @return 是否发送指令成功
 */
- (BOOL)GetPraiseTotal:(GSPraiseType)strPraiseType;
/**
 获取 点赞/勋章 的排
 @param strPraiseType 枚举类型 分别表示点赞和勋章类型
 @param dwMaxUser 排名数量
 @return 是否发送指令成功
 */
- (BOOL)GetPraiseRecvList:(GSPraiseType)strPraiseType dwMaxUser:(unsigned int)dwMaxUser;



@end

NS_ASSUME_NONNULL_END
