//
//  GSAnnoType.h
//  GSDocKit
//
//  Created by net263 on 2021/6/11.
//  Copyright © 2021 gensee. All rights reserved.
//

#import <Foundation/Foundation.h>
#import <UIKit/UIKit.h>
#import "GSAnnoData.h"
NS_ASSUME_NONNULL_BEGIN
//标注的类型
typedef NS_ENUM(NSInteger, GSDocumentAnnoType){
    GSDocumentAnnoTypeNull = 0x00,//空标注
    GSDocumentAnnoTypePoint,//点标注
    GSDocumentAnnoTypeFreePen,//自由笔标注
    GSDocumentAnnoTypeCleaner,//橡皮擦
    GSDocumentAnnoTypeText,//文字标注
    GSDocumentAnnoTypeCircle,//圆标注
    GSDocumentAnnoTypeRect,//矩形标注
    GSDocumentAnnoTypeLine,//直线标注
    GSDocumentAnnoTypeLineEx,//加强版直线标注
    GSDocumentAnnoTypePointEx,//加强版点标注
    GSDocumentAnnoTypeFreePenEx = 0x10,//加强版自由笔标注
    GSDocumentAnnoTypePointerF,  //浮点型点标注
    GSDocumentAnnoTypeFreePenF,  //浮点型自由笔
    GSDocumentAnnoTypeTextF, //浮点型文字标注
    GSDocumentAnnoTypeRectF,//浮点型矩形
    GSDocumentAnnoTypeLineF,//浮点型直线标注
    GSDocumentAnnoTypeCircleF,//浮点型圆标注
    GSDocumentAnnoTypeCleanerF,//浮点型橡皮檫
    GSDocumentAnnoTypePicture, //图片标注类型
    GSDocumentAnnoTypePointExNoSend,//加强版点标注 - 不发送仅本地显示
};

//old 直线标注的类型
typedef NS_ENUM(NSInteger, LineExAnnoType){
    LineExSolidAnnoType = 0x00, //普通实线型
    LineExDashAnnoType, //虚线标注
    LineExArrowAnnoType, //箭头标注
};

//old 显示点的类型
typedef NS_ENUM(NSInteger, GSDocumentPointExAnnoType){
    GSDocumentAnnoPointExCross = 0x00, //十字型
    GSDocumentAnnoPointExArrow,//箭头
};
//文档标注的基类
@interface GSAnnoBase : NSObject
@property (assign, nonatomic)GSDocumentAnnoType type;//标注类型
@property (assign, nonatomic)long long annoID;//标注ID
@property (assign, nonatomic)unsigned pageID;//标注所在文档页的ID
@property (assign, nonatomic)unsigned docID;//标注所在文档页所在的文档的ID
@property (assign, nonatomic) long long ownerID;

-(CALayer*) annoLayerWithAnnoData:(GSAnnoData*)annoData;
-(GSAnnoBase*) annoContainsPoint:(CGPoint)point;
@end

// 圆形标注
@interface GSAnnoCircle : GSAnnoBase
@property (assign, nonatomic)Byte lineSize;//线的粗细尺寸
@property (strong, nonatomic)UIColor *lineColor;// 线的颜色
@property (assign, nonatomic)CGRect rect;//圆标注所在的矩形区域
@end

//自由笔标注
@interface GSAnnoFreePen : GSAnnoBase
@property (strong, nonatomic)NSMutableArray *points;//自由笔所有的点数据
@property (assign, nonatomic)Byte lineSize;//线的粗细尺寸
@property (strong, nonatomic)UIColor *lineColor;//线的颜色
@property (assign, nonatomic)BOOL isHighlight;
@end

//加强版自由笔标注
@interface GSAnnoFreePenEx : GSAnnoFreePen
@property (assign, nonatomic) Byte stepType;//表示当前的自由笔对象是开始点，过程中的点还是结束的点
@end

//直线标注
@interface GSAnnoLine : GSAnnoBase
@property (assign, nonatomic)Byte lineSize;//线的粗细尺寸
@property (strong, nonatomic)UIColor *lineColor;//线的颜色
@property (assign, nonatomic)CGPoint startPoint;//起始点
@property (assign, nonatomic)CGPoint endPoint;//结束点
@end

//加强版直线标注
@interface GSAnnoLineEx : GSAnnoLine
@property (assign, nonatomic)Byte lineType;//线的类型，箭头线2，虚线1和普通线0
@end

//点标注
@interface GSAnnoPoint : GSAnnoBase
@property (assign, nonatomic)CGPoint point;//点的坐标
@end

//加强版点标注
@interface GSAnnoPointEx : GSAnnoPoint
@property (assign, nonatomic)Byte pointType;//点的类型，十字和箭头
@end

//矩形标注
@interface GSAnnoRect : GSAnnoBase
@property (assign, nonatomic)Byte lineSize;//线的粗细
@property (strong, nonatomic)UIColor *lineColor;//线的颜色
@property (assign, nonatomic)CGRect rect;//矩形信息
@end

//图片标注
@interface GSAnnoPicture : GSAnnoBase
@property(assign, nonatomic)CGRect rect;//图片显示的位置跟大小
@property(copy, nonatomic)NSString* url;//图片地址
@end

//文字标注
@interface GSAnnoText : GSAnnoBase
@property (strong, nonatomic)UIColor *textColor;//文字颜色
@property (assign, nonatomic)Byte fontSize;//文字的字体大小
@property (copy, nonatomic)NSString *text;//文本内容
@property (assign, nonatomic)CGPoint point;//文字位置起始点
@end

//橡皮擦标注
@interface GSAnnoCleaner : GSAnnoBase
@property (assign, nonatomic)long long removedAnnoID;//删除的标注ID
@end

@interface GSAnnoInputText : NSObject
@property (strong, nonatomic)UIColor *textColor;//文字颜色
@property (assign, nonatomic)Byte fontSize;//文字的字体大小
@property (copy, nonatomic)NSString *text;//文本内容
//@property (assign, nonatomic)CGPoint point;//文字位置起始点,相对于docView左上角的坐标
@end

@interface GSAnnoInputPicture : NSObject
@property (nonatomic, copy)NSString* url; //图片地址
@property (nonatomic, strong)UIImage* data;//图片数据
@end

NS_ASSUME_NONNULL_END
