//
//  GSLogReportTool.h
//  GSCommonKit
//
//  Created by 张俞 on 2024/11/25.
//  Copyright © 2024 gensee. All rights reserved.
//

#import <Foundation/Foundation.h>

NS_ASSUME_NONNULL_BEGIN
@interface GSLogReportParam : NSObject
//{"msg":[{"appName":"logger","confId":null,"text":"init logger","time":"2024-11-21 17:14:26","type":"error","userId":null,"code":"6"}]} 

@property (nonatomic, copy) NSString * appName;
@property (nonatomic, copy) NSString * confId;
@property (nonatomic, copy) NSString * text;
@property (nonatomic, copy) NSString * time;
@property (nonatomic, copy) NSString * type;
@property (nonatomic, copy) NSString * userId;
@property (nonatomic, copy) NSString * userName;

@property (nonatomic, copy) NSString * code;

- (instancetype)initWithAppName:(NSString *)appName ConfId:(NSString *)confId Text:(NSString *)text Time:(NSString *)time Type:(NSString *)type UserId:(NSString *)userId UserName:(NSString *)userName Code:(NSString *)code;
@end

@interface GSLogReportTool : NSObject
/// 初始化
- (instancetype)initWithDomain:(NSString *)domain;
/// 添加日志
- (void)addLogMessageWith:(GSLogReportParam *)param;
/// 停止日志上报计时器并且上报剩余日志
- (void)stopLogReprtTimerAndUploadLog;

@end

NS_ASSUME_NONNULL_END
