//
//  GSDispatchQueue.h
//  MineDemo
//
//  Created by net263 on 2021/4/15.
//  Copyright © 2021 net263. All rights reserved.
//

#import <Foundation/Foundation.h>

NS_ASSUME_NONNULL_BEGIN

@interface GSDispatchQueue : NSObject

/**
 *dispatchQueue:设置任务要执行的队列
 */
- (void)setDispatchQueue:(dispatch_queue_t)dispatchQueue;
/**
 *block:要转到dispatchQueue的任务
 */
-(void)dispatchQueue:(dispatch_block_t)block;

/**
 *block:要转到dispatchQueue的任务
 *destQueue:block执行完后，要后要转到destQueue队列执行
 *destBlock：block执行完后，要后要转到destQueue队列执行的具体任务
 */
-(void)dispatchQueue:(dispatch_block_t)block destQueue:(dispatch_queue_t)destQueue destBlock:(dispatch_block_t)destBlock;

@end

NS_ASSUME_NONNULL_END
