//
//  GSAsRecord.h
//  GSCommonKit
//
//  Created by net263 on 2021/9/15.
//  Copyright © 2021 gensee. All rights reserved.
//

#import <Foundation/Foundation.h>
#import <UIKit/UIKit.h>
#import <VideoToolbox/VideoToolbox.h>

#define GS_AS_DEFAULT_PORT 8888
NS_ASSUME_NONNULL_BEGIN
typedef NS_ENUM(NSInteger, GSAsRecordDataType)
{
    GSAsRecordDataTypeStatusData,
    GSAsRecordDataTypeVideoData,
};

typedef NS_ENUM(NSInteger, GSAsRecordStatus)
{
    GSAsRecordStatusStart,
    GSAsRecordStatusStop,
    GSAsRecordStatusAppExit,
};

typedef NS_ENUM(NSInteger, GSAsRecordFrameType)
{
    GSAsRecordFrameTypeHeaderData,
    GSAsRecordFrameTypeIFrameData,
    GSAsRecordFrameTypePFrameData,
    GSAsRecordFrameTypeRGBA32Data,
};

@protocol GSTCPSockeHandleReceiveDataDelegate <NSObject>

/**
 状态数据
 */
- (void)onAsStatus:(GSAsRecordStatus)status;

/**
 视频数据
 */
- (void)onAsVideoData:(NSData*)data width:(int)width height:(int)height frameType:(GSAsRecordFrameType)frameType;

@end
@interface GSAsRecord : NSObject
@property(nonatomic,  weak) id delegate;
@property(nonatomic, copy)NSString *ip;
-(NSData*)handleSendStatusData:(GSAsRecordStatus)status;
-(NSData*)handleSendVideoData:(NSData*)data width:(int)width height:(int)height dataType:(GSAsRecordFrameType)dataTypeValue1;
-(void)handleReceiveData:(NSData*)data;


- (UIImage *)imageFromBuffer:(CMSampleBufferRef)buffer;

-(CVPixelBufferRef)CVPixelBufferRefFromUiImage:(UIImage *)img;
- (CMSampleBufferRef)sampleBufferFromPixbuffer:(CVPixelBufferRef)pixbuffer time:(CMTime)time;

- (UIImage *) convertBitmapRGBA8ToUIImage:(unsigned char *) buffer
        withWidth:(int) width
                               withHeight:(int) height;

- (CMSampleBufferRef)dealWithSampleBuffer:(CMSampleBufferRef)buffer oritention:(CGImagePropertyOrientation)orientation;


@end

NS_ASSUME_NONNULL_END
