//
//  UIView+GTYAlertView.h
//  GTYAlertControllerDemo
//
//  Created by tanyang on 15/9/7.
//  Copyright (c) 2015年 tanyang. All rights reserved.
//

#import <UIKit/UIKit.h>
#import "GTYAlertController.h"
#import "GTYShowAlertView.h"

@interface UIView (GTYAlertView)

+ (instancetype)createGs_ViewFromNib;

+ (instancetype)createGs_ViewFromNibName:(NSString *)nibName;

- (UIViewController*)viewController;

#pragma mark - show in controller

- (void)showGs_InController:(UIViewController *)viewController;

- (void)showGs_InController:(UIViewController *)viewController preferredStyle:(GTYAlertControllerStyle)preferredStyle;

// backgoundTapDismissEnable default NO
- (void)showGs_InController:(UIViewController *)viewController preferredStyle:(GTYAlertControllerStyle)preferredStyle backgoundTapDismissEnable:(BOOL)backgoundTapDismissEnable;

- (void)showGs_InController:(UIViewController *)viewController preferredStyle:(GTYAlertControllerStyle)preferredStyle transitionAnimation:(GTYAlertTransitionAnimation)transitionAnimation;

- (void)showGs_InController:(UIViewController *)viewController preferredStyle:(GTYAlertControllerStyle)preferredStyle transitionAnimation:(GTYAlertTransitionAnimation)transitionAnimation backgoundTapDismissEnable:(BOOL)backgoundTapDismissEnable;

#pragma mark - show in window

- (void)showGs_InWindow;

// backgoundTapDismissEnable default NO
- (void)showGs_InWindowWithBackgoundTapDismissEnable:(BOOL)backgoundTapDismissEnable;

- (void)showGs_InWindowWithOriginY:(CGFloat)OriginY;

- (void)showGs_InWindowWithOriginY:(CGFloat)OriginY backgoundTapDismissEnable:(BOOL)backgoundTapDismissEnable;


#pragma mark - hide

// this will judge and call right method
- (void)hideGs_View;

- (void)hideGs_InController;

- (void)hideGs_InWindow;

@end
