//
//  UIImage+OLExtend.h
//  OKLineDemo
//
//  Created by hxk on 17/3/29.
//  Copyright © 2017年 HZOL. All rights reserved.
//

#import <UIKit/UIKit.h>

@interface UIImage (OLExtend)

/**
 根据图片名返回一张能够自由拉伸的图片
 @param name 图片名
 @return 返回一张自由拉伸的图片
 */
+ (UIImage*)ol_resizedImage:(NSString *)name;


/**
 通过给定尺寸和颜色生成一张图片
 @param size  尺寸
 @param color 颜色
 @return UIImage对象
 */
+ (UIImage *)ol_imageWithSize:(CGSize)size color:(UIColor *)color;



/**
 对图片进行reflected
 @param scale scale
 */
-(UIImage *)ol_reflectedImageWithScale:(CGFloat)scale;



/**
 对Image进行缩放
 @param size 期望缩放的尺寸
 @return 返回UIImage对象
 */
- (UIImage*)imageWithToSize:(CGSize)size;



/**
 根据路径裁剪图片
 @param path  裁剪的路径
 @return 返回裁剪后的图片
 */
-(UIImage *)ol_imageWithClipPath:(UIBezierPath *)path;


/**
 扣图
 @param rect 扣图区域
 @return 返回新图片
 */
- (nullable UIImage *)imageByCropToRect:(CGRect)rect;

/**
 *  旋转图片
 */
- (nullable UIImage *)imageByRotate:(CGFloat)radians fitSize:(BOOL)fitSize;

/**
 按给定的方向旋转图片

 @param orient UIImageOrientationDownMirrored 垂直翻转
 UIImageOrientationUpMirrored 水平翻转
 */
- (nullable UIImage *)rotate:(UIImageOrientation)orient;
@end
