//
//  NSUserDefaults+OLSafeAccess.h
//  OKLineDemo
//
//  Created by hxk on 17/4/22.
//  Copyright © 2017年 HZOL. All rights reserved.
//

#import <Foundation/Foundation.h>

@interface NSUserDefaults (OLSafeAccess)
+ (NSString *)ol_stringForKey:(NSString *)defaultName;

+ (NSArray *)ol_arrayForKey:(NSString *)defaultName;

+ (NSDictionary *)ol_dictionaryForKey:(NSString *)defaultName;

+ (NSData *)ol_dataForKey:(NSString *)defaultName;

+ (NSArray *)ol_stringArrayForKey:(NSString *)defaultName;

+ (NSInteger)ol_integerForKey:(NSString *)defaultName;

+ (float)ol_floatForKey:(NSString *)defaultName;

+ (double)ol_doubleForKey:(NSString *)defaultName;

+ (BOOL)ol_boolForKey:(NSString *)defaultName;

+ (NSURL *)ol_URLForKey:(NSString *)defaultName;

#pragma mark - WRITE FOR STANDARD

+ (void)ol_setObject:(id)value forKey:(NSString *)defaultName;
+ (void)ol_setBool:(BOOL)value forKey:(NSString *)defaultName;
+ (void)ol_setFloat:(float)value forKey:(NSString *)defaultName;
+ (void)ol_setDouble:(double)value forKey:(NSString *)defaultName;
#pragma mark - READ ARCHIVE FOR STANDARD

+ (id)ol_arcObjectForKey:(NSString *)defaultName;

#pragma mark - WRITE ARCHIVE FOR STANDARD

+ (void)ol_setArcObject:(id)value forKey:(NSString *)defaultName;

+(void)ol_removeObjectForKey:(NSString *)key;

@end
