//
//  GLiveAppDelegate.h
//  GLiveSDK
//
//  Created by net263 on 2021/8/6.
//

#import <Foundation/Foundation.h>
#import "GLiveLogoutProtocol.h"
#import "GLiveAppProtocol.h"
#import <GSCommonKit/GSCommonKit.h>
#import "AchievementOBJ.h"
NS_ASSUME_NONNULL_BEGIN

///分享事件
@protocol GLiveShareDelegate <NSObject>
//3大平台分享
- (void)shareParameterDelegate:(NSDictionary *)shareDic;
//直播结束分享
- (void)shareLiveEndCardDelegate:(nonnull NSMutableDictionary *)dictionary;
//分享卡片
- (void)shareCardDelegate;

@end

@interface GLiveAppDelegate : NSObject
@property (strong, nonatomic) UINavigationController *rootController;
@property (nonatomic,assign)UIInterfaceOrientationMask orientMask;
@property (assign, nonatomic) long long myUserID;
@property (strong, nonatomic) NSDictionary *text2keyDic;
@property (assign, nonatomic) BOOL noRemind;//不显示语音提示
@property(nonatomic,strong)GSUserInfo *releseUserInfo;
@property (strong, nonatomic) UIWindow *window;

@property(nonatomic,weak)id<GLiveShareDelegate> shareDelegate;
/**直播结束统计*/
@property(nonatomic,strong)AchievementOBJ *achievement;

/*
 *退出到G直播的协议
 */
@property (nonatomic, weak)id<GLiveLogoutProtocol> logoutProtocol;

@property (nonatomic, weak)id<GLiveAppProtocol> gliveAppProtocol;

/**
 * 初始化单实例
 */
+ (nonnull instancetype)sharedGLiveAppDelegate;
-(void)applicationWillResignActive;
- (void)applicationWillEnterForeground;
- (void)applicationDidBecomeActive;

- (void)logoutToRootView;
- (void)logoutToLiveList;
-(void)updateGliveNavBar:(BOOL)hidden;

/**
 重置httpConfig
 */
-(void)resetHttpConfig:(BOOL)isHttp;

//应用是否在会议中
-(BOOL)isRoomRunning:(UIViewController*)eduVctl;

-(void)joinLunachCode:(NSString*)lunachCode;

-(void)leave;


@end

NS_ASSUME_NONNULL_END
