package com.gensee.glive_demo;

import android.app.Activity;
import android.os.Bundle;
import android.support.v7.app.AppCompatActivity;
import android.text.TextUtils;
import android.view.View;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.EditText;
import android.widget.Spinner;
import android.widget.TextView;

import com.gensee.common.ServiceType;
import com.gensee.entity.InitParam;
import com.gensee.glivesdk.GSLiveSDK;
import com.gensee.glivesdk.app.GLiveSharePreferences;
import com.gensee.glivesdk.config.GSLiveConfig;
import com.gensee.glivesdk.config.LiveMode;
import com.gensee.glivesdk.config.PublishVideoConfig;
import com.gensee.glivesdk.config.PublishVideoQuality;
import com.gensee.glivesdk.config.PublishVideoRatio;

import java.util.Arrays;
import java.util.List;

import static com.gensee.glivesdk.config.GSLiveConfig.GS_LIVE_SDK_VERSION;

public class MainActivity extends Activity {
    private TextView tvVersion;
    private EditText gsDomain,gsNumber,gsAccount,gsAccountPsw, gsNickname,gsNicknamePsw,gsK,gsUserId;
    private static final String SP_DOMAIN = "SP_DOMAIN";
    private static final String SP_NUMBER = "SP_NUMBER";
    private static final String SP_ACCOUNT = "SP_ACCOUNT";
    private static final String SP_ACCOUNT_PSW = "SP_ACCOUNT_PSW";
    private static final String SP_NICKNAME = "SP_NICKNAME";
    private static final String SP_NICKNAME_PSW = "SP_NICKNAME_PSW";
    private static final String SP_K = "SP_K";
    public static final String SP_USERID = "SP_USERID";
    public static final String SP_LIVE_MODE = "SP_LIVE_MODE";
    public static final String SP_SERVICE_TYPE = "SP_SERVICE_TYPE";
    public static final String SP_HARD_ENCODE = "SP_HARD_ENCODE";
    public static final String SP_QUALITY = "SP_QUALITY";
    public static final String SP_RATIO = "SP_RATIO";

    private Spinner spRoomMode,spPubHardEncode,spPubQuality, spPubRatio, spServiceType;
    private View pubParamSetLy;
    private LiveMode liveMode = LiveMode.WATCH;
    private boolean isHardEncode = true;
    private PublishVideoQuality publishVideoQuality = PublishVideoQuality.QUALITY_HIGH;
    private PublishVideoRatio videoRatio = PublishVideoRatio.RATIO_16_9;
    private ServiceType serviceType = ServiceType.WEBCAST;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_main);
        initView();
        findViewById(R.id.btnJoin).setOnClickListener(v -> {
            InitParam initParam = new InitParam();
            //详见 http://www.gensee.com/upfile/2017/08/04/86c6_2017080414453314Hzc.png
            initParam.setDomain(gsDomain.getText().toString());
            initParam.setNumber(gsNumber.getText().toString());
            initParam.setLoginAccount(gsAccount.getText().toString());
            initParam.setLoginPwd(gsAccountPsw.getText().toString());
            initParam.setNickName(gsNickname.getText().toString());
            initParam.setJoinPwd(gsNicknamePsw.getText().toString());
            initParam.setServiceType(serviceType);
            initParam.setK(gsK.getText().toString());
            String userId = gsUserId.getText().toString();
            initParam.setUserId(TextUtils.isEmpty(userId)?0:Long.parseLong(userId));
            //功能配置
            GSLiveConfig gsLiveConfig = new GSLiveConfig();
            //设置模式, 观看端,发布端(多个模式),点播
            gsLiveConfig.setLiveMode(liveMode);
            //发布端设置,观看端不需要
            gsLiveConfig.setPublishVideoConfig(new PublishVideoConfig().
                    setHardEncode(isHardEncode).setPublishVideoRatio(videoRatio).setVideoQuality(publishVideoQuality));
            //加入房间
            GSLiveSDK.join(this,initParam,gsLiveConfig);
            saveParams();
        });
    }

    private void initView() {
        tvVersion = findViewById(R.id.tvVersion);
        tvVersion.setText(GS_LIVE_SDK_VERSION +"\nbuildTime:"+BuildConfig.apkBuildTime);
        gsDomain = findViewById(R.id.gsDomain);
        gsDomain.setText(GLiveSharePreferences.getIns().getString(SP_DOMAIN,""));
        gsNumber = findViewById(R.id.gsNumber);
        gsNumber.setText(GLiveSharePreferences.getIns().getString(SP_NUMBER,""));
        gsAccount = findViewById(R.id.gsAccount);
        gsAccount.setText(GLiveSharePreferences.getIns().getString(SP_ACCOUNT,""));
        gsAccountPsw = findViewById(R.id.gsAccountPsw);
        gsAccountPsw.setText(GLiveSharePreferences.getIns().getString(SP_ACCOUNT_PSW,""));
        gsNickname = findViewById(R.id.gsNickname);
        gsNickname.setText(GLiveSharePreferences.getIns().getString(SP_NICKNAME,""));
        gsNicknamePsw = findViewById(R.id.gsNicknamePsw);
        gsNicknamePsw.setText(GLiveSharePreferences.getIns().getString(SP_NICKNAME_PSW,""));
        gsK = findViewById(R.id.gsK);
        gsK.setText(GLiveSharePreferences.getIns().getString(SP_K,""));
        gsUserId = findViewById(R.id.gsUserId);
        gsUserId.setText(GLiveSharePreferences.getIns().getString(SP_USERID,""));

        //观看端,发布端,点播选择器
        pubParamSetLy = findViewById(R.id.pub_param_set_ly);
        spRoomMode = (Spinner) findViewById(R.id.spRoomMode);
        configSpinner(spRoomMode, Arrays.asList("观看端", "发布端-视频文档", "发布端-纯视频横屏", "发布端-纯视频竖屏", "点播"),
                position -> {
                    switch (position) {
                        case 0:
                            liveMode = LiveMode.WATCH;
                            break;
                        case 1:
                            liveMode = LiveMode.PUBLISH_VIDEO_DOC;
                            break;
                        case 2:
                            liveMode = LiveMode.PUBLISH_PURE_VIDEO_LANDSCAPE;
                            break;
                        case 3:
                            liveMode = LiveMode.PUBLISH_PURE_VIDEO_PORTRAIT;
                            break;
                        case 4:
                            liveMode = LiveMode.VOD;
                            break;
                    }
                    pubParamSetLy.setVisibility(position == 0 || position == 4 ? View.GONE : View.VISIBLE);
                    spPubRatio.setVisibility(position == 1 ? View.VISIBLE : View.INVISIBLE);
                });
        String mode = GLiveSharePreferences.getIns().getString(SP_LIVE_MODE,
                LiveMode.WATCH.toString());
        liveMode = LiveMode.toEnum(mode);
        pubParamSetLy.setVisibility(liveMode.ordinal() == 0 || liveMode.ordinal() == 4 ? View.GONE : View.VISIBLE);
        spRoomMode.setSelection(liveMode.ordinal());
        //发布端硬编,软编
        spPubHardEncode = (Spinner) findViewById(R.id.sp_pub_hard_encode);
        configSpinner(spPubHardEncode, Arrays.asList("硬编", "软编"), position -> {
            isHardEncode = position == 0;
        });
        boolean isHardEncode = GLiveSharePreferences.getIns().getBoolean(SP_HARD_ENCODE, true);
        spPubHardEncode.setSelection(isHardEncode ? 0 : 1);
        //发布端分辨率 超清/高清/标清
        spPubQuality = (Spinner) findViewById(R.id.sp_pub_quality);
        configSpinner(spPubQuality, Arrays.asList("超清","高清","标清"), position -> {
            if (position == 0) {
                publishVideoQuality = PublishVideoQuality.QUALITY_HIGH;
            } else if (position == 1){
                publishVideoQuality = PublishVideoQuality.QUALITY_MIDDLE;
            } else if (position == 2) {
                publishVideoQuality = PublishVideoQuality.QUALITY_LOW;
            }
        });
        String pubQuality = GLiveSharePreferences.getIns().getString(SP_QUALITY, PublishVideoQuality.QUALITY_HIGH.toString());
        publishVideoQuality = PublishVideoQuality.toEnum(pubQuality);
        spPubQuality.setSelection(publishVideoQuality.ordinal());
        //发布端视频比例
        spPubRatio = findViewById(R.id.sp_pub_ratio);
        //只有发布端视频文档模式, 可以设置发布视频比例
        spPubRatio.setVisibility(liveMode.ordinal() == 1 ? View.VISIBLE : View.INVISIBLE);
        configSpinner(spPubRatio,Arrays.asList("16:9","4:3"),position -> {
            if (position == 0) {
                videoRatio = PublishVideoRatio.RATIO_16_9;
            } else if (position == 1) {
                videoRatio = PublishVideoRatio.RATIO_4_3;
            }
        });
        String ratio = GLiveSharePreferences.getIns().getString(SP_RATIO, PublishVideoRatio.RATIO_16_9.toString());
        videoRatio = PublishVideoRatio.toEnum(ratio);
        spPubRatio.setSelection(videoRatio.ordinal());
        //站点类型 webcast,training
        spServiceType = findViewById(R.id.spServiceType);
        configSpinner(spServiceType,Arrays.asList("webcast","training"),position -> {
            serviceType = position == 0 ? ServiceType.WEBCAST : ServiceType.TRAINING;
        });
        String type = GLiveSharePreferences.getIns().getString(SP_SERVICE_TYPE, ServiceType.WEBCAST.toString());
        spServiceType.setSelection(type.equals(ServiceType.WEBCAST.toString()) ? 0 : 1);
        serviceType = type.equals(ServiceType.WEBCAST.toString()) ? ServiceType.WEBCAST : ServiceType.TRAINING;
    }

    private void configSpinner(Spinner spinner, List<String> asList, MyItemSelectedListener listener) {
        final ArrayAdapter<String> adapter = new ArrayAdapter<String>(this,
                android.R.layout.simple_spinner_item, asList);
        adapter.setDropDownViewResource(android.R.layout.simple_spinner_dropdown_item);
        spinner.setAdapter(adapter);
        spinner.setOnItemSelectedListener(new Spinner.OnItemSelectedListener() {
            public void onItemSelected(AdapterView<?> arg0, View arg1,
                                       int arg2, long arg3) {
                if (null != listener) {
                    listener.onItemSelected(arg2);
                }
            }

            public void onNothingSelected(AdapterView<?> arg0) {
            }
        });
    }

    private void saveParams() {
        GLiveSharePreferences.getIns().putString(SP_DOMAIN,gsDomain.getText().toString());
        GLiveSharePreferences.getIns().putString(SP_NUMBER,gsNumber.getText().toString());
        GLiveSharePreferences.getIns().putString(SP_ACCOUNT,gsAccount.getText().toString());
        GLiveSharePreferences.getIns().putString(SP_ACCOUNT_PSW,gsAccountPsw.getText().toString());
        GLiveSharePreferences.getIns().putString(SP_NICKNAME,gsNickname.getText().toString());
        GLiveSharePreferences.getIns().putString(SP_NICKNAME_PSW,gsNicknamePsw.getText().toString());
        GLiveSharePreferences.getIns().putString(SP_LIVE_MODE,liveMode.toString());
        GLiveSharePreferences.getIns().putString(SP_SERVICE_TYPE,serviceType.toString());
        GLiveSharePreferences.getIns().putString(SP_QUALITY,publishVideoQuality.toString());
        GLiveSharePreferences.getIns().putString(SP_RATIO,videoRatio.toString());
        GLiveSharePreferences.getIns().putBoolean(SP_HARD_ENCODE,isHardEncode);

    }

   private interface MyItemSelectedListener {
       void onItemSelected(int position);
   }

}