package com.gensee.fastsdkdemo;

import android.app.Activity;
import android.content.SharedPreferences;
import android.graphics.Color;
import android.os.Bundle;
import android.text.Editable;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.view.View;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.CheckBox;
import android.widget.CompoundButton;
import android.widget.EditText;
import android.widget.Spinner;

import com.gensee.fastsdk.core.GSFastConfig;

import java.util.ArrayList;
import java.util.List;

public class SettingActivity extends Activity implements CompoundButton.OnCheckedChangeListener {
    public static final String SETTING_PREFERENCES_NAME = "SETTING_PREFERENCES_NAME";
    public static final String GS_DOC = "gs_doc";
    public static final String GS_CHAT = "gs_chat";
    public static final String GS_QA = "gs_qa";
    public static final String GS_INTRO = "gs_intro";
    public static final String GS_CHAPTER = "gs_chapter";
    public static final String GS_PIP = "gs_PIP";
    public static final String GS_HAND = "gs_hand";
    public static final String GS_RATE = "gs_rate";
    public static final String GS_NET = "gs_net";
    public static final String GS_SKIN = "gs_skin";
    public static final String GS_DANMU = "gs_danmu";
    public static final String GS_CLOSE_VIDEO = "gs_close_video";
    public static final String GS_HARD_DECODE_VIDEO = "gs_hard_decode_video";
    public static final String GS_CAMERA_SWITCH = "GS_CAMERA_SWITCH";
    public static final String GS_MARQUEE_COLOR = "GS_MARQUEE_COLOR";
    public static final String GS_MARQUEE_SPEED = "GS_MARQUEE_SPEED";
    public static final String GS_MARQUEE_SIZE = "GS_MARQUEE_SIZE";
    public static final String GS_MARQUEE_CONTENT = "GS_MARQUEE_CONTENT";
    public static final String GS_BACKGROUD_PLAY = "GS_BACKGROUD_PLAY";
    public static final int SKIN_TYPE_NIGHT = 0;
    public static final int SKIN_TYPE_DAY = 1;
    private CheckBox cbDoc;
    private CheckBox cbChat;
    private CheckBox cbQa;
    private CheckBox cbIntro;
    private CheckBox cbChapter;
    private CheckBox cbPIP;
    private CheckBox cbHand;
    private CheckBox cbRate;
    private CheckBox cbNet;
    private Spinner spSkinner;
    private Spinner spLocale;
    private SharedPreferences preferences;
    private CheckBox cbDanmu;
    private CheckBox cbCloseVideo;
    private CheckBox cbHardDecode;
    private CheckBox cbCameraSwitch;
    private CheckBox cb_backgroudplay;
    private Spinner spMarqueeColor,spMarqueeSpeed;
    private EditText etMarqueeSize,etMarqueeContent;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_setting);
        setTitle("设置");
        preferences = getSharedPreferences(SETTING_PREFERENCES_NAME, MODE_PRIVATE);
        cbDoc = (CheckBox) findViewById(R.id.cb_doc);
        cbDoc.setChecked(getFromPrefrences(GS_DOC));
        cbDoc.setOnCheckedChangeListener(this);
        cbChat = (CheckBox) findViewById(R.id.cb_chat);
        cbChat.setChecked(getFromPrefrences(GS_CHAT));
        cbChat.setOnCheckedChangeListener(this);
        cbQa = (CheckBox) findViewById(R.id.cb_qa);
        cbQa.setChecked(getFromPrefrences(GS_QA));
        cbQa.setOnCheckedChangeListener(this);
        cbIntro = (CheckBox) findViewById(R.id.cb_intro);
        cbIntro.setChecked(getFromPrefrences(GS_INTRO));
        cbIntro.setOnCheckedChangeListener(this);
        cbChapter = (CheckBox) findViewById(R.id.cb_vod_chapter);
        cbChapter.setChecked(getFromPrefrences(GS_CHAPTER));
        cbChapter.setOnCheckedChangeListener(this);
        cbPIP = (CheckBox) findViewById(R.id.cb_PIP);
        cbPIP.setChecked(getFromPrefrences(GS_PIP));
        cbPIP.setOnCheckedChangeListener(this);
        cbHand = (CheckBox) findViewById(R.id.cb_hand);
        cbHand.setChecked(getFromPrefrences(GS_HAND));
        cbHand.setOnCheckedChangeListener(this);
        cbRate = (CheckBox) findViewById(R.id.cb_cbRate);
        cbRate.setChecked(getFromPrefrences(GS_RATE));
        cbRate.setOnCheckedChangeListener(this);
        cbNet = (CheckBox) findViewById(R.id.cb_net);
        cbNet.setChecked(getFromPrefrences(GS_NET));
        cbNet.setOnCheckedChangeListener(this);
        cbDanmu = (CheckBox) findViewById(R.id.cb_danmu);
        cbDanmu.setChecked(getFromPrefrences(GS_DANMU));
        cbDanmu.setOnCheckedChangeListener(this);
        cbCloseVideo = (CheckBox) findViewById(R.id.cb_close_video);
        cbCloseVideo.setChecked(getFromPrefrences(GS_CLOSE_VIDEO));
        cbCloseVideo.setOnCheckedChangeListener(this);
        cbHardDecode = (CheckBox) findViewById(R.id.cb_hard_decode);
        cbHardDecode.setChecked(getFromPrefrences(GS_HARD_DECODE_VIDEO,false));
        cbHardDecode.setOnCheckedChangeListener(this);
        cbCameraSwitch = (CheckBox) findViewById(R.id.cb_camera_switch);
        cbCameraSwitch.setChecked(getFromPrefrences(GS_CAMERA_SWITCH));
        cbCameraSwitch.setOnCheckedChangeListener(this);
        cb_backgroudplay = (CheckBox) findViewById(R.id.cb_backgroudplay);
        cb_backgroudplay.setChecked(getFromPrefrences(GS_BACKGROUD_PLAY,false));
        cb_backgroudplay.setOnCheckedChangeListener(this);
        initSkinSpinner();
        initMarqueeSetting();
        findViewById(R.id.gs_bnt_back).setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                finish();
            }
        });
        updateSetting();

    }

    private void initMarqueeSetting() {
        spMarqueeColor = findViewById(R.id.spMarqueeColor);
        spMarqueeSpeed = findViewById(R.id.spMarqueeSpeed);
        etMarqueeSize = findViewById(R.id.etMarqueeSize);
        etMarqueeContent = findViewById(R.id.etMarqueeContent);
        //颜色
        List<String> list = new ArrayList<String>();
        list.add("[颜色]RED");
        list.add("[颜色]YELLOW");
        list.add("[颜色]BLUE");
        final ArrayAdapter<String> adapter = new ArrayAdapter<String>(this,
                android.R.layout.simple_spinner_item, list);
        adapter.setDropDownViewResource(android.R.layout.simple_spinner_dropdown_item);
        spMarqueeColor.setAdapter(adapter);
        int def = preferences.getInt(GS_MARQUEE_COLOR, Color.RED);
        if(def == Color.RED){
            spMarqueeColor.setSelection(0);
        }else if(def == Color.YELLOW){
            spMarqueeColor.setSelection(1);
        }else if(def == Color.BLUE){
            spMarqueeColor.setSelection(2);
        }
        spMarqueeColor.setOnItemSelectedListener(new Spinner.OnItemSelectedListener() {
            public void onItemSelected(AdapterView<?> arg0, View arg1,
                                       int arg2, long arg3) {
                switch (arg2) {
                    case 0:
                        saveToPrefrences(GS_MARQUEE_COLOR,Color.RED);
                        break;
                    case 1:
                        saveToPrefrences(GS_MARQUEE_COLOR,Color.YELLOW);
                        break;
                    case 2:
                        saveToPrefrences(GS_MARQUEE_COLOR,Color.BLUE);
                        break;
                }
            }
            public void onNothingSelected(AdapterView<?> arg0) {
            }
        });
        //速度
        List<String> list2 = new ArrayList<String>();
        list2.add("[速度]1");
        list2.add("[速度]2");
        list2.add("[速度]3");
        list2.add("[速度]4");
        list2.add("[速度]5");
        final ArrayAdapter<String> adapter2 = new ArrayAdapter<String>(this,
                android.R.layout.simple_spinner_item, list2);
        adapter2.setDropDownViewResource(android.R.layout.simple_spinner_dropdown_item);
        spMarqueeSpeed.setAdapter(adapter2);
        int def2 = preferences.getInt(GS_MARQUEE_SPEED, 1);
        spMarqueeSpeed.setSelection(def2-1);
        spMarqueeSpeed.setOnItemSelectedListener(new Spinner.OnItemSelectedListener() {
            public void onItemSelected(AdapterView<?> arg0, View arg1,
                                       int arg2, long arg3) {
                saveToPrefrences(GS_MARQUEE_SPEED,arg2+1);
            }
            public void onNothingSelected(AdapterView<?> arg0) {
            }
        });
        etMarqueeSize.setText(preferences.getInt(GS_MARQUEE_SIZE,14)+"");
        etMarqueeSize.addTextChangedListener(new TextWatcher() {
            @Override
            public void beforeTextChanged(CharSequence s, int start, int count, int after) {

            }

            @Override
            public void onTextChanged(CharSequence s, int start, int before, int count) {
                if (!TextUtils.isEmpty(s)) {
                    saveToPrefrences(GS_MARQUEE_SIZE,Integer.parseInt(s.toString()));
                } else {
                    saveToPrefrences(GS_MARQUEE_SIZE, 14);
                }
            }

            @Override
            public void afterTextChanged(Editable s) {

            }
        });
        etMarqueeContent.setText(preferences.getString(GS_MARQUEE_CONTENT,""));
        etMarqueeContent.addTextChangedListener(new TextWatcher() {
            @Override
            public void beforeTextChanged(CharSequence s, int start, int count, int after) {

            }

            @Override
            public void onTextChanged(CharSequence s, int start, int before, int count) {
                saveToPrefrences(GS_MARQUEE_CONTENT,s.toString());
            }

            @Override
            public void afterTextChanged(Editable s) {

            }
        });
    }

    private void initSkinSpinner() {
        spSkinner = (Spinner) findViewById(R.id.sp_skinner);
        List<String> list2 = new ArrayList<String>();
        list2.add("[换肤]黑夜");
        list2.add("[换肤]白天");
        final ArrayAdapter<String> adapter2 = new ArrayAdapter<String>(this,
                android.R.layout.simple_spinner_item, list2);
        adapter2.setDropDownViewResource(android.R.layout.simple_spinner_dropdown_item);
        spSkinner.setAdapter(adapter2);
        int defSkin = preferences.getInt(GS_SKIN,0);
        if(defSkin == SKIN_TYPE_NIGHT){
            spSkinner.setSelection(0);
        }else if(defSkin == SKIN_TYPE_DAY){
            spSkinner.setSelection(1);
        }
        spSkinner.setOnItemSelectedListener(new Spinner.OnItemSelectedListener() {
            public void onItemSelected(AdapterView<?> arg0, View arg1,
                                       int arg2, long arg3) {
                switch (arg2) {
                    case 0:
                        saveToPrefrences(GS_SKIN,SKIN_TYPE_NIGHT);
                        break;
                    case 1:
                        saveToPrefrences(GS_SKIN,SKIN_TYPE_DAY);
                        break;
                }
            }

            public void onNothingSelected(AdapterView<?> arg0) {
            }
        });
    }

    private void updateSetting(){
        DemoConfig.LIVEMODE livemode = DemoConfig.getIns().getLivemode();
        int watchMode = DemoConfig.getIns().getWatchScreenMode();
        boolean hasDocSet = livemode== DemoConfig.LIVEMODE.VOD || (livemode== DemoConfig.LIVEMODE.WATCH && watchMode == GSFastConfig.WATCH_SCREEN_MODE_VIDEO_DOC);
        //文档 聊天 问答 简介  直播分屏和点播播放都可以设置，就用hasDocSet控制设置项
        cbDoc.setVisibility(hasDocSet?View.VISIBLE:View.GONE);
        cbChat.setVisibility(hasDocSet?View.VISIBLE:View.GONE);
        cbQa.setVisibility(hasDocSet?View.VISIBLE:View.GONE);
        cbIntro.setVisibility(hasDocSet?View.VISIBLE:View.GONE);

        //章节只有点播才有
        cbChapter.setVisibility(livemode== DemoConfig.LIVEMODE.VOD?View.VISIBLE:View.GONE);
        //直播分屏中的选项
        boolean hasHandSet = livemode== DemoConfig.LIVEMODE.WATCH && watchMode == GSFastConfig.WATCH_SCREEN_MODE_VIDEO_DOC;
        cbPIP.setVisibility(hasHandSet?View.VISIBLE:View.GONE);
        cbHand.setVisibility(hasHandSet?View.VISIBLE:View.GONE);
        cbNet.setVisibility(hasHandSet?View.VISIBLE:View.GONE);
        cbDanmu.setVisibility(hasHandSet?View.VISIBLE:View.GONE);
        cbCloseVideo.setVisibility(hasHandSet?View.VISIBLE:View.GONE);
        spSkinner.setVisibility(hasHandSet?View.VISIBLE:View.GONE);
    }

    @Override
    public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
        switch (buttonView.getId()){
            case R.id.cb_doc:
                saveToPrefrences(GS_DOC, isChecked);
                break;
            case R.id.cb_chat:
                saveToPrefrences(GS_CHAT, isChecked);
                break;
            case R.id.cb_qa:
                saveToPrefrences(GS_QA, isChecked);
                break;
            case R.id.cb_intro:
                saveToPrefrences(GS_INTRO, isChecked);
                break;
            case R.id.cb_vod_chapter:
                saveToPrefrences(GS_CHAPTER, isChecked);
                break;
            case R.id.cb_PIP:
                saveToPrefrences(GS_PIP, isChecked);
                break;
            case R.id.cb_hand:
                saveToPrefrences(GS_HAND, isChecked);
                break;
            case R.id.cb_cbRate:
                saveToPrefrences(GS_RATE, isChecked);
                break;
            case R.id.cb_net:
                saveToPrefrences(GS_NET, isChecked);
                break;
            case R.id.cb_danmu:
                saveToPrefrences(GS_DANMU, isChecked);
            case R.id.cb_close_video:
                saveToPrefrences(GS_CLOSE_VIDEO, isChecked);
                break;
            case R.id.cb_hard_decode:
                saveToPrefrences(GS_HARD_DECODE_VIDEO, isChecked);
                break;
            case R.id.cb_camera_switch:
                saveToPrefrences(GS_CAMERA_SWITCH,isChecked);
                break;
            case R.id.cb_backgroudplay:
                saveToPrefrences(GS_BACKGROUD_PLAY,isChecked);
                break;
        }
    }

    private void saveToPrefrences(String key, boolean value) {
        preferences.edit().putBoolean(key, value).apply();
    }

    private void saveToPrefrences(String key, int value) {
        preferences.edit().putInt(key, value).apply();
    }

    private void saveToPrefrences(String key, String value) {
        preferences.edit().putString(key, value).apply();
    }


    private boolean getFromPrefrences(String key) {
        return getFromPrefrences(key,true);
    }
    private boolean getFromPrefrences(String key,boolean def) {
        return preferences.getBoolean(key,def);
    }
}
