package com.gensee.rtlib;

import android.content.Context;
import android.graphics.drawable.Drawable;

import java.util.List;

public class ChatResourceEx extends ChatResource {

	/**
	 * 第二套表情（下标为1） png资源
	 */
	private static final int BROW_BATCH_1_PNG = 1;
	public static void initChatResource(Context context) {
		//如果使用了插件化打包  dynamic load apk，请注释掉下面行
		context = context.getApplicationContext();
		new ChatResourceEx().initResource(context);
	}
	


	@Override
	protected Drawable getPngDrawableForGif(Context context, String key, int resId) {
        Drawable drawable = context.getResources().getDrawable(resId);
		drawable.setBounds(0, 0,drawable.getIntrinsicWidth(),
				drawable.getIntrinsicWidth());
        return drawable;
	}

	/**
     * 返回第二套表情下标 1
	 * @return
     */
	@Override
	protected int getBrowBatch() {
		return BROW_BATCH_1_PNG;
	}

	/**
	 * 扩展第三方表情
	 * @param items      Item 列表
	 * Item.key      string 中作为映射Key的资源
	 * Item.textId   string 中纯文本中表情文字
	 * Item.drawale  drawable 中表情图片资源
	 * Item.path     富文本中图片路径（完整名称 xxx.xx.png）extra.xxx.png
	 * Item(int key, int textId, int drawale, String path)
	 * 
	 * step 1、添加图片haoche.png资源到drawable
	 * step 2、string 添加表情纯文本的文字表示<string name="extra_haoche_text">【豪车】</string>
	 *         string 添加映射的key           <string name="extra_haoche_key">【extra.haoche.png】</string>
	 * step 3、items.add(new Item(R.string.extra_haoche_key, R.string.extra_haoche_text,R.drawable.haoche, "extra.haoche.png"))        
	 */
	@Override
	protected void onExtraBrowInit(List<Item> items) {
		// TODO extra brow
	}
}
