//package com.gensee.rtdemo.robot;
//
//import android.os.Bundle;
//import android.util.Log;
//import android.view.View;
//import android.view.WindowManager;
//import android.widget.AdapterView;
//import android.widget.Button;
//import android.widget.LinearLayout;
//import android.widget.ListView;
//import android.widget.TextView;
//import android.widget.Toast;
//
//import com.gensee.demo.R;
//import com.gensee.robot.exception.NotSupportedBluetoothException;
//import com.gensee.robot.exception.RequireBluetoothPermissionException;
//import com.gensee.robot.exception.RequireSDReadWritePermissionException;
//import com.gensee.robot.pen.RobotDeviceSearch;
//import com.gensee.robot.pen.RobotDeviceService;
//import com.gensee.rtdemo.BaseActivity;
//
//import java.util.List;
//import java.util.UUID;
//
//import cn.robotpen.model.entity.DeviceEntity;
//import cn.robotpen.pen.model.RemoteState;
//import cn.robotpen.pen.model.RobotDevice;
//
//
//public class BleConnectActivity extends BaseActivity implements View.OnClickListener, RobotDeviceService.OnDeviceServiceListener, RobotDeviceSearch.OnScanDeviceListener {
//
//    private final UUID SERVICE_UUID = UUID.fromString("6e400001-b5a3-f393-e0a9-e50e24dcca9e");
//
//    TextView statusText;
//    ListView listview;
//    Button scanBut;
//    Button disconnectBut;
//    LinearLayout listFrame;
//    private PenAdapter mPenAdapter;
//
//    private RobotDeviceService mDeviceService;
//    private RobotDeviceSearch mDeviceSerach;
//
//
//    @Override
//    protected void onCreate(Bundle savedInstanceState) {
//        super.onCreate(savedInstanceState);
//
//        setContentView(R.layout.activity_ble_connect);
//        statusText = (TextView)findViewById(R.id.statusText);
//        listview = (ListView)findViewById(R.id.listview);
//        scanBut = (Button)findViewById(R.id.scanBut);
//        scanBut.setOnClickListener(this);
//        disconnectBut = (Button)findViewById(R.id.disconnectBut);
//        disconnectBut.setOnClickListener(this);
//        listFrame = (LinearLayout)findViewById(R.id.listFrame);
//
//
//
//        getWindow().addFlags(WindowManager.LayoutParams.FLAG_KEEP_SCREEN_ON);   //应用运行时，保持屏幕高亮，不锁屏
//        mPenAdapter = new PenAdapter();
//
//        listview.setAdapter(mPenAdapter);
//        listview.setOnItemClickListener(new AdapterView.OnItemClickListener() {
//            @Override
//            public void onItemClick(AdapterView<?> arg0, View arg1, int index, long arg3) {
//                //停止搜索
//               mDeviceSerach.stopScan();
//                DeviceEntity device = mPenAdapter.getItem(index);
//                String addr = device.getAddress();
//                if (mDeviceService !=  null) {
//                    if (mDeviceService.getConnectedDevice() == null) {
//                        Log.e("test","开始链接:"+addr);
//                        mDeviceService.connectDevice(addr);//通过监听获取连接状态
//                    } else {
//                        Toast.makeText(BleConnectActivity.this, "先断开当前设备", Toast.LENGTH_SHORT).show();
//                    }
//                }else {
//                    Toast.makeText(BleConnectActivity.this, "服务未启动", Toast.LENGTH_SHORT).show();
//                }
//            }
//        });
//
//
//        mDeviceService = new RobotDeviceService(this, this);
//        try {
//            mDeviceService.bindRobotPenService();
//        }catch (RequireSDReadWritePermissionException e)
//        {
//
//        }
//        mDeviceSerach = new RobotDeviceSearch(this);
//    }
//
//    @Override
//    protected void onDestroy() {
//        mDeviceSerach.stopScan();
//        mDeviceService.unbindRobotPenService();
//        super.onDestroy();
//    }
//
//    @Override
//    public void onClick(View view) {
//        switch (view.getId()) {
//            case R.id.scanBut:
//                try {
//                    mDeviceSerach.startScanDevice(this);
//                }catch (RequireBluetoothPermissionException e)
//                {
//
//                }catch (NotSupportedBluetoothException e1)
//                {
//
//                }
//                break;
//            case R.id.disconnectBut:
//                mDeviceService.disconnectDevice();
//                scanBut.setVisibility(View.VISIBLE);
//                disconnectBut.setVisibility(View.GONE);
//                statusText.setText("未连接设备!");
//                break;
//        }
//    }
//
//    public void onStateChanged(final int i) {
//        runOnUiThread(new Runnable() {
//            @Override
//            public void run() {
//                switch (i) {
//                    case RemoteState.STATE_ERROR:
//                        Log.i("test","STATE_ERROR");
//                        break;
//                    case RemoteState.STATE_CONNECTED:
//                        Log.i("test","STATE_CONNECTED");
//                        break;
//                    case RemoteState.STATE_CONNECTING:
//                        break;
//                    case RemoteState.STATE_DISCONNECTED: //设备断开
//                        Log.i("test","STATE_DISCONNECTED");
//                        statusText.setText("未连接设备！");
//                        scanBut.setVisibility(View.VISIBLE);
//                        disconnectBut.setVisibility(View.GONE);
//                        break;
//                    case RemoteState.STATE_DEVICE_INFO: //设备连接成功状态
//                            Log.i("test","STATE_DEVICE_INFO");
//                            mPenAdapter.clearItems();
//                            mPenAdapter.notifyDataSetChanged();
//                            RobotDevice robotDevice = mDeviceService.getConnectedDevice();
//
//                            String device_blewarever = robotDevice.getBleFirmwareVerStr();
//                            Log.e("test","device_blewarever :"+device_blewarever);
//                            if (null != robotDevice) {
//                                if (robotDevice.getDeviceVersion() > 0) {
//                                    statusText.setText("已连接设备: " + robotDevice.getName());
//                                    scanBut.setVisibility(View.GONE);
//                                    disconnectBut.setVisibility(View.VISIBLE);
//                                }
//                            }
//                        break;
//                }
//            }
//        });
//    }
//
//    @Override
//    public void onScanDeviceList(final List<DeviceEntity> deviceEntityList) {
//        runOnUiThread(new Runnable() {
//            @Override
//            public void run() {
//                mPenAdapter.addItems(deviceEntityList);
//            }
//        });
//    }
//
//    @Override
//    public void onDeviceStatus(int status) {
//        onStateChanged(status);
//    }
//}
