package com.gensee.rtdemo.holder.doc;

import android.view.View;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;

import com.gensee.demo.R;
import com.gensee.doc.CtrlMode;
import com.gensee.doc.DrawMode;
import com.gensee.doc.LINE_SIZE;
import com.gensee.pdu.DocViewImpl;
import com.gensee.rtdemo.view.ColorBar;

/**
 * Created by Administrator on 2017/9/18.
 */

public class VideoDocLabelHolder extends DocLabelHolder implements ColorBar.ColorChangeListener, DocViewImpl.OnDocLabelListener {
    private static final String TAG = "VideoDocLabelHolder";
    private RelativeLayout docLabelFirst;
    private LinearLayout lyDocLabelFirst;
    private RelativeLayout docLabelSecond;
    private LinearLayout lyDocLabelSecond;
    private LinearLayout lyDocLabelSecondLeft;
    private LinearLayout lyDocLabelSecondRight;
    private RelativeLayout docLayoutView;
    private ColorBar colorBar;

    private ImageView penSelectIv;
    private ImageView penSizeOneIv;
    private ImageView penSizeThreeIv;
    private ImageView penSizeSixIv;
    private ImageView penRubberIv;
    private ImageView penClearIv;

    private OnDocLabelExitListener onDocLabelExitListener;

    public void setOnDocLabelExitListener(OnDocLabelExitListener onDocLabelExitListener)
    {
        this.onDocLabelExitListener = onDocLabelExitListener;
    }

    public VideoDocLabelHolder(View rootView, Object value) {
        super(rootView, value);
    }

    @Override
    protected void initData(Object value) {

    }

    public void setDocViewLayout(View view)
    {
        docLayoutView = (RelativeLayout)view;
    }

    @Override
    protected void initComp(Object value) {
        docLabelFirst = (RelativeLayout)findViewById(R.id.doc_label_first_rl);
        lyDocLabelFirst = (LinearLayout)findViewById(R.id.doc_label_first_ly);
        docLabelSecond = (RelativeLayout)findViewById(R.id.doc_label_second_rl);
        lyDocLabelSecond = (LinearLayout)docLabelSecond.findViewById(R.id.doc_videodoc_label_second);
        lyDocLabelSecondLeft = (LinearLayout)docLabelSecond.findViewById(R.id.doc_videodoc_label_second_left);
        lyDocLabelSecondRight = (LinearLayout)docLabelSecond.findViewById(R.id.doc_videodoc_label_second_right);

        colorBar = (ColorBar)docLabelSecond.findViewById(R.id.docColorBar);
        colorBar.setOnColorChangerListener(this);

        penSelectIv = (ImageView)findViewById(R.id.doc_videodoc_pen);
        penSelectIv.setOnClickListener(this);
        penSizeOneIv = (ImageView)findViewById(R.id.doc_videodoc_size_one_iv);
        penSizeOneIv.setOnClickListener(this);
        penSizeThreeIv = (ImageView)findViewById(R.id.doc_videodoc_size_three_iv);
        penSizeThreeIv.setOnClickListener(this);
        penSizeSixIv = (ImageView)findViewById(R.id.doc_videodoc_size_six_iv);
        penSizeSixIv.setOnClickListener(this);
        penRubberIv = (ImageView)findViewById(R.id.doc_videodoc_rubber);
        penRubberIv.setOnClickListener(this);
        penClearIv = (ImageView)findViewById(R.id.doc_videodoc_clear);
        penClearIv.setOnClickListener(this);
        penPreStepIv = (ImageView)findViewById(R.id.doc_videodoc_pre);
        penPreStepIv.setOnClickListener(this);
        penNextStepIv = (ImageView)findViewById(R.id.doc_videodoc_next);
        penNextStepIv.setOnClickListener(this);
        penPreStepIv.setEnabled(false);
        penNextStepIv.setEnabled(false);
        super.initComp(value);
        mGsDocViewGx.setOnDocLabelListener(this);
        initPenStyle();
    }

    @Override
    public void onClick(View v) {
        switch (v.getId())
        {
            case R.id.doc_videodoc_pen:
                mGsDocViewGx.setAnnoMakeType(DrawMode.PEN);
                penSelectIv.setSelected(!penSelectIv.isSelected());
                if(penSelectIv.isSelected())
                {
                    docLabelSecond.setVisibility(View.VISIBLE);
                    mGsDocViewGx.setCtrlMode(CtrlMode.EDIT);
                    if(null != onDocLabelExitListener)
                    {
                        onDocLabelExitListener.onDocLabelStart();
                    }
                }
                else {
                    setDocLabelSecondVisibleGone();
                    mGsDocViewGx.setCtrlMode(CtrlMode.SIGHT);
                }
                //橡皮擦选中，则重置
                if(penRubberIv.isSelected())
                {
                    penRubberIv.setSelected(!penRubberIv.isSelected());
                }
                break;
            case R.id.doc_videodoc_size_one_iv:
                mGsDocViewGx.setStrokeWidth(LINE_SIZE.L);
                selectPenStyleSize(v);
                break;
            case R.id.doc_videodoc_size_three_iv:
                mGsDocViewGx.setStrokeWidth(LINE_SIZE.M);
                selectPenStyleSize(v);
                break;
            case R.id.doc_videodoc_size_six_iv:
                mGsDocViewGx.setStrokeWidth(LINE_SIZE.H);
                selectPenStyleSize(v);
                break;
            case R.id.doc_videodoc_rubber:
                penRubberIv.setSelected(!penRubberIv.isSelected());
                if(penRubberIv.isSelected()) {
                    mGsDocViewGx.setCtrlMode(CtrlMode.EDIT);
                    mGsDocViewGx.setAnnoMakeType(DrawMode.ERASE);
                }
                else {
                    mGsDocViewGx.setCtrlMode(CtrlMode.SIGHT);
                }
                if(penSelectIv.isSelected())
                {
                    setDocLabelSecondVisibleGone();
                    penSelectIv.setSelected(false);
                }
                break;
            case R.id.doc_videodoc_clear:
                mGsDocViewGx.eraseAll();
                resetStatus();
                break;
            case R.id.doc_videodoc_pre:
                penPreStep();
                break;
            case R.id.doc_videodoc_next:
                penNextStep();
                break;
        }
    }

    private void initPenStyle()
    {
        selectPenStyleSize(penSizeThreeIv);
        penSelectIv.setSelected(false);
        mGsDocViewGx.setPaintColor(getContext().getResources().getColor(R.color.pen_black));
        mGsDocViewGx.setStrokeWidth(LINE_SIZE.M);
        mGsDocViewGx.setCtrlMode(CtrlMode.SIGHT);
        penRubberIv.setSelected(false);
        colorBar.resetValue();
    }

    private void selectPenStyleSize(View view)
    {
        penSizeOneIv.setSelected(penSizeOneIv.getId() == view.getId());
        penSizeThreeIv.setSelected(penSizeThreeIv.getId() == view.getId());
        penSizeSixIv.setSelected(penSizeSixIv.getId() == view.getId());
    }

    @Override
    public void colorChange(int color, int position, boolean bShowPopView) {
        mGsDocViewGx.setPaintColor(color);
    }

    public void setDocLabelSecondVisibleGone()
    {
        docLabelSecond.setVisibility(View.GONE);
    }


    @Override
    public void onDocLabelStart() {
        if(docLabelSecond.getVisibility() == View.VISIBLE)
        {
            setDocLabelSecondVisibleGone();
        }
    }

    @Override
    public void onDocLabelStop() {
        if(docLabelSecond.getVisibility() != View.VISIBLE)
        {
            docLabelSecond.setVisibility(View.VISIBLE);
        }
    }

    @Override
    public void onDocLabelSingleClick() {
        if(penSelectIv.isSelected())
        {
            if(docLabelSecond.getVisibility() == View.VISIBLE)
            {
                setDocLabelSecondVisibleGone();
            }else if(docLabelSecond.getVisibility() == View.GONE)
            {
                docLabelSecond.setVisibility(View.VISIBLE);
            }
        }
    }

    @Override
    public long getAnnoEraseUserId() {

        return 0;
    }

    public void onRoomReconnect()
    {
        penPreStepIv.setEnabled(false);
        penNextStepIv.setEnabled(false);
        penClearIv.setEnabled(false);
        penRubberIv.setEnabled(false);
    }

    public void onRoomJoinSuccess()
    {
        penClearIv.setEnabled(true);
        penRubberIv.setEnabled(true);
        penPreStepIv.setEnabled(mGsDocViewGx.getUndoStackSize() > 0);
        penNextStepIv.setEnabled(mGsDocViewGx.getRedoStackSize() > 0);
    }

    public boolean isDocLabelStart()
    {
        return penSelectIv.isSelected();
    }

    public boolean isDocLabelOpen()
    {
        return docLabelFirst.getVisibility() == View.VISIBLE;
    }

    public interface OnDocLabelExitListener
    {
        void onDocLabelExit();
        void onDocLabelStart();
    }
}
