package com.gensee.rtdemo.holder.doc;

import android.view.View;
import android.widget.ImageView;

import com.gensee.doc.OnAnnoEraseUserIdListener;
import com.gensee.pdu.OnReAndUndoListener;
import com.gensee.rtdemo.holder.BaseHolder;
import com.gensee.view.GSDocViewGx;

/**
 * Created by Administrator on 2017/9/19.
 */

public class DocLabelHolder extends BaseHolder implements OnAnnoEraseUserIdListener, OnReAndUndoListener {

    protected GSDocViewGx mGsDocViewGx;
    protected ImageView penPreStepIv;
    protected ImageView penNextStepIv;

    @Override
    protected void initData(Object value) {

    }

    @Override
    protected void initComp(Object value) {
        mGsDocViewGx = (GSDocViewGx)value;
        mGsDocViewGx.setOnAnnoEraseUserIdListener(this);
        mGsDocViewGx.setOnReAndUndoListener(this);
    }

    @Override
    public void onClick(View v) {

    }

    public DocLabelHolder(View rootView, Object value) {
        super(rootView, value);
    }


    protected void penPreStep()
    {
        mGsDocViewGx.undoStep();
    }

    protected void penNextStep()
    {
        mGsDocViewGx.redoStep();
    }


    protected void resetStatus()
    {
        mGsDocViewGx.resetStatus();
        penNextStepIv.setEnabled(false);
        penPreStepIv.setEnabled(false);
    }

    @Override
    public long getAnnoEraseUserId() {
        return 0;
    }

    @Override
    public void onNextStepEnable(boolean bEnable) {
        penNextStepIv.setEnabled(bEnable);
    }

    @Override
    public void onPreStepEnable(boolean bEnable) {
        penPreStepIv.setEnabled(bEnable);
    }

    @Override
    public void onSwitchDocOrPage() {
        penNextStepIv.setEnabled(false);
        penPreStepIv.setEnabled(false);
    }
}
