package com.gensee.rtdemo;

import android.app.Activity;
import android.content.Context;
import android.hardware.Camera;
import android.os.Bundle;
import android.view.View;

import com.gensee.callback.IAudioCallBack;
import com.gensee.callback.IRoomCallBack;
import com.gensee.callback.IVideoCallBack;
import com.gensee.common.ServiceType;
import com.gensee.demo.DemoConfig;
import com.gensee.demo.R;
import com.gensee.entity.InitParam;
import com.gensee.entity.LiveInfo;
import com.gensee.net.RtComp;
import com.gensee.net.RtComp.Callback;
import com.gensee.room.RtSdk;
import com.gensee.routine.GSCountDownInfo;
import com.gensee.routine.GSResponderInfo;
import com.gensee.routine.IRTEvent;
import com.gensee.routine.LayoutInfo;
import com.gensee.routine.State;
import com.gensee.routine.UserInfo;
import com.gensee.view.GSVideoView;
import com.gensee.view.ILocalVideoView;
import com.gensee.view.beauty.GSLocalVideoView;

import java.util.Map;

public class VideoTalkActivity extends Activity implements Callback, IRoomCallBack,IVideoCallBack,IAudioCallBack {

	private GSLocalVideoView localVideoView;//
	private GSVideoView otherVideoView1;
	private RtComp comp;
	private RtSdk rtSdk;
	private boolean isVideoJoinConfirm,isVideoCameraAvailiable;
	private UserInfo self = null; //己方用户信息
	private long otherUserId = 0;//对方用户id
	
	@Override
	protected void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		setContentView(R.layout.activity_video_talk);
		localVideoView = (GSLocalVideoView) findViewById(R.id.localVideoViewEx);
		//设置为竖屏采集且采集画面尺寸比例为9：16
		localVideoView.setOrientation(ILocalVideoView.ORIENTATION_PORTRAIT_9_16);
		localVideoView.setVideoSize(640,480);
//		localVideoView.setHardEncode(true);
		otherVideoView1 = (GSVideoView) findViewById(R.id.otherVideoView);
		startJoin();

		localVideoView.setOnClickListener(new View.OnClickListener() {
			@Override
			public void onClick(View v) {
				localVideoView.doCameraSwitch();
			}
		});
		localVideoView.setOnCameraInfoListener(new ILocalVideoView.OnCameraInfoListener() {
			@Override
			public void onCameraInfo(final  Camera camera, Camera.CameraInfo cameraInfo, int i) {

				if (cameraInfo.facing == Camera.CameraInfo.CAMERA_FACING_BACK) {
					localVideoView.postDelayed(new Runnable() {
						@Override
						public void run() {
							camera.autoFocus(new Camera.AutoFocusCallback() {
								@Override
								public void onAutoFocus(boolean success, Camera camera) {

								}
							});
						}
					}, 1000);
				}


			}

			@Override
			public void onCameraOpen(boolean b) {

			}

			@Override
			public void onManualFocus(boolean b) {

			}

			@Override
			public void onPreviewSize(int i, int i1) {

			}
		});
	}

	private void startJoin() {
		rtSdk = new RtSdk();


		InitParam p = DemoConfig.getIns().getInitParam();
		if (comp != null) {
			comp.setCallback(null);
		}
		comp = new RtComp(this, this);
		//这个调用后响应onErr 或 onInited
		comp.initWithGensee(p);
	}


	private void openCamara(){
		rtSdk.videoOpenCamera(null);
	}

	private void openMic(){
		rtSdk.audioOpenMic(null);
	}



	
	/**********************RtComp.Callback*************************/
	
	@Override
	public void onErr(int arg0) {
		//TODO 请对应的处理错误码
	}

	@Override
	public void onInited(String joinParam) {
		rtSdk.initWithParam("",joinParam,this);
		
	}
	
	/**********************IAudioCallBack*************************/
	@Override
	public void onAudioJoinConfirm(boolean arg0) {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void onAudioLevel(int arg0, long arg1) {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void onAudioMicAvailable(boolean arg0) {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void onAudioMicClosed() {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void onAudioMicOpened() {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void onAudioSpeakerClosed() {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void onAudioSpeakerOpened() {
		// TODO Auto-generated method stub
		
	}
	
	/*******************************IVideoCallBack************************************/

	@Override
	public void onVideoActived(UserInfo arg0, boolean arg1) {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void onVideoCameraAvailiable(boolean arg0) {
		isVideoCameraAvailiable = arg0;
		if(isVideoCameraAvailiable && isVideoJoinConfirm){
			openCamara();
		}
	}

	@Override
	public void onVideoCameraClosed() {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void onVideoCameraOpened() {
		//自己的摄像头已经打开
	}

	@Override
	public void onVideoDataRender(long userId, int width, int height,int frameFormat, float displayRatio, byte[] data) {
		if(userId == otherUserId){
			otherVideoView1.onReceiveFrame(data,width,height);
		}

	}

	@Override
	public void onVideoDisplay(UserInfo arg0) {
	}

	@Override
	public void onVideoJoin(UserInfo info) {
		if (info != null) {
			//不是自己的视频通知且对方还没订阅过对方的视频，那么就diplayVideo（对方）
			if (info.getId() != self.getId() && otherUserId == 0) {
				otherUserId = info.getId();
				rtSdk.displayVideo(otherUserId, null);
			}
		}
	}

	/**
	 * 视频模块加载结果
	 * @param arg0 true 成功/ false 失败
	 */
	@Override
	public void onVideoJoinConfirm(boolean arg0) {
		isVideoJoinConfirm = arg0;
		if (isVideoCameraAvailiable && isVideoJoinConfirm) {
			openCamara();
		}
	}

	@Override
	public void onVideoLeave(long userId) {
		if(userId == otherUserId){
			rtSdk.unDisplayVideo(userId,null);
			otherUserId = 0;
		}
	}

	@Override
	public void onVideoUndisplay(long arg0) {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void OnUpgradeNotify(String arg0) {
		// TODO Auto-generated method stub
		
	}

	@Override
	public ServiceType getServiceType() {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public void onChatMode(int arg0) {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void onFreeMode(boolean arg0) {
		// TODO Auto-generated method stub
		
	}

	@Override
	public Context onGetContext() {
		return this.getApplicationContext();
	}

	@Override
	public void onInit(boolean isOk) {
		if (isOk) {
			rtSdk.setVideoCallBack(this);
			rtSdk.setAudioCallback(this);
			rtSdk.setLocalVideoView(localVideoView);
			rtSdk.join(null);
		} else {
			//TODO rtSdk初始化失败
		}
	}

	@Override
	public void onJoin(boolean arg0) {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void onLottery(byte arg0, String arg1) {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void onNetworkBandwidth(int arg0, int arg1) {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void onNetworkReport(byte arg0) {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void onRoomBroadcastMsg(String arg0) {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void onRoomData(String arg0, long arg1) {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void onRoomHanddown(long arg0) {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void onRoomHandup(long arg0, String arg1) {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void onRoomJoin(int result, UserInfo self, boolean arg2) {
		if(result == IRTEvent.IRoomEvent.JoinResult.JR_OK){
			//自己加入成功
			this.self = self;
		}else {
			//TODO 加入直播间失败
		}
		
	}

	@Override
	public void onRoomLeave(int arg0) {
		rtSdk.release(null);
		finish();
		
	}

	@Override
	public void onRoomLock(boolean arg0) {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void onRoomPhoneCallingStatus(String arg0, int arg1, int arg2) {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void onRoomPhoneServiceStatus(boolean arg0) {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void onRoomPublish(State arg0) {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void onRoomReconnecting() {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void onRoomRecord(State arg0) {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void onRoomRollcall(int arg0) {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void onRoomRollcallAck(long arg0) {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void onRoomUserJoin(UserInfo arg0) {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void onRoomUserLeave(UserInfo arg0) {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void onRoomUserUpdate(UserInfo arg0) {
		// TODO Auto-generated method stub
		
	}

	@Override
	public String onSettingQuery(String arg0) {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public int onSettingQuery(String arg0, int arg1) {
		// TODO Auto-generated method stub
		return 0;
	}

	@Override
	public void onSettingSet(String arg0, int arg1) {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void onSettingSet(String arg0, String arg1) {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void onLiveInfo(LiveInfo liveInfo) {

	}

	@Override
	public void onRoomWebLayoutChange(int i) {

	}

	@Override
	public void onLessonTimerStart(long l) {

	}

	@Override
	public void onLessonTimerPaused(boolean b) {

	}

	@Override
	public void onBackPressed() {
		if (rtSdk != null) {
			rtSdk.leave(self.isHost(), null);
		} else {
			super.onBackPressed();
		}
	}

	@Override
	public void onRoomData(String s, String s1) {

	}

	@Override
	public void onRandomSelect(byte b, String s) {

	}

	@Override
	public void onRoomClassAlarm(int i) {

	}

	@Override
	public void onRoomBroadcastCmd(Map map) {

	}

	@Override
	public void onLayoutSync(LayoutInfo layoutInfo) {

	}

	@Override
	public void onRoomCountDown(GSCountDownInfo gsCountDownInfo) {

	}

	@Override
	public void onRoomPresentorChanged(long l) {

	}

	@Override
	public void onRoomResponsderInfo(GSResponderInfo gsResponderInfo) {

	}
	@Override
	public void onRoomNavigate(String s) {

	}

	@Override
	public void onRoomClassReuninCmd() {

	}

	@Override
	public void onRoomClassSeparateCmd() {

	}

	@Override
	public void onRoomSubClassUserNum(int i) {

	}

	@Override
	public void onRoomDBTDataPrepared() {

	}
}
