package com.gensee.rtdemo;

import android.app.Activity;
import android.content.Context;
import android.graphics.Color;
import android.os.Bundle;
import android.os.Handler;
import android.view.View;
import android.view.View.OnClickListener;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.Button;
import android.widget.ListView;
import android.widget.TextView;
import android.widget.Toast;

import com.gensee.callback.IChatCallBack;
import com.gensee.callback.IDocCallBack;
import com.gensee.callback.IQACallback;
import com.gensee.callback.IRoomCallBack;
import com.gensee.common.ServiceType;
import com.gensee.demo.DemoConfig;
import com.gensee.demo.R;
import com.gensee.entity.ChatMsg;
import com.gensee.entity.LiveInfo;
import com.gensee.entity.LoginResEntity;
import com.gensee.net.RtComp;
import com.gensee.net.RtComp.Callback;
import com.gensee.pdu.AbsAnno;
import com.gensee.pdu.PduDoc;
import com.gensee.pdu.PduPage;
import com.gensee.qa.QaQuestion;
import com.gensee.room.RTRoom;
import com.gensee.room.RtSdk;
import com.gensee.routine.GSCountDownInfo;
import com.gensee.routine.GSResponderInfo;
import com.gensee.routine.LayoutInfo;
import com.gensee.routine.State;
import com.gensee.routine.UserInfo;
import com.gensee.taskret.OnTaskRet;
import com.gensee.utils.GenseeLog;
import com.gensee.view.GSDocViewGx;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class VideoDocChatList extends Activity implements OnClickListener,IRoomCallBack, IDocCallBack {

	protected static final String TAG = "VideoDocChatList";
//	private GSVideoView gsVideoView ;
	private GSDocViewGx  docViewGx,docview1;
	private ListView listView;
	private BaseAdapter adapter;
	private List<String> data = new ArrayList<String>();
	private RtSdk rtSdk = null;
	RtComp comp = null;
	
	
	@Override
	protected void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		setContentView(R.layout.activity_vi_doc_chat);
//		gsVideoView = (GSVideoView) findViewById(R.id.videoView);
//		gsVideoView.renderDrawble(((BitmapDrawable)getResources().getDrawable(R.drawable.ic_launcher)).getBitmap(), true);
//		gsVideoView.setZOrderOnTop(true);
		
//		gsVideoView.setZOrderMediaOverlay(true);
		docViewGx = (GSDocViewGx) findViewById(R.id.docView);
		docview1 = (GSDocViewGx) findViewById(R.id.docView1);
		listView = (ListView) findViewById(R.id.listview);
		listView.setBackgroundColor(Color.BLUE);
		adapter = new BaseAdapter() {
			
			@Override
			public View getView(int position, View convertView, ViewGroup parent) {
				TextView tv = null;
				if (convertView == null) {
					tv = new TextView(listView.getContext());
					tv.setBackgroundColor(Color.RED);
					convertView = tv;
				} else {
					tv = (TextView) convertView;
				}
				tv.setText(data.get(position));
				return convertView;
			}
			
			@Override
			public long getItemId(int position) {
				return position;
			}
			
			@Override
			public Object getItem(int position) {
				return data.get(position);
			}
			
			@Override
			public int getCount() {
				return data.size();
			}
		};
		listView.setAdapter(adapter);
		findViewById(R.id.btnList).setOnClickListener(this);
		findViewById(R.id.btnVideoView).setOnClickListener(this);
		findViewById(R.id.btnVadView).setOnClickListener(this);
		findViewById(R.id.btnAgcView).setOnClickListener(this);
		findViewById(R.id.btnEcView).setOnClickListener(this);
		findViewById(R.id.btnNsView).setOnClickListener(this);

		

		initParam();
	}


	int count = 0;
	@Override
	public void onClick(final View v) {
		switch (v.getId()) {
		case R.id.btnList:
			count ++;
			data.add("msg" + count);
			adapter.notifyDataSetChanged();
			break;
		case R.id.btnVideoView:
//			if (gsVideoView.getVisibility() == View.VISIBLE){
//				gsVideoView.setVisibility(View.INVISIBLE);
//			}else {
//				gsVideoView.setVisibility(View.VISIBLE);
//			}
			break;
			case R.id.btnVadView:
				RTRoom.getIns().getRoutine().audioSetVadFlag(!v.isSelected(), new OnTaskRet() {
					@Override
					public void onTaskRet(boolean b, int i, String s) {
							vad(b?!v.isSelected():v.isSelected());
					}
				});
				break;
			case R.id.btnAgcView:
				RTRoom.getIns().getRoutine().audioSetAgcFlag(!v.isSelected(), new OnTaskRet() {
					@Override
					public void onTaskRet(boolean b, int i, String s) {
						agc(b?!v.isSelected():v.isSelected());
					}
				});
				break;
			case R.id.btnEcView:
				RTRoom.getIns().getRoutine().audioSetEcFlag(!v.isSelected(), new OnTaskRet() {
					@Override
					public void onTaskRet(boolean b, int i, String s) {
						ec(b?!v.isSelected():v.isSelected());
					}
				});
				break;
			case R.id.btnNsView:
				RTRoom.getIns().getRoutine().audioSetNoiseFlag(!v.isSelected(), new OnTaskRet() {
					@Override
					public void onTaskRet(boolean b, int i, String s) {
						ns(b?!v.isSelected():v.isSelected());
					}
				});
				break;
		default:
			break;
		}
		
	}

	private void ec(final boolean isOpen){
		runOnUiThread(new Runnable() {
			@Override
			public void run() {
				Button b = findViewById(R.id.btnEcView);
				b.setSelected(isOpen);
				b.setText("回音消除已"+(isOpen?"开":"关"));
			}
		});
	}

	private void vad(final boolean isOpen){
		runOnUiThread(new Runnable() {
			@Override
			public void run() {
				Button b = findViewById(R.id.btnVadView);
				b.setSelected(isOpen);
				b.setText("静音检测已"+(isOpen?"开":"关"));
			}
		});
	}

	private void agc(final boolean isOpen){
		runOnUiThread(new Runnable() {
			@Override
			public void run() {
				Button b = findViewById(R.id.btnAgcView);
				b.setSelected(isOpen);
				b.setText("音量自适已"+(isOpen?"开":"关"));
			}
		});
	}
	private void ns(final boolean isOpen){
		runOnUiThread(new Runnable() {
			@Override
			public void run() {
				Button b = findViewById(R.id.btnNsView);
				b.setSelected(isOpen);
				b.setText("噪音抑制已"+(isOpen?"开":"关"));
			}
		});
	}
	
	@Override
	protected void onResume() {
		super.onResume();
//		gsVideoView.setZOrderOnTop(true);
	}
	
	private void initParam(){
//		InitParam initParam = new InitParam();
//		initParam.setDomain("192.168.1.106");
//		initParam.setNumber("24297228");
//		initParam.setNickName("hello");
//		initParam.setJoinPwd("");
//		initParam.setUserId(1000000001);
//		initParam.setServiceType(ServiceType.WEBCAST);

		comp = new RtComp(this, new Callback() {
			
			@Override
			public void onErr(final int arg0) {
				runOnUiThread(new Runnable() {

					@Override
					public void run() {
						Toast.makeText(VideoDocChatList.this, "onErr " + arg0,
								Toast.LENGTH_SHORT).show();
					}
				});
				rtSdk = null;
			}
			
			@Override
			public void onInited(String rtParam) {
				initRtSDK();
				rtSdk.initWithParam("", rtParam, VideoDocChatList.this);
			}


		}){
            @Override
            protected void onLoginEnd(LoginResEntity loginResEntity) {
                initRtSDK();
//                loginResEntity.setClientApi("http://product.gensee.com/clientapi/apichannel?sc=1&upgrade=true");
                loginResEntity.setClientApi("http://product.gensee.com/clientapi/apichannel?sc=0");
                rtSdk.initWithWebApi(loginResEntity,VideoDocChatList.this);
//                super.onLoginEnd(loginResEntity);
            }
        };

		comp.initWithGensee(DemoConfig.getIns().getInitParam());
	}
	private void initRtSDK(){
		rtSdk = new RtSdk();
		rtSdk.setGSDocViewGx(docViewGx);
//		rtSdk.setGSDocViewGx(docview1);
		rtSdk.setDocCallback(this);
		rtSdk.setChatCallback(new IChatCallBack() {

			@Override
			public void onChatMessage(ChatMsg chatMsg) {

			}

			@Override
			public void onChatCensor(long l, String s) {

			}

			@Override
			public void onChatJoinConfirm(boolean bRet) {
				// TODO Auto-generated method stub
				
			}
			
			@Override
			public void onChatEnable(boolean enable) {
				GenseeLog.d(TAG, "onChatEnable " + enable);
			}
		});
	
		rtSdk.setQACallback(new IQACallback() {
			
			@Override
			public void onQaSettingUpdate(boolean isAutoDispatchQuestion,
					boolean isAutoPublishQuestion, boolean isQAEnable) {
				GenseeLog.d(TAG, "onQaSettingUpdate " + isQAEnable);
				
			}
			
			@Override
			public void onQaQuestion(QaQuestion qaQuestion, int state) {
				// TODO Auto-generated method stub
				
			}
			
			@Override
			public void onQaJoinConfirm(int isOk) {
				// TODO Auto-generated method stub
				
			}
		});
	}

	@Override
	public void onInit(boolean result) {
		if(result){
			rtSdk.join(null);
		}
	}

	@Override
	public void onJoin(boolean result) {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void onRoomJoin(int result, UserInfo self, boolean svrFailover) {
		// TODO Auto-generated method stub

		listView.postDelayed(new Runnable() {
			@Override
			public void run() {
				RTRoom.getIns().getRoutine().audioGetAgcFlag(new OnTaskRet() {
					@Override
					public void onTaskRet(boolean b, int i, String s) {
						agc(b);
					}
				});RTRoom.getIns().getRoutine().audioGetVadFlag(new OnTaskRet() {
					@Override
					public void onTaskRet(boolean b, int i, String s) {
						vad(b);
					}
				});RTRoom.getIns().getRoutine().audioGetNoiseFlag(new OnTaskRet() {
					@Override
					public void onTaskRet(boolean b, int i, String s) {
						ns(b);
					}
				});RTRoom.getIns().getRoutine().audioGetEcFlag(new OnTaskRet() {
					@Override
					public void onTaskRet(boolean b, int i, String s) {
						ec(b);
					}
				});
			}
		},10000);

		
	}

	@Override
	public void onRoomLeave(int reason) {
		rtSdk.release(new OnTaskRet() {
			@Override
			public void onTaskRet(boolean b, int i, String s) {
				runOnUiThread(new Runnable() {
					@Override
					public void run() {
						finish();
					}
				});
			}
		});
		
	}

	@Override
	public void onRoomReconnecting() {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void onRoomLock(boolean locked) {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void onRoomUserJoin(UserInfo userInfo) {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void onRoomUserUpdate(UserInfo userInfo) {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void onRoomUserLeave(UserInfo userInfo) {
		// TODO Auto-generated method stub
		
	}

	@Override
	public Context onGetContext() {
		return this;
	}

	@Override
	public ServiceType getServiceType() {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public void onRoomPublish(State s) {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void onRoomRecord(State s) {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void onRoomData(String key, long value) {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void onRoomBroadcastMsg(String msg) {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void onRoomRollcall(int timeout) {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void onRoomRollcallAck(long userId) {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void onRoomHandup(long userId, String data) {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void onRoomHanddown(long userId) {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void OnUpgradeNotify(String downloadUrl) {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void onChatMode(int nChatMode) {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void onFreeMode(boolean isFreeMode) {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void onLottery(byte type, String sUserlist) {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void onSettingSet(String key, int val) {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void onSettingSet(String key, String val) {
		// TODO Auto-generated method stub
		
	}

	@Override
	public int onSettingQuery(String key, int val) {
		// TODO Auto-generated method stub
		return 0;
	}

	@Override
	public String onSettingQuery(String key) {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public void onNetworkReport(byte level) {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void onNetworkBandwidth(int bpsSend, int bpsRecv) {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void onRoomPhoneServiceStatus(boolean bAvailable) {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void onRoomPhoneCallingStatus(String phoneNumber, int reason,
			int status) {
		// TODO Auto-generated method stub
		
	}


	@Override
	public void onLiveInfo(LiveInfo liveInfo) {

	}

	@Override
	public void onRoomWebLayoutChange(int i) {

	}

	@Override
	public void onLessonTimerPaused(boolean b) {

	}

	@Override
	public void onLessonTimerStart(long l) {

	}

	@Override
	public void onDocPageSize(int i, int i1) {

	}


	@Override
	public void onDocJoinConfirm(boolean b) {

	}

	PduDoc doc ;
	@Override
	public void onDocOpened(PduDoc pduDoc) {

		if(pduDoc != null && pduDoc.getDocName().contains("模")){
			doc = pduDoc;
//			Handler h = docview1.getHandler();
//			h.sendMessage(h.obtainMessage(142, pduDoc.getCurPage()));
		}

	}

	@Override
	public void onDocClosed(int i) {

	}

	@Override
	public void onDocGotoPage(int i, int i1, int i2) {

	}

	@Override
	public void onDocGotoAnimation(int i, int i1, int i2) {

	}

	@Override
	public void onDocSavedOnServer(int i, boolean b, boolean b1) {

	}

	@Override
	public void onDocPageReady(int i, PduPage pduPage, byte[] bytes) {
		if(doc != null && doc.getDocId() == pduPage.getDocId() && pduPage.getPageId() == 0){
			Handler h = docview1.getHandler();
			h.sendMessage(h.obtainMessage(138, doc.getCurPage()));
//            runOnUiThread(new Runnable() {
//                @Override
//                public void run() {
//                    docview1.onUpdate();
//                }
//            });

		}

	}

	@Override
	public void onDocReceiveAnno(int i, int i1, AbsAnno absAnno) {

	}

	@Override
	public void onDocRemoveAnno(int i, int i1, long l) {

	}

	@Override
	public void onDocRename(int i, String s) {

	}

	@Override
	public void onPageChanged(int i, int i1, int i2, int i3) {

	}

	@Override
	public void onBackPressed() {
		if(comp != null){
			comp.setCallback(null);
		}
		if(rtSdk != null){
			rtSdk.leave(false,null);
		}else{
			super.onBackPressed();
		}
	}


	@Override
	public void onRoomClassAlarm(int i) {

	}

	@Override
	public void onRoomBroadcastCmd(Map map) {

	}

	@Override
	public void onLayoutSync(LayoutInfo layoutInfo) {

	}

	@Override
	public void onRoomData(String s, String s1) {

	}

	@Override
	public void onRandomSelect(byte b, String s) {

	}

	@Override
	public void onRoomCountDown(GSCountDownInfo gsCountDownInfo) {

	}

	@Override
	public void onRoomPresentorChanged(long l) {

	}

	@Override
	public void onRoomResponsderInfo(GSResponderInfo gsResponderInfo) {

	}

	@Override
	public void onDocPublish(int i, boolean b, boolean b1, boolean b2) {

	}

	@Override
	public void onDocUploadStatus(String s, int i, int i1) {

	}
	@Override
	public void onRoomNavigate(String s) {

	}

	@Override
	public void onRoomClassReuninCmd() {

	}

	@Override
	public void onRoomClassSeparateCmd() {

	}

	@Override
	public void onRoomSubClassUserNum(int i) {

	}

	@Override
	public void onRoomDBTDataPrepared() {

	}
}
