package com.gensee.rtdemo;

import android.content.Context;
import android.content.SharedPreferences;

/**
 * Created by pc on 2018/4/10.
 */

public class PrefUtil {
    private static final String PREF_NAME = "gensee_pref";
    public static final String MIC_STATUS = "MIC_STATUS";
    public static final String CAMERA_STATUS = "CAMERA_STATUS";
    public static final String VIDEO_SELF_ACTIVED = "VIDEO_SELF_ACTIVED";
    public static final String PUB_VIDEO_DECODE_TYPE = "PUB_VIDEO_DECODE_TYPE";
    public static final String VIDEO_RESOLUTION = "VIDEO_RESOLUTION";  //0:320*240  1:640*480
    private static PrefUtil prefUtil;
    private SharedPreferences preferences;

    private PrefUtil(Context context) {
        preferences = context.getSharedPreferences(PREF_NAME,
                Context.MODE_PRIVATE);
    }

    public static void initPref(Context context) {
        synchronized (PrefUtil.class) {
            if (null == prefUtil) {
                prefUtil = new PrefUtil(context);
                prefUtil.putInt(MIC_STATUS, -1);
                prefUtil.putInt(CAMERA_STATUS, -1);
                prefUtil.putInt(VIDEO_SELF_ACTIVED, -1);
            }
        }
    }

    public void putInt(String key, int value) {
        preferences.edit().putInt(key, value).commit();
    }

    public int getInt(String key) {
        return preferences.getInt(key, -1);
    }

    public void putBoolean(String key,boolean bool){
        preferences.edit().putBoolean(key, bool).commit();
    }

    public boolean getBoolean(String key){
        return preferences.getBoolean(key, false);
    }

    public static PrefUtil getIns() {
        return prefUtil;
    }
}
