package com.gensee.rtdemo;

import android.app.Activity;
import android.content.Intent;
import android.os.Bundle;
import android.view.View;
import android.view.View.OnClickListener;
import android.widget.CheckBox;
import android.widget.CompoundButton;
import android.widget.ImageView;

import com.gensee.demo.R;
import com.gensee.rtdemo.robot.RobotPenDocActivity;

public class GuideActivity extends Activity {
	private ImageView imageView;

	private CheckBox cbVideoDecodeType;
	private CheckBox cbVideo640480;

	@Override
	protected void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		setContentView(R.layout.activity_guide);
//		GenseeConfig.thirdCertificationAuth = false;
		PrefUtil.initPref(this);
		imageView = (ImageView) findViewById(R.id.imgView);
		imageView.setOnClickListener(new OnClickListener() {
			
			@Override
			public void onClick(View v) {
				v.setVisibility(View.GONE);
			}
		});
		findViewById(R.id.btnMutiVideo).setOnClickListener(
				new OnClickListener() {

					@Override
					public void onClick(View v) {
						startActivity(new Intent(GuideActivity.this,
								MutiVideoActivity.class));
					}
				});
		findViewById(R.id.btnSingleVideo).setOnClickListener(
				new OnClickListener() {

					@Override
					public void onClick(View v) {
						startActivity(new Intent(getApplication(),
								SimpleActivity.class));

					}
				});

//		findViewById(R.id.btnMutiView1).setOnClickListener(new OnClickListener() {
//
//			@Override
//			public void onClick(View v) {
//				imageView(R.drawable.muti_1);
//			}
//		});
//		findViewById(R.id.btnMutiView2).setOnClickListener(new OnClickListener() {
//
//			@Override
//			public void onClick(View v) {
//				imageView(R.drawable.muti_2);
//			}
//		});
//		findViewById(R.id.btnSigleView1).setOnClickListener(new OnClickListener() {
//
//			@Override
//			public void onClick(View v) {
//				imageView(R.drawable.single_1);
//			}
//		});
//		findViewById(R.id.btnSigleView2).setOnClickListener(new OnClickListener() {
//
//			@Override
//			public void onClick(View v) {
//				imageView(R.drawable.single_2);
//			}
//		});
//		findViewById(R.id.btnSigleView3).setOnClickListener(new OnClickListener() {
//
//			@Override
//			public void onClick(View v) {
//				imageView(R.drawable.single_3);
//			}
//		});
		findViewById(R.id.btnVideoTalk).setOnClickListener(new OnClickListener() {

			@Override
			public void onClick(View v) {
				startActivity(new Intent(GuideActivity.this, VideoTalkActivity.class));
			}
		});
        findViewById(R.id.btnClass).setOnClickListener(new OnClickListener() {

            @Override
            public void onClick(View v) {
                startActivity(new Intent(GuideActivity.this, SmallClassActivity.class));
            }
        });
        findViewById(R.id.btnDocModule).setOnClickListener(new OnClickListener() {

            @Override
            public void onClick(View v) {
				startActivity(new Intent(GuideActivity.this,DocActivity.class));
            }
        });

        findViewById(R.id.btnRobotDocModule).setOnClickListener(new View.OnClickListener()
		{
			@Override
			public void onClick(View v) {
				startActivity(new Intent(GuideActivity.this,RobotPenDocActivity.class));
			}
		});

        findViewById(R.id.btnAvs).setOnClickListener(new OnClickListener() {
			@Override
			public void onClick(View v) {
//				startActivity(new Intent(GuideActivity.this,AVsTestActivity.class));
				startActivity(new Intent(GuideActivity.this,VideoDocChatList.class));
			}
		});
        findViewById(R.id.btnCustomCapture).setOnClickListener(new OnClickListener() {
			@Override
			public void onClick(View v) {
//				startActivity(new Intent(GuideActivity.this,AVsTestActivity.class));
				startActivity(new Intent(GuideActivity.this,CustomCaptureActvity.class));
			}
		});

        initAVs();
	}

	private void initAVs()
	{
		boolean bVideoDecodeType = PrefUtil.getIns().getBoolean(PrefUtil.PUB_VIDEO_DECODE_TYPE);
		cbVideoDecodeType = (CheckBox)findViewById(R.id.cbVideoDecodeType);
		cbVideoDecodeType.setChecked(bVideoDecodeType);
		cbVideoDecodeType.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener() {
			@Override
			public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
				PrefUtil.getIns().putBoolean(PrefUtil.PUB_VIDEO_DECODE_TYPE, isChecked);
			}
		});

		int resolution = PrefUtil.getIns().getInt(PrefUtil.VIDEO_RESOLUTION);
		cbVideo640480 = (CheckBox)findViewById(R.id.cbVideo640480);
		cbVideo640480.setChecked(resolution > 0);
		cbVideo640480.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener() {
			@Override
			public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
				PrefUtil.getIns().putInt(PrefUtil.VIDEO_RESOLUTION, isChecked? 1 : 0);
			}
		});
	}
	
	private void imageView(int res){
		imageView.setVisibility(View.VISIBLE);
		imageView.setImageResource(res);
	}
	
	@Override
	public void onBackPressed() {
		if (imageView.getVisibility() == View.VISIBLE) {
			imageView.setVisibility(View.GONE);
		} else {
			// 一般在程序退出的时候调用 
//			GSDemoApp.getIns().releaseVodeSite();
			super.onBackPressed();
		}
	}
}
