package com.gensee.rtdemo;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.hardware.Camera;
import android.hardware.Camera.Parameters;
import android.os.Bundle;
import android.view.View;
import android.widget.Toast;

import com.gensee.callback.IAudioCallBack;
import com.gensee.callback.IRoomCallBack;
import com.gensee.callback.IVideoCallBack;
import com.gensee.common.GenseeConfig;
import com.gensee.common.ServiceType;
import com.gensee.entity.InitParam;
import com.gensee.entity.LiveInfo;
import com.gensee.net.RtComp;
import com.gensee.net.RtComp.Callback;
import com.gensee.room.RtSdk;
import com.gensee.routine.GSCountDownInfo;
import com.gensee.routine.GSResponderInfo;
import com.gensee.routine.LayoutInfo;
import com.gensee.routine.State;
import com.gensee.routine.UserInfo;
import com.gensee.taskret.OnTaskRet;
import com.gensee.view.ILocalVideoView;
import com.gensee.view.LocalVideoViewEx;

import java.util.List;
import java.util.Map;

public class FullscreenPubVideo extends Activity implements Callback ,IVideoCallBack,IRoomCallBack,IAudioCallBack{
	private LocalVideoViewEx localVideoViewEx;
	private RtSdk rtSdk;
	private RtComp comp;
	private UserInfo self;
	@Override
	protected void onCreate(Bundle savedInstanceState) {
		GenseeConfig.isTV = true;
		localVideoViewEx = new LocalVideoViewEx(this);
		localVideoViewEx.setOrientation(ILocalVideoView.ORIENTATION_LANDSCAPE);
		localVideoViewEx.setVideoSize(640, 480);
		localVideoViewEx.setHardEncode(true);
		super.onCreate(savedInstanceState);
		setContentView(localVideoViewEx);
		localVideoViewEx.setOnClickListener(new View.OnClickListener() {
			
			@Override
			public void onClick(View v) {
				showModes();
			}
		});
		rtSdk = new RtSdk();
		comp = new RtComp(this, this);
//		join()
		showAlert();
	}
	
    private void showModes(){
    	final Camera camera
    	     = localVideoViewEx.getCamera();
    	final Parameters parameters = camera.getParameters();
    	final List<String> sms = parameters.getSupportedSceneModes();
    	String[] arr = new String[sms.size()];
    	sms.toArray(arr);
    	new AlertDialog.Builder(this).setSingleChoiceItems(arr, 0, new DialogInterface.OnClickListener(){

			@Override
			public void onClick(DialogInterface dialog, int which) {
				parameters.setSceneMode(sms.get(which));
				camera.setParameters(parameters);
				dialog.dismiss();
			}}).create().show();
    	
    }
	
	
	private void showAlert(){
		
		new AlertDialog.Builder(this).setSingleChoiceItems(new String []{"软编","硬编"}, 0, new DialogInterface.OnClickListener() {
			
			@Override
			public void onClick(DialogInterface dialog, int which) {
				dialog.dismiss();
				if(1 == which){
					localVideoViewEx.setHardEncode(true);	
				}else{
					localVideoViewEx.setHardEncode(false);	
				}
				join();
			}
		}).create().show();
	}
	
	private void join(){
		InitParam param = new InitParam();
		param.setDomain("demo.gensee.com"/*"sfwl.gensee.com"*/);
//		param.setNumber("39361709");
		param.setLiveId("d9ec1bfea9984847a00d1f429d4bc75a");
		param.setJoinPwd("222222");
		param.setNickName("Andoid ");
		param.setServiceType(ServiceType.WEBCAST);
		comp.initWithGensee(param);
	}
	
	@Override
	public void onErr(int arg0) {
		toast("错误 ： 错误码：" + arg0);
	}
	@Override
	public void onInited(String arg0) {
		rtSdk.initWithParam(null, arg0, this);
	}
	@Override
	public void onVideoActived(UserInfo arg0, boolean arg1) {
		// TODO Auto-generated method stub
		
	}
	@Override
	public void onVideoCameraAvailiable(boolean arg0) {
		
	}
	@Override
	public void onVideoCameraClosed() {
		// TODO Auto-generated method stub
		
	}
	@Override
	public void onVideoCameraOpened() {
		rtSdk.videoActive(self.getId(), true, null);
	}
	@Override
	public void onVideoDataRender(long arg0, int arg1, int arg2, int arg3,
			float arg4, byte[] arg5) {
		// TODO Auto-generated method stub
		
	}
	@Override
	public void onVideoDisplay(UserInfo arg0) {
		// TODO Auto-generated method stub
		
	}
	@Override
	public void onVideoJoin(UserInfo arg0) {
		// TODO Auto-generated method stub
		
	}
	@Override
	public void onVideoJoinConfirm(boolean arg0) {
		rtSdk.videoOpenCamera(new OnTaskRet() {
			
			@Override
			public void onTaskRet(boolean arg0, int arg1, String arg2) {
				if(!arg0){
					toast("打开摄像头失败");
				}
			}
		});
	}
	@Override
	public void onVideoLeave(long arg0) {
		// TODO Auto-generated method stub
		
	}
	@Override
	public void onVideoUndisplay(long arg0) {
		// TODO Auto-generated method stub
		
	}
	@Override
	public void OnUpgradeNotify(String arg0) {
		// TODO Auto-generated method stub
		
	}
	@Override
	public ServiceType getServiceType() {
		// TODO Auto-generated method stub
		return null;
	}
	@Override
	public void onChatMode(int arg0) {
		// TODO Auto-generated method stub
		
	}
	@Override
	public void onFreeMode(boolean arg0) {
		// TODO Auto-generated method stub
		
	}
	@Override
	public Context onGetContext() {
		//一定要返回 Context ，关键
		return this;
	}
	@Override
	public void onInit(boolean arg0) {
		rtSdk.setLocalVideoView(localVideoViewEx);
		rtSdk.setAudioCallback(this);
		rtSdk.setVideoCallBack(this);
		rtSdk.join(new OnTaskRet() {
			
			@Override
			public void onTaskRet(boolean arg0, int arg1, String arg2) {
				if(!arg0){
					toast("加入失败");
				}
			}
		});
	}
	@Override
	public void onJoin(boolean arg0) {
		// TODO Auto-generated method stub
		
	}
	@Override
	public void onLottery(byte arg0, String arg1) {
		// TODO Auto-generated method stub
		
	}
	@Override
	public void onNetworkBandwidth(int arg0, int arg1) {
		// TODO Auto-generated method stub
		
	}
	@Override
	public void onNetworkReport(byte arg0) {
		// TODO Auto-generated method stub
		
	}
	@Override
	public void onRoomBroadcastMsg(String arg0) {
		// TODO Auto-generated method stub
		
	}
	@Override
	public void onRoomData(String arg0, long arg1) {
		// TODO Auto-generated method stub
		
	}
	@Override
	public void onRoomHanddown(long arg0) {
		// TODO Auto-generated method stub
		
	}
	@Override
	public void onRoomHandup(long arg0, String arg1) {
		// TODO Auto-generated method stub
		
	}
	@Override
	public void onRoomJoin(int arg0, UserInfo self, boolean arg2) {
		if (arg0 == 0) {
			toast("加入成功");
			this.self = self;
			rtSdk.roomPublish(State.S_RUNNING.getValue(), null);
		}
	}
	@Override
	public void onRoomLeave(int arg0) {
		// TODO Auto-generated method stub
		
	}
	@Override
	public void onRoomLock(boolean arg0) {
		// TODO Auto-generated method stub
		
	}
	@Override
	public void onRoomPhoneCallingStatus(String arg0, int arg1, int arg2) {
		// TODO Auto-generated method stub
		
	}
	@Override
	public void onRoomPhoneServiceStatus(boolean arg0) {
		// TODO Auto-generated method stub
		
	}
	@Override
	public void onRoomPublish(State arg0) {
		// TODO Auto-generated method stub
		
	}
	@Override
	public void onRoomReconnecting() {
		// TODO Auto-generated method stub
		
	}
	@Override
	public void onRoomRecord(State arg0) {
		// TODO Auto-generated method stub
		
	}
	@Override
	public void onRoomRollcall(int arg0) {
		// TODO Auto-generated method stub
		
	}
	@Override
	public void onRoomRollcallAck(long arg0) {
		// TODO Auto-generated method stub
		
	}
	@Override
	public void onRoomUserJoin(UserInfo arg0) {
		// TODO Auto-generated method stub
		
	}
	@Override
	public void onRoomUserLeave(UserInfo arg0) {
		// TODO Auto-generated method stub
		
	}
	@Override
	public void onRoomUserUpdate(UserInfo arg0) {
		// TODO Auto-generated method stub
		
	}
	@Override
	public String onSettingQuery(String arg0) {
		// TODO Auto-generated method stub
		return null;
	}
	@Override
	public int onSettingQuery(String arg0, int arg1) {
		// TODO Auto-generated method stub
		return 0;
	}
	@Override
	public void onSettingSet(String arg0, int arg1) {
		// TODO Auto-generated method stub
		
	}
	@Override
	public void onSettingSet(String arg0, String arg1) {
		// TODO Auto-generated method stub
		
	}
	@Override
	public void onAudioJoinConfirm(boolean arg0) {
		// TODO Auto-generated method stub
		
	}
	@Override
	public void onAudioLevel(int arg0, long arg1) {
		// TODO Auto-generated method stub
		
	}
	@Override
	public void onAudioMicAvailable(boolean arg0) {
		// TODO Auto-generated method stub
		
	}
	@Override
	public void onAudioMicClosed() {
		// TODO Auto-generated method stub
		
	}
	@Override
	public void onAudioMicOpened() {
		// TODO Auto-generated method stub
		
	}
	@Override
	public void onAudioSpeakerClosed() {
		// TODO Auto-generated method stub
		
	}
	@Override
	public void onAudioSpeakerOpened() {
		
	}
	
	private void toast(final String msg){
		runOnUiThread(new Runnable() {
			
			@Override
			public void run() {
				Toast.makeText(FullscreenPubVideo.this, msg, Toast.LENGTH_SHORT).show();
			}
		});
	}
	
	@Override
	public void onBackPressed() {
		rtSdk.leave(false, null);
		rtSdk.release(null);
		super.onBackPressed();
		
		System.exit(0);
	}


	@Override
	public void onLiveInfo(LiveInfo liveInfo) {

	}

	@Override
	public void onRoomWebLayoutChange(int i) {

	}

	@Override
	public void onLessonTimerStart(long l) {

	}

	@Override
	public void onLessonTimerPaused(boolean b) {

	}

	@Override
	public void onRoomClassAlarm(int i) {

	}

	@Override
	public void onRoomBroadcastCmd(Map map) {

	}

	@Override
	public void onLayoutSync(LayoutInfo layoutInfo) {

	}

	@Override
	public void onRoomData(String s, String s1) {

	}

	@Override
	public void onRandomSelect(byte b, String s) {

	}

	@Override
	public void onRoomCountDown(GSCountDownInfo gsCountDownInfo) {

	}

	@Override
	public void onRoomPresentorChanged(long l) {

	}

	@Override
	public void onRoomResponsderInfo(GSResponderInfo gsResponderInfo) {

	}
	@Override
	public void onRoomNavigate(String s) {

	}

	@Override
	public void onRoomClassReuninCmd() {

	}

	@Override
	public void onRoomClassSeparateCmd() {

	}

	@Override
	public void onRoomSubClassUserNum(int i) {

	}

	@Override
	public void onRoomDBTDataPrepared() {

	}
}
