package com.gensee.rtdemo;

import android.animation.Animator;
import android.animation.ObjectAnimator;
import android.animation.ValueAnimator;
import android.opengl.GLSurfaceView;
import android.os.Bundle;
import android.view.View;
import android.view.animation.Animation;
import android.view.animation.ScaleAnimation;
import android.widget.RelativeLayout;

import com.gensee.demo.DemoConfig;
import com.gensee.demo.R;
import com.gensee.live.GSBaseLive;
import com.gensee.utils.GenseeLog;
import com.gensee.view.GSDocViewGx;

import javax.microedition.khronos.egl.EGLConfig;
import javax.microedition.khronos.opengles.GL10;

public class DocActivity extends BaseActivity implements View.OnClickListener{

    private static  final  String TAG = "DocActivity";
    private GSDocViewGx docView;
    private RelativeLayout relView;
    GSBaseLive baseLive;
    private GLSurfaceView glSurfaceView;
    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_doc);
        docView = (GSDocViewGx) findViewById(R.id.docView);
        findViewById(R.id.btnSwitch).setOnClickListener(this);
        findViewById(R.id.btnLog).setOnClickListener(this);
        relView = (RelativeLayout)findViewById(R.id.relvTest);
        glSurfaceView = new GLSurfaceView(this);
        glSurfaceView.setRenderer(new GLSurfaceView.Renderer() {
            @Override
            public void onSurfaceCreated(GL10 gl, EGLConfig config) {

            }

            @Override
            public void onSurfaceChanged(GL10 gl, int width, int height) {

            }

            @Override
            public void onDrawFrame(GL10 gl) {

            }
        });
        relView.addView(glSurfaceView);
        baseLive = new GSBaseLive();
        baseLive.setDocView(docView);
        baseLive.joinLive(DemoConfig.getIns().getInitParam(),this,this);
    }

    @Override
    public void onClick(View v) {
//        if(v.getId()==R.id.btnLog){
//            new Thread(){
//                @Override
//                public void run() {
//                    super.run();
//                    baseLive.getRtSdk().reportDiagonse("rt report test",false,false);
//                }
//            }.start();
//
//            return;
//        }else if(v.getId() == R.id.btnSwitch){
//            new Thread(){
//                @Override
//                public void run() {
//                    super.run();
//                    GenseeLog.reportDiagonse(DocActivity.this,DemoConfig.getIns().getInitParam().getDomain(),DemoConfig.getIns().getInitParam().getServiceType(),"test",true);
//                }
//            }.start();
//
//            return;
//        }

        float scall = glSurfaceView.getScaleX();
        GenseeLog.d(TAG,"scall = " +scall);
        if(v.isSelected()){
            ObjectAnimator animator = ObjectAnimator.ofFloat(relView, "translationX", relView.getWidth() ,0);
            animator.setDuration(3000);
            animator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener() {
                @Override
                public void onAnimationUpdate(ValueAnimator animation) {
                    float vx  = relView.getX();

                    GenseeLog.d(TAG," vx = " +  vx);

                }
            });

            animator.start();



            v.setSelected(false);
        }else{ ObjectAnimator animator = ObjectAnimator.ofFloat(relView, "translationX", 0, relView.getWidth());
            animator.setDuration(3000);
            animator.start();

            ObjectAnimator animatorScall = ObjectAnimator.ofFloat(docView,"scaleX",1,(relView.getWidth() + docView.getWidth())/(float)docView.getWidth());
            animatorScall.setDuration(3000);
//            animatorScall.addUpdateListener(new ValueAnimator.AnimatorUpdateListener() {
//                @Override
//                public void onAnimationUpdate(ValueAnimator animation) {
//                    docView.requestLayout();
//                    RelativeLayout.LayoutParams p = (RelativeLayout.LayoutParams)docView.getLayoutParams();
//                    GenseeLog.d(TAG,"onAnimationUpdate w = " + p.width + " h = " + p.height + " vw = " + docView.getWidth() + " vh = " + docView.getHeight()  + " mw = " + docView.getMeasuredWidth() + " mh = " + docView.getMeasuredHeight() + " x = " + docView.getX() + " y = " + docView.getY()+ " PivotX = "+ docView.getPivotX() + " PivotY = " + docView.getPivotY());
//
//                }
//            });
            animatorScall.addListener(new Animator.AnimatorListener() {
                @Override
                public void onAnimationStart(Animator animation) {

                }

                @Override
                public void onAnimationEnd(Animator animation) {
                    relView.setVisibility(View.GONE);
                }

                @Override
                public void onAnimationCancel(Animator animation) {

                }

                @Override
                public void onAnimationRepeat(Animator animation) {

                }
            });
//            animatorScall.start();
//            docView.getChildAt(0).setLayerType(View.LAYER_TYPE_SOFTWARE,new Paint());
            ScaleAnimation scaleAnimation = new ScaleAnimation((float) 1.0,(float)1.5,(float)1.0,(float)1.0);
            scaleAnimation.setAnimationListener(new Animation.AnimationListener() {
                @Override
                public void onAnimationStart(Animation animation) {

                }

                @Override
                public void onAnimationEnd(Animation animation) {
                    relView.setVisibility(View.GONE);
                }

                @Override
                public void onAnimationRepeat(Animation animation) {

                }
            });
            scaleAnimation.setDuration(3000);
            docView.startAnimation(scaleAnimation);
            v.setSelected(true);
        }
    }

    @Override
    public void onBackPressed() {
        super.onBackPressed();
        baseLive.leave();
    }
}
