package com.gensee.rtdemo;

import android.os.Bundle;
import android.util.DisplayMetrics;
import android.view.WindowManager;
import android.widget.FrameLayout;
import android.widget.LinearLayout;

import com.gensee.avs.OnNeedCallback;
import com.gensee.avs.VideoViewStatus;
import com.gensee.callback.IVideoCallBack;
import com.gensee.common.RTSharedPref;
import com.gensee.demo.DemoConfig;
import com.gensee.demo.R;
import com.gensee.live.GSBaseLive;
import com.gensee.media.IVideoIndication;
import com.gensee.routine.UserInfo;
import com.gensee.utils.GenseeLog;
import com.gensee.view.GSAudoDecodeViewEx;
import com.gensee.view.GSVideoViewEx;
import com.gensee.view.beauty.GSLocalVideoView;

import java.util.ArrayList;
import java.util.List;

public class AVsTestActivity extends BaseActivity implements IVideoCallBack, OnNeedCallback {
    private static final String TAG = "AVsTestActivity";
    private static final int total = 16;
    private static final int lineCount = 4;
    private   int width = 320;
    private   int height = 240;
    GSBaseLive baseLive;
    private FrameLayout lyVideoViews;

    private List<VideoViewStatus> videos = new ArrayList<>();
    GSLocalVideoView gsLocalVideoView;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_avs_test);
        getWindow().addFlags(WindowManager.LayoutParams.FLAG_KEEP_SCREEN_ON);
        PrefUtil.initPref(this);
        RTSharedPref.initPref(this);
        baseLive = new GSBaseLive();
        baseLive.setOnNeedCallback(this);
        baseLive.joinLive(DemoConfig.getIns().getInitParam(),this,this);
        baseLive.getRtSdk().setVideoCallBack(this);
        baseLive.getRtSdk().setAudioCallback(baseLive);

        initAVViews();
        gsLocalVideoView = (GSLocalVideoView) findViewById(R.id.localVideoView);
        baseLive.getRtSdk().setLocalVideoView(gsLocalVideoView);

        int a = PrefUtil.getIns().getInt(PrefUtil.VIDEO_RESOLUTION);
        int width = 320;
        int height = 240;
        if(a == 1)
        {
            width = 640;
            height = 480;
        }
        RTSharedPref.getIns().putInt(RTSharedPref.KEY_VIDEO_W, width);
        RTSharedPref.getIns().putInt(RTSharedPref.KEY_VIDEO_H, height);
    }

    private void initAVViews(){
        lyVideoViews = (FrameLayout)findViewById(R.id.videoViews);
        DisplayMetrics displayMetrics = new DisplayMetrics();
        getWindowManager().getDefaultDisplay().getMetrics(displayMetrics);
        width = displayMetrics.widthPixels / 4;
        height = 3 * width / 4;

        for(int i = 0; i < total; i++)
        {
            videos.add(initVideoView(i));
        }
    }

    private VideoViewStatus initVideoView(int i)
    {
        int row = i / lineCount;
        int index = i % lineCount;
        FrameLayout.LayoutParams lp = new FrameLayout.LayoutParams(width, height);
        lp.leftMargin = index * width;
        lp.topMargin = row * height;
        boolean isHardDecodeView = PrefUtil.getIns().getBoolean(PrefUtil.PUB_VIDEO_DECODE_TYPE);
        if(isHardDecodeView)
        {
            GSAudoDecodeViewEx viewEx = new GSAudoDecodeViewEx(this);
            lyVideoViews.addView(viewEx,lp);
            return new VideoViewStatus(viewEx, 0);
        }
        else
        {

            GenseeLog.i(TAG, "initVideoView i = " + i + " leftMargin = " + lp.leftMargin + " topMargin = " + lp.topMargin);
            GSVideoViewEx videoViewEx = new GSVideoViewEx(this);

            lyVideoViews.addView(videoViewEx,lp);
            return new VideoViewStatus(videoViewEx, 0);
        }
    }

    private void binVideoViewByUserId(long userid)
    {
        GenseeLog.i(TAG, "binVideoViewByUserId userid = " + userid);
        for(VideoViewStatus viewStatus : videos)
        {
            if(viewStatus.getUserId() <= 0)
            {
                viewStatus.setUserId(userid);
                GenseeLog.i(TAG, "binVideoViewByUserId userid = " + userid + " viewStatus = " + viewStatus);
                break;
            }
        }
    }

    private void unBindVideoViewByUserId(long userid)
    {
        GenseeLog.i(TAG, "unBindVideoViewByUserId userid = " + userid);
        for(VideoViewStatus viewStatus : videos)
        {
            if(viewStatus.getUserId() == userid)
            {
                GenseeLog.i(TAG, "unBindVideoViewByUserId userid = " + userid + " viewStatus = " + viewStatus);
                viewStatus.setUserId(0);
                break;
            }
        }
    }

    private IVideoIndication getBindVideoView(long userId)
    {
        for(VideoViewStatus viewStatus : videos)
        {
            if(viewStatus.getUserId() == userId)
            {
                GenseeLog.i(TAG, "getBindVideoView userid = " + userId + " viewStatus = " + viewStatus);

                return viewStatus.getiVideoIndication();
            }
        }
        return null;
    }

    @Override
    public void onVideoJoinConfirm(boolean b) {

    }

    @Override
    public void onVideoCameraAvailiable(boolean b) {

    }

    @Override
    public void onVideoCameraOpened() {

    }

    @Override
    public void onVideoCameraClosed() {

    }

    @Override
    public void onVideoJoin(UserInfo userInfo) {
        baseLive.displayVideo(userInfo.getId());
        binVideoViewByUserId(userInfo.getId());

    }

    @Override
    public void onVideoLeave(long userId) {
        baseLive.unDisplayVideo(userId);
        unBindVideoViewByUserId(userId);
    }

    @Override
    public void onVideoActived(UserInfo userInfo, boolean b) {

    }

    @Override
    public void onVideoDisplay(UserInfo userInfo) {

    }

    @Override
    public void onVideoUndisplay(long l) {

    }

    @Override
    public void onVideoDataRender(long userId, int width, int height, int frameFormat, float displayRatio, byte[] data) {
        IVideoIndication videoIndication = getBindVideoView(userId);
        if(null != videoIndication)
        {
            videoIndication.onReceiveFrame(data, width, height);
        }
    }


    @Override
    protected void onDestroy() {
        super.onDestroy();
        baseLive.leave();
    }

    @Override
    public void onRoomJoinSuccess() {
        baseLive.getRtSdk().setHardwareDecode(PrefUtil.getIns().getBoolean(PrefUtil.PUB_VIDEO_DECODE_TYPE));
    }


}
