package com.gensee.live;

import android.content.Context;
import android.support.annotation.NonNull;

import com.gensee.avs.OnNeedCallback;
import com.gensee.callback.IAudioCallBack;
import com.gensee.callback.IDocCallBack;
import com.gensee.callback.IRoomCallBack;
import com.gensee.common.ServiceType;
import com.gensee.entity.InitParam;
import com.gensee.entity.LiveInfo;
import com.gensee.net.RtComp;
import com.gensee.net.RtComp.Callback;
import com.gensee.room.RtSdk;
import com.gensee.routine.GSCountDownInfo;
import com.gensee.routine.GSResponderInfo;
import com.gensee.routine.LayoutInfo;
import com.gensee.routine.State;
import com.gensee.routine.UserInfo;
import com.gensee.taskret.OnTaskRet;
import com.gensee.utils.GenseeLog;
import com.gensee.view.GSDocViewGx;

import java.util.Map;

/**
 * 直播基础实现，基础包含参数初始化回调
 * 直播间回调、音频回调，其他的根据需要添加并实现之
 */
public class GSBaseLive implements Callback, IRoomCallBack, IAudioCallBack {
    private Context context;
    private RtSdk mRtSdk;
    private RtComp rtComp;
    private int mState;
    private IUINotify mUiNotify;
    private UserInfo self;
    private OnNeedCallback onNeedCallback;

    public void setOnNeedCallback(OnNeedCallback onNeedCallback)
    {
        this.onNeedCallback = onNeedCallback;
    }

    public GSBaseLive() {
        mRtSdk = new RtSdk();
    }


    /*********************Callback***********************/
    @Override
    public void onErr(int errCode) {
        String msg = "onErr " + errCode;
        //TODO 请根据文档上的错误码描述，对应构造出合适的错误提示
        switch (errCode) {
            case ERR_PARAM:
                break;
            default:
                break;

        }
        mUiNotify.toastMsg(msg);

    }

    @Override
    public void onInited(String joinParam) {
        mRtSdk.initWithParam("", joinParam, this);

    }

    /*********************IRoomCallBack***********************/

    @Override
    public void OnUpgradeNotify(String arg0) {
        // TODO Auto-generated method stub
    }

    @Override
    public ServiceType getServiceType() {
        // TODO Auto-generated method stub
        return null;
    }

    @Override
    public void onChatMode(int arg0) {
        // TODO Auto-generated method stub

    }

    @Override
    public void onFreeMode(boolean arg0) {
        // TODO Auto-generated method stub

    }

    @Override
    public Context onGetContext() {
        //一定要返回有效的context，否则加入不成功
        if (context == null) {
            GenseeLog.e("你的代码中 onGetContext 中需要返回有效的context 才能加入直播 ");
        }
        return context;
    }

    @Override
    public void onInit(boolean isOK) {
        if (isOK) {
            mRtSdk.join(null);
        } else {
            mUiNotify.toastMsg("onInit 初始化失败");
        }
    }

    @Override
    public void onJoin(boolean arg0) {
        // TODO Auto-generated method stub

    }

    @Override
    public void onLottery(byte arg0, String arg1) {
        // TODO Auto-generated method stub

    }

    @Override
    public void onNetworkBandwidth(int arg0, int arg1) {
        // TODO Auto-generated method stub

    }

    @Override
    public void onNetworkReport(byte arg0) {
        // TODO Auto-generated method stub

    }

    @Override
    public void onRoomBroadcastMsg(String arg0) {
        // TODO Auto-generated method stub

    }

    @Override
    public void onRoomData(String arg0, long arg1) {
        // TODO Auto-generated method stub

    }

    @Override
    public void onRoomHanddown(long arg0) {
        // TODO Auto-generated method stub

    }

    @Override
    public void onRoomHandup(long arg0, String arg1) {
        // TODO Auto-generated method stub

    }

    @Override
    public void onRoomJoin(int result, UserInfo self, boolean isFailover) {
        String joinMsg;
        if(result == JR_OK){
            joinMsg = "加入成功";
            this.self = self;
            if(null != onNeedCallback)
            {
                onNeedCallback.onRoomJoinSuccess();
            }
        }else{
            joinMsg = "加入失败 " + result;
            //TODO 请根据文档描述 做合适的加入失败提示
            switch (result){
                case JR_ERROR_CODEC:
                    joinMsg = "音频编码不匹配";
                    break;
            }

            //TODO 释放
            mRtSdk.release(null);
        }
        mUiNotify.toastMsg(joinMsg);
    }

    @Override
    public void onRoomLeave(int leaveReason) {
        mRtSdk.release(null);
        //TODO 请根据文档列出的退出原因进行合适的退出提示
        switch (leaveReason){
            case LR_CLOSED:
                break;
        }


        mUiNotify.toastMsg("已退出直播间 " + leaveReason);

    }

    @Override
    public void onRoomLock(boolean arg0) {
        // TODO Auto-generated method stub

    }

    @Override
    public void onRoomPhoneCallingStatus(String arg0, int arg1, int arg2) {
        // TODO Auto-generated method stub

    }

    @Override
    public void onRoomPhoneServiceStatus(boolean arg0) {
        // TODO Auto-generated method stub

    }

    @Override
    public void onRoomPublish(State arg0) {
        // TODO Auto-generated method stub

    }

    @Override
    public void onRoomReconnecting() {
        // TODO Auto-generated method stub

    }

    @Override
    public void onRoomRecord(State arg0) {
        // TODO Auto-generated method stub

    }

    @Override
    public void onRoomRollcall(int arg0) {
        // TODO Auto-generated method stub

    }

    @Override
    public void onRoomRollcallAck(long arg0) {
        // TODO Auto-generated method stub

    }

    @Override
    public void onRoomUserJoin(UserInfo arg0) {
        // TODO Auto-generated method stub

    }

    @Override
    public void onRoomUserLeave(UserInfo arg0) {
        // TODO Auto-generated method stub

    }

    @Override
    public void onRoomUserUpdate(UserInfo arg0) {
        // TODO Auto-generated method stub

    }

    @Override
    public String onSettingQuery(String arg0) {
        // TODO Auto-generated method stub
        return null;
    }

    @Override
    public int onSettingQuery(String arg0, int arg1) {
        // TODO Auto-generated method stub
        return 0;
    }

    @Override
    public void onSettingSet(String arg0, int arg1) {
        // TODO Auto-generated method stub

    }

    @Override
    public void onSettingSet(String arg0, String arg1) {
        // TODO Auto-generated method stub

    }

    @Override
    public void onLiveInfo(LiveInfo liveInfo) {

    }

    @Override
    public void onRoomWebLayoutChange(int i) {

    }

    /****************************IAudioCallBack**************************/
    @Override
    public void onAudioJoinConfirm(boolean arg0) {
        // TODO Auto-generated method stub

    }

    @Override
    public void onAudioLevel(int arg0, long arg1) {
        // TODO Auto-generated method stub

    }

    @Override
    public void onAudioMicAvailable(boolean arg0) {
        // TODO Auto-generated method stub

    }

    @Override
    public void onAudioMicClosed() {
        // TODO Auto-generated method stub

    }

    @Override
    public void onAudioMicOpened() {
        // TODO Auto-generated method stub

    }

    @Override
    public void onAudioSpeakerClosed() {
        // TODO Auto-generated method stub

    }

    @Override
    public void onAudioSpeakerOpened() {
        // TODO Auto-generated method stub

    }

    /****************************IAudioCallBack**************************/

    /**
     * 界面调用该函数进行加入，请注意这里并非sdk的接口，请分清楚sdk接口和demo的代码界限，
     * 请勿直接copy demo的代码而连接口都没有弄清楚
     *
     * @param initParam 加入参数
     * @param context   app Context
     * @param uiNotify  提示消息接收
     */

    public void joinLive(@NonNull InitParam initParam, Context context, @NonNull IUINotify uiNotify) {
        if (context == null || initParam == null) {
            return;
        }
        mUiNotify = uiNotify;
        this.context = context;
        if (rtComp != null) {
            rtComp.setCallback(null);
        }
        rtComp = new RtComp(context, this);
        rtComp.initWithGensee(initParam);
    }

    public void setDocView(GSDocViewGx docView) {
        mRtSdk.setGSDocViewGx(docView);
    }

    public void setDocCallBack(IDocCallBack docCallBack)
    {
        mRtSdk.setDocCallback(docCallBack);
    }

    public void leave(){
        mRtSdk.leave(false,null);
    }

    public RtSdk getRtSdk(){
        return mRtSdk;
    }

    public boolean displayVideo(long userId) {
        if(null != self && self.getId() == userId)
        {
            return false;
        }
        return mRtSdk.displayVideo(userId,null);
    }


    public boolean unDisplayVideo(long userId) {
        if (mRtSdk != null) {
            return mRtSdk.unDisplayVideo(userId, new OnTaskRet() {

                @Override
                public void onTaskRet(boolean ret, int id, String desc) {

                }
            });
        }
        return false;
    }

    @Override
    public void onLessonTimerStart(long l) {

    }

    @Override
    public void onLessonTimerPaused(boolean b) {

    }

    @Override
    public void onRoomClassAlarm(int i) {

    }

    @Override
    public void onRoomBroadcastCmd(Map map) {

    }

    @Override
    public void onLayoutSync(LayoutInfo layoutInfo) {

    }

    @Override
    public void onRoomData(String s, String s1) {

    }

    @Override
    public void onRandomSelect(byte b, String s) {

    }

    @Override
    public void onRoomCountDown(GSCountDownInfo gsCountDownInfo) {

    }

    @Override
    public void onRoomPresentorChanged(long l) {

    }

    @Override
    public void onRoomResponsderInfo(GSResponderInfo gsResponderInfo) {

    }

    @Override
    public void onRoomNavigate(String s) {

    }

    @Override
    public void onRoomClassReuninCmd() {
        //切到主课堂
        getRtSdk().switchRoomToMainClass();
    }

    @Override
    public void onRoomClassSeparateCmd() {
        //切到主课堂
        getRtSdk().switchRoomToSubClass();
    }

    @Override
    public void onRoomSubClassUserNum(int i) {

    }

    @Override
    public void onRoomDBTDataPrepared() {

    }
}
