package com.gensee.demo;

import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.FragmentManager;
import android.support.v4.app.FragmentStatePagerAdapter;
import android.support.v4.view.ViewPager;
import android.os.Bundle;
import android.view.View;
import android.widget.TextView;

import com.gensee.common.GenseeConfig;
import com.gensee.common.ServiceType;
import com.gensee.entity.InitParam;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class WaterfallActivity extends FragmentActivity {

    private List<Fragment> fragments = new ArrayList<>();

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_waterfall);
        // 实际使用过程中，整个app内活跃的VodPlayer对象不要超过GenseeConfig.vodCacheCount的值
        // 建议最大实例数不超过10，最好为3～4
        int preloadNum = getIntent().getIntExtra("preloadNum", 3);
        ViewPager viewPager = findViewById(R.id.viewPager);
        Adatper adatper = new Adatper(getSupportFragmentManager());
        viewPager.setOffscreenPageLimit(preloadNum);

        ArrayList<InitParam> paramsList = (ArrayList<InitParam>) getIntent().getSerializableExtra("paramsList");

        for (InitParam initParam : paramsList) {
            fragments.add(new PageFragment(initParam));
        }


        viewPager.setAdapter(adatper);
        TextView listSize = findViewById(R.id.vod_list_size);
        listSize.setText("当前列表总数：" + paramsList.size());
        TextView tvCurrentIndex = findViewById(R.id.current_index);

        viewPager.addOnPageChangeListener(new ViewPager.OnPageChangeListener() {
            @Override
            public void onPageScrolled(int i, float v, int i1) {

            }

            @Override
            public void onPageSelected(int i) {
                tvCurrentIndex.setText("当前为第"+(i + 1)+"个");
            }

            @Override
            public void onPageScrollStateChanged(int i) {

            }
        });
    }


    class Adatper extends FragmentStatePagerAdapter {

        public Adatper(FragmentManager fm) {
            super(fm);
        }

        @Override
        public Fragment getItem(int i) {
            return fragments.get(i);
        }

        @Override
        public int getCount() {
            return fragments.size();
        }
    }



}
