package com.gensee.demo;

import android.Manifest;
import android.content.Intent;
import android.content.SharedPreferences;
import android.content.pm.PackageManager;
import android.os.Build;
import android.os.Bundle;
import android.view.View;
import android.widget.AdapterView;
import android.widget.AdapterView.OnItemSelectedListener;
import android.widget.ArrayAdapter;
import android.widget.Button;
import android.widget.EditText;
import android.widget.Spinner;
import android.widget.Toast;

import com.gensee.common.ServiceType;
import com.gensee.entity.InitParam;
import com.gensee.rtdemo.GuideActivity;
import com.gensee.voddemo.VodActivity;
import com.tencent.bugly.crashreport.CrashReport;
//import com.tencent.bugly.crashreport.CrashReport;

import java.util.ArrayList;
import java.util.List;

public class ParamActivity extends BaseActivity implements OnItemSelectedListener {
	private static final String TAG = "ParamActivity";
	private static final int PERMISSION_RESULT_CODE= 10000;
	private final static String MEDIA_LIVE = "live";
	private final static String MEDIA_VOD = "vod";
	private SharedPreferences preferences;
	private ServiceType serviceType = ServiceType.WEBCAST;
	
	private EditText editDomain, editNum, editAccount, editLoginPwd,
			editNickName, editJoinPwd, editThirdK, edtGroupCode;

	private Spinner spinnerService;//webcast or training
	private Spinner spinnerMedia;//点播 or 直播
	private InitParam mInitParam;//初始化参数bean
	
	private Button btnGo;


	@Override
	protected void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		setContentView(R.layout.activity_param_input);
		CrashReport.initCrashReport(this,"3c3de5bba8",true);
		preferences = getPreferences(MODE_PRIVATE);
		
		editDomain = (EditText) findViewById(R.id.editDomain);
		editNum = (EditText) findViewById(R.id.editNum);
		editAccount = (EditText) findViewById(R.id.editAccount);
		editLoginPwd = (EditText) findViewById(R.id.editLoginPwd);
		editNickName = (EditText) findViewById(R.id.editNickName);
		editJoinPwd = (EditText) findViewById(R.id.editJoinPwd);
		editThirdK = (EditText) findViewById(R.id.editK);
		edtGroupCode = findViewById(R.id.editGroupCode);
	
		
		//Webcast,Training
		String[] services = new String[] {
				ServiceType.WEBCAST.getValue(),
				ServiceType.TRAINING.getValue()
				};
		spinnerService = (Spinner) findViewById(R.id.spinnerService);
		spinnerService.setAdapter(new ArrayAdapter<String>(this, android.R.layout.simple_spinner_item, services));
		spinnerService.setSelection(0);
		spinnerService.setOnItemSelectedListener(this);
		
		String [] medias = new String[] {"直播(Live)","点播(Vod)"};
		spinnerMedia = (Spinner) findViewById(R.id.spinnerMedia);
		spinnerMedia.setAdapter(new ArrayAdapter<String>(this, android.R.layout.simple_spinner_item, medias));
//		spinnerMedia.setPrompt(medias[0]);
		spinnerMedia.setSelection(0);
		spinnerMedia.setOnItemSelectedListener(this);
		
		btnGo = (Button) findViewById(R.id.btnGo);
		btnGo.setOnClickListener(new View.OnClickListener() {
			
			@Override
			public void onClick(View v) {
				boolean valid = initParam();
				if (valid) {
					Intent i = new Intent();
					if (spinnerMedia.getSelectedItemPosition() == 1) {
						i.setClass(ParamActivity.this, VodActivity.class);
					} else {
						i.setClass(ParamActivity.this, GuideActivity.class);
					}
					DemoConfig.getIns().setInitParam(mInitParam);
					startActivity(i);
				}
			}
		});
		permission();

		findViewById(R.id.muti_vod).setOnClickListener(new View.OnClickListener() {
			@Override
			public void onClick(View v) {
				Intent i = new Intent();
				i.setClass(ParamActivity.this, MutiVodParamActivity.class);
				startActivity(i);
			}
		});
	}
	
	/**
	 * SDK 的参数构造，实际工程中会用到，参数的来源应该是其他途径，而不是输入
	 * @return
	 */
	private boolean initParam(){
		String domain = editDomain.getText().toString().trim();
		String number = editNum.getText().toString().trim();
		String account = editAccount.getText().toString().trim();
		String loginPwd = editLoginPwd.getText().toString().trim();
		String nickName = editNickName.getText().toString().trim();
		String joinPwd= editJoinPwd.getText().toString().trim();
		String k = editThirdK.getText().toString().trim();
		String groupCode = edtGroupCode.getText().toString().trim();
		
		if ("".equals(domain)) {
			toast("域名不能为空");
			return false;
		}
		if("".equals(number)){
			toast("编号不能为空");
			return false;
		}
		if("".equals(nickName)){
			toast("昵称不能为空");
			return false;
		}
		mInitParam = new InitParam();
		//站点域名 如：demo.gensee.com 必需
		mInitParam.setDomain(domain);
		//编号或id必需至少要有一个
		if (number.length() == 8) {//方便测试，不要模仿，实际代码选择一个分支即可
			// 直播或点播编号
			mInitParam.setNumber(number);
		} else {
			//直播id或点播id
			String liveId = number;
			mInitParam.setLiveId(liveId);
		}
		//站点登录帐号，后台勾选需要登录的话一定传入正确的帐号
		mInitParam.setLoginAccount(account);
		//站点登录密码，后台勾选需要登录的话一定传入正确的密码
		mInitParam.setLoginPwd(loginPwd);
		//昵称，必需
		mInitParam.setNickName(nickName);
		//如果后台设置了密码(口令)，必须传入正确的密码
		mInitParam.setJoinPwd(joinPwd);
		//如果后台启用了第三方认证，必须传入正确的K值
		mInitParam.setK(k);
		//必须选择一种 serviceType 
		// 站点类型ServiceType.ST_CASTLINE 直播webcast，
		// ServiceType.ST_TRAINING 培训 training
		mInitParam.setServiceType(serviceType);
		mInitParam.setGroupCode(groupCode);
		//设置第三方的用户id  > 1000000000 (10亿)有效
//		mInitParam.setUserId(userId);
		//对点播有效，如果是下载则填入true，如果是在线播放填入false
//		mInitParam.setDownload(true);

		//mInitParam.setUserData("电话=123&公司=展视互动");
		
		//demo 使用
		String mediaType = "live";
		if (spinnerMedia.getSelectedItemPosition() == 1) {
			mediaType = "vod";
		}
		preferences.edit()
		.putString("domain" + mediaType, domain)
		.putString("number" + mediaType , number)
		.putString("account" + mediaType , account)
		.putString("accPwd" + mediaType , loginPwd)
		.putString("nickname" + mediaType , nickName)
		.putString("joinPwd" + mediaType , joinPwd)
		.putString("groupCode" + mediaType , groupCode)
		.putInt("serviceIndex" + mediaType , spinnerService.getSelectedItemPosition())
		.commit();
		
		return true;
		
	}
	
	
	private void bindData(String mediaType){
		String domain = preferences.getString("domain" + mediaType, "");
		String number = preferences.getString("number" + mediaType, "");
		String account = preferences.getString("account" + mediaType, "");
		String accPwd = preferences.getString("accPwd" + mediaType, "");
		String nickName = preferences.getString("nickname" + mediaType, "");
		String joinPwd = preferences.getString("joinPwd" + mediaType, "");
		String groupCode = preferences.getString("groupCode" + mediaType, "");
		int serviceIndex = preferences.getInt("serviceIndex"+mediaType, 0);
		editDomain.setText(domain);
		editNum.setText(number);
		editAccount.setText(account);
		editLoginPwd.setText(accPwd);
		editNickName.setText(nickName);
		editJoinPwd.setText(joinPwd);
		spinnerService.setSelection(serviceIndex);
		edtGroupCode.setText(groupCode);
	}
	
	@Override
	public void onItemSelected(AdapterView<?> parent, View view,
			int position, long id) {
		switch (parent.getId()) {
		case R.id.spinnerService:
			serviceType = position == 0 ? ServiceType.WEBCAST
					: ServiceType.TRAINING;
			break;
		case R.id.spinnerMedia:
			bindData(position == 0 ? MEDIA_LIVE : MEDIA_VOD);
			break;
		default:
			break;
		}
	}

	@Override
	public void onNothingSelected(AdapterView<?> parent) {

	}
	
	public void toast(final String msg){
		runOnUiThread(new Runnable() {
			
			@Override
			public void run() {
				Toast.makeText(getApplicationContext(), msg, Toast.LENGTH_SHORT).show();
			}
		});
	}

	private void permission() {
		if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.M) {
			List<String> permissions = new ArrayList<>();
			if (checkSelfPermission(Manifest.permission.RECORD_AUDIO) != PackageManager.PERMISSION_GRANTED) {
				permissions.add(Manifest.permission.RECORD_AUDIO);
			}
			if (checkSelfPermission(Manifest.permission.CAMERA) != PackageManager.PERMISSION_GRANTED) {
				permissions.add(Manifest.permission.CAMERA);
			}
			if (checkSelfPermission(Manifest.permission.WRITE_EXTERNAL_STORAGE) != PackageManager.PERMISSION_GRANTED) {
				permissions.add(Manifest.permission.WRITE_EXTERNAL_STORAGE);
			}
			//下面两个为手写板的蓝牙权限
			if (checkSelfPermission(Manifest.permission.ACCESS_COARSE_LOCATION) != PackageManager.PERMISSION_GRANTED) {
				permissions.add(Manifest.permission.ACCESS_COARSE_LOCATION);
			}if (checkSelfPermission(Manifest.permission.ACCESS_FINE_LOCATION) != PackageManager.PERMISSION_GRANTED) {
				permissions.add(Manifest.permission.ACCESS_FINE_LOCATION);
			}
			if (checkSelfPermission(Manifest.permission.MODIFY_AUDIO_SETTINGS) != PackageManager.PERMISSION_GRANTED) {
				permissions.add(Manifest.permission.MODIFY_AUDIO_SETTINGS);
			}
			int size = permissions.size();
			if (size > 0) {
				String[] ps = new String[size];
				permissions.toArray(ps);
				requestPermissions(ps, PERMISSION_RESULT_CODE);
			}
		}
	}
}
