package com.gensee.multi_instance.utils

import android.content.Context
import android.content.SharedPreferences
import com.gensee.multi_instance.ui.DemoInitParam
import com.google.gson.Gson
import com.google.gson.reflect.TypeToken
import java.lang.reflect.Type

object SharedPreferencesHelper {

    private const val PREF_NAME = "my_preferences"
    private const val KEY_LIST = "my_list"



    fun saveJson(context: Context, jsonString: String) {
        val editor: SharedPreferences.Editor = context.getSharedPreferences(PREF_NAME, Context.MODE_PRIVATE).edit()
        editor.putString(KEY_LIST, jsonString)
        editor.apply()
    }

    fun getJson(context: Context): String? {
        val sharedPreferences: SharedPreferences = context.getSharedPreferences(PREF_NAME, Context.MODE_PRIVATE)
        val jsonString: String? = sharedPreferences.getString(KEY_LIST, null)
        return jsonString
    }
}
