package com.gensee.multi_instance.ui.view

import android.widget.ShareActionProvider.OnShareTargetSelectedListener
import androidx.compose.foundation.layout.Row
import androidx.compose.foundation.layout.Spacer
import androidx.compose.foundation.layout.padding
import androidx.compose.foundation.layout.size
import androidx.compose.foundation.layout.width
import androidx.compose.foundation.selection.selectableGroup
import androidx.compose.material3.RadioButton
import androidx.compose.material3.Text
import androidx.compose.runtime.Composable
import androidx.compose.runtime.mutableStateOf
import androidx.compose.runtime.remember
import androidx.compose.ui.Modifier
import androidx.compose.ui.unit.dp

/**
 *  author : guohaonan
 *  date : 2024/1/22 16:40
 *  description :
 */
@Composable
fun RadioButtonGroup(selectItem:List<String>,modifier: Modifier = Modifier,defaultItem:String?="",selectedListener: (String)->Unit) {
    val selected = remember { mutableStateOf(defaultItem) }


    Row(modifier = modifier.selectableGroup()) {
        selectItem.forEach {
            RadioButton(
                selected = it == selected.value,
                onClick = {
                    selected.value = it
                    selectedListener.invoke(it)
                },
                Modifier.size(20.dp)
            )
            Text(text = it, modifier = Modifier.padding(start = 4.dp))
            if (selectItem.indexOf(it) != selectItem.lastIndex) {
                Spacer(modifier = Modifier.width(10.dp))
            }
        }

    }
}