package com.gensee.multi_instance.ui.view

import androidx.compose.foundation.layout.Arrangement
import androidx.compose.foundation.layout.Box
import androidx.compose.foundation.layout.Column
import androidx.compose.foundation.layout.Row
import androidx.compose.foundation.layout.Spacer
import androidx.compose.foundation.layout.fillMaxSize
import androidx.compose.foundation.layout.fillMaxWidth
import androidx.compose.foundation.layout.height
import androidx.compose.foundation.layout.padding
import androidx.compose.foundation.layout.width
import androidx.compose.foundation.text.KeyboardOptions
import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.filled.Info
import androidx.compose.material.icons.filled.Warning
import androidx.compose.material3.AlertDialog
import androidx.compose.material3.Card
import androidx.compose.material3.ExperimentalMaterial3Api
import androidx.compose.material3.Icon
import androidx.compose.material3.MaterialTheme
import androidx.compose.material3.OutlinedTextField
import androidx.compose.material3.Switch
import androidx.compose.material3.Text
import androidx.compose.material3.TextButton
import androidx.compose.runtime.Composable
import androidx.compose.runtime.MutableState
import androidx.compose.runtime.mutableStateOf
import androidx.compose.runtime.remember
import androidx.compose.ui.Alignment
import androidx.compose.ui.Modifier
import androidx.compose.ui.draw.scale
import androidx.compose.ui.graphics.vector.ImageVector
import androidx.compose.ui.text.input.KeyboardType

import androidx.compose.ui.tooling.preview.Preview
import androidx.compose.ui.unit.dp
import androidx.compose.ui.window.Dialog
import com.gensee.common.ServiceType
import com.gensee.multi_instance.ui.DemoInitParam
import com.gensee.multi_instance.ui.LiveType

/**
 *  author : guohaonan
 *  date : 2024/1/22 15:43
 *  description :
 */

@Preview
@Composable
fun InputVideoInfoDialog(
    onDismissRequest: (() -> Unit)? = null,
    onConfirmation: ((DemoInitParam) -> Unit)? = null,
    onDelete: ((DemoInitParam) -> Unit)? = null,
    defaultParams:DemoInitParam? = null
) {
    val currentParam = defaultParams ?: DemoInitParam()

    val isDomainEmpty = remember { mutableStateOf(false) }
    val isNumberEmpty = remember { mutableStateOf(false) }
    val isNameEmpty = remember { mutableStateOf(false) }
    val isEnable = remember { mutableStateOf(defaultParams?.enable?:true) }
    val openAlertDialog = remember { mutableStateOf(false) }
    if (openAlertDialog.value) {
        AlertDialogExample(
            onDismissRequest = { openAlertDialog.value = false },
            onConfirmation = {
                openAlertDialog.value = false
                onDelete?.invoke(currentParam)
            },
            dialogTitle = "是否确定要删除？",
            dialogText = "删除后无法恢复！",
            icon = Icons.Default.Warning
        )
    }

    Dialog(onDismissRequest = {
        if (onDismissRequest != null) {
            onDismissRequest()
        }
    }) {
        val isBasePage = remember { mutableStateOf(true) }

        Card(
            modifier = Modifier
                .fillMaxWidth()
                .height(515.dp)
                .padding(16.dp),

        ) {

            Box(modifier = Modifier.fillMaxSize()){

                Column() {
                    Text(
                        text = "输入数据：",
                        modifier = Modifier.padding(start = 16.dp,top = 12.dp)
                    )
                    if (isBasePage.value) {
                        BaseModule(currentParam,isDomainEmpty,isNumberEmpty,isNameEmpty)
                    } else {
                        MoreModule(currentParam)
                    }
                }

                Row(
                    horizontalArrangement = Arrangement.SpaceAround,
                    modifier = Modifier
                        .fillMaxWidth()
                        .align(Alignment.BottomCenter),
                ) {
                    TextButton(
                        onClick = { isBasePage.value = !isBasePage.value },
                        modifier = Modifier
                    ) {
                        Text(if (isBasePage.value)"高级" else "基础")
                    }
//                    Spacer(modifier = Modifier.width(65.dp))
                    if (defaultParams != null) {
                        TextButton(
                            onClick = {
                                openAlertDialog.value = true
//
                                      },
                            modifier = Modifier
//                                .width(65.dp)
//                                .padding(8.dp)
                        ) {
                            Text("删除", color = MaterialTheme.colorScheme.error)
                        }
                    } else {
                        Spacer(modifier = Modifier.width(65.dp))
                    }
                    TextButton(
                        onClick = {
                            if (onDismissRequest != null) {
                                onDismissRequest()
                            }
                        },
                        modifier = Modifier
                    ) {
                        Text("关闭")
                    }
                    TextButton(
                        onClick = {
                            if (currentParam.domain.isNullOrBlank()) {
                                isDomainEmpty.value = true
                                isBasePage.value = true
                            }
                            if (currentParam.number.isNullOrBlank()) {
                                isNumberEmpty.value = true
                                isBasePage.value = true
                            }
                            if (currentParam.nickName.isNullOrBlank()) {
                                isNameEmpty.value = true
                                isBasePage.value = true
                            }
                            if (!isDomainEmpty.value && !isNumberEmpty.value && !isNameEmpty.value && onConfirmation != null) {
                                onConfirmation(currentParam)
                            }


                        },
                        modifier = Modifier
                    ) {
                        Text(if (defaultParams == null) "添加" else "更新")
                    }
                }
                if (defaultParams != null) {
                    Switch(checked = isEnable.value, onCheckedChange = {
                        isEnable.value = it
                        defaultParams.enable = it
                    },modifier = Modifier.scale(0.6f).align(Alignment.TopEnd))

                }

            }


        }
    }
}

private fun isParameterValid(currentParam: DemoInitParam): Boolean {
    if (currentParam.domain.isNullOrBlank()) {
        return false
    }
    if (currentParam.number.isNullOrBlank()) {
        return false
    }
    if (currentParam.nickName.isNullOrBlank()) {
        return false
    }
    return true
}

@Composable
private fun BaseModule(
    initParam: DemoInitParam,
    isDomainEmpty: MutableState<Boolean>,
    isNumberEmpty: MutableState<Boolean>,
    isNameEmpty: MutableState<Boolean>
) {
    val domain = remember { mutableStateOf(initParam.domain?:"") }
    val number = remember { mutableStateOf(initParam.number?:"") }
    val userName = remember { mutableStateOf(initParam.nickName?:"") }
    val password = remember { mutableStateOf(initParam.joinPwd?:"") }
    if (initParam.serviceType == null) {
        initParam.serviceType = ServiceType.WEBCAST
    }

    RadioButtonGroup(modifier = Modifier.padding(start = 16.dp,top = 14.dp),
        selectItem = arrayListOf("直播","点播"),
        defaultItem = if (initParam.liveType == LiveType.LIVE)"直播" else "点播"){
        when(it){
            "直播" -> initParam.liveType = LiveType.LIVE
            "点播" -> initParam.liveType = LiveType.VOD
        }
    }

    RadioButtonGroup(modifier = Modifier.padding(start = 16.dp,top = 16.dp),
        selectItem = arrayListOf("Webcast","Training"),
        defaultItem = if (initParam.serviceType == ServiceType.WEBCAST) "Webcast" else "Training"){
        when(it){
            "Webcast" -> initParam.serviceType = ServiceType.WEBCAST
            "Training" -> initParam.serviceType = ServiceType.TRAINING
        }
    }

    OutlinedTextField(
        modifier = Modifier.padding(start = 16.dp,top = 10.dp, end = 16.dp),
        value = domain.value,
        isError = isDomainEmpty.value,
        supportingText = {
            if (isDomainEmpty.value) {
                Text(
                    modifier = Modifier.fillMaxWidth(),
                    text = "域名不能为空",
                    color = MaterialTheme.colorScheme.error
                )
            }
        },
        onValueChange = {
            domain.value = it
            initParam.domain = it
            isDomainEmpty.value = false
        },
        maxLines = 1,
        label = { Text("域名") }
    )
    OutlinedTextField(
        modifier = Modifier.padding(start = 16.dp,top = 0.dp, end = 16.dp),
        isError = isNumberEmpty.value,
        supportingText = {
            if (isNumberEmpty.value) {
                Text(
                    modifier = Modifier.fillMaxWidth(),
                    text = "编号不能为空",
                    color = MaterialTheme.colorScheme.error
                )
            }
        },
        value = number.value,
        onValueChange = {
            number.value = it
            initParam.number = it
            isNumberEmpty.value = false
        },
        maxLines = 1,
        keyboardOptions = KeyboardOptions.Default.copy(
            keyboardType = KeyboardType.Number
        ),
        label = { Text("编号") }
    )
    OutlinedTextField(
        modifier = Modifier.padding(start = 16.dp,top = 0.dp, end = 16.dp),
        value = userName.value,
        isError = isNameEmpty.value,
        supportingText = {
            if (isNameEmpty.value) {
                Text(
                    modifier = Modifier.fillMaxWidth(),
                    text = "昵称不能为空",
                    color = MaterialTheme.colorScheme.error
                )
            }
        },
        onValueChange = {
            userName.value = it
            initParam.nickName = it
            isNameEmpty.value = false
        },
        maxLines = 1,
        label = { Text("用户名") }
    )
    OutlinedTextField(
        modifier = Modifier.padding(start = 16.dp,top = 0.dp, end = 16.dp),
        value = password.value,
        onValueChange = {
            password.value = it
            initParam.joinPwd = it
        },
        maxLines = 1,
        label = { Text("加入口令") }
    )
}

@Composable
private fun MoreModule(initParam: DemoInitParam) {

    val userId = remember { mutableStateOf(if (initParam.userId == -1L)"" else initParam.userId) }
    val loginAccount = remember { mutableStateOf(initParam.loginAccount?:"") }
    val loginPwd = remember { mutableStateOf(initParam.loginPwd?:"") }
    val k = remember { mutableStateOf(initParam.k?:"") }
    val groupCode = remember { mutableStateOf(initParam.groupCode?:"") }

    OutlinedTextField(
        modifier = Modifier.padding(start = 16.dp,top = 10.dp, end = 16.dp),
        value = userId.value.toString(),
        onValueChange = {
            userId.value = it.toLong()
            initParam.userId = it.toLong()
        },
        keyboardOptions = KeyboardOptions.Default.copy(
            keyboardType = KeyboardType.Number
        ),
        label = { Text("用户自定义id") }
    )
    OutlinedTextField(
        modifier = Modifier.padding(start = 16.dp,top = 10.dp, end = 16.dp),
        value = loginAccount.value,
        onValueChange = {
            loginAccount.value = it
            initParam.loginAccount = it
        },
        label = { Text("站点登陆账号") }
    )
    OutlinedTextField(
        modifier = Modifier.padding(start = 16.dp,top = 10.dp, end = 16.dp),
        value = loginPwd.value,
        onValueChange = {
            loginPwd.value = it
            initParam.loginPwd = it
        },
        label = { Text("站点登陆密码") }
    )
    OutlinedTextField(
        modifier = Modifier.padding(start = 16.dp,top = 10.dp, end = 16.dp),
        value = k.value,
        onValueChange = {
            k.value = it
            initParam.k = it
        },
        label = { Text("认证K值") }
    )
    OutlinedTextField(
        modifier = Modifier.padding(start = 16.dp,top = 10.dp, end = 16.dp),
        value = groupCode.value,
        onValueChange = {
            groupCode.value = it
            initParam.groupCode = it
        },
        label = { Text("分组号") }
    )
}

@OptIn(ExperimentalMaterial3Api::class)
@Composable
fun AlertDialogExample(
    onDismissRequest: () -> Unit,
    onConfirmation: () -> Unit,
    dialogTitle: String,
    dialogText: String,
    icon: ImageVector,
) {
    AlertDialog(
        icon = {
            Icon(icon, contentDescription = "Example Icon")
        },
        title = {
            Text(text = dialogTitle)
        },
        text = {
            Text(text = dialogText)
        },
        onDismissRequest = {
            onDismissRequest()
        },
        confirmButton = {
            TextButton(
                onClick = {
                    onConfirmation()
                }
            ) {
                Text("确定")
            }
        },
        dismissButton = {
            TextButton(
                onClick = {
                    onDismissRequest()
                }
            ) {
                Text("取消")
            }
        }
    )
}