package com.gensee.multi_instance.ui.page

import androidx.activity.compose.rememberLauncherForActivityResult
import androidx.activity.result.contract.ActivityResultContracts
import androidx.compose.foundation.Image
import androidx.compose.foundation.layout.Box
import androidx.compose.foundation.layout.fillMaxSize
import androidx.compose.foundation.layout.fillMaxWidth
import androidx.compose.foundation.layout.height
import androidx.compose.foundation.layout.offset
import androidx.compose.foundation.layout.padding
import androidx.compose.foundation.layout.size
import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.filled.Send
import androidx.compose.material3.Button
import androidx.compose.material3.ExperimentalMaterial3Api
import androidx.compose.material3.Icon
import androidx.compose.material3.IconButton
import androidx.compose.material3.MaterialTheme
import androidx.compose.material3.Scaffold
import androidx.compose.material3.SnackbarHost
import androidx.compose.material3.SnackbarHostState
import androidx.compose.material3.Text
import androidx.compose.material3.TopAppBar
import androidx.compose.material3.TopAppBarDefaults
import androidx.compose.runtime.Composable
import androidx.compose.runtime.mutableStateOf
import androidx.compose.runtime.remember
import androidx.compose.runtime.rememberCoroutineScope
import androidx.compose.ui.Alignment
import androidx.compose.ui.Modifier
import androidx.compose.ui.graphics.Color
import androidx.compose.ui.platform.LocalContext
import androidx.compose.ui.res.painterResource
import androidx.compose.ui.tooling.preview.Preview
import androidx.compose.ui.unit.dp
import androidx.lifecycle.viewmodel.compose.viewModel
import com.gensee.multi_instance.R
import com.gensee.multi_instance.ui.viewmodel.InitParamsViewModel
import com.gensee.multi_instance.utils.FileHelper
import kotlinx.coroutines.delay
import kotlinx.coroutines.launch

/**
 *  author : guohaonan
 *  date : 2024/1/18 15:14
 *  description :
 */

@OptIn(ExperimentalMaterial3Api::class)
@Composable
fun GuidePage(onClick: () -> Unit, viewModel: InitParamsViewModel = viewModel()) {

    val scope = rememberCoroutineScope()
    val snackbarHostState = remember { SnackbarHostState() }
    val context = LocalContext.current
    val canClick = remember { mutableStateOf(true) }

//    val result = remember { mutableStateOf<Uri?>(null) }
    val launcher = rememberLauncherForActivityResult(ActivityResultContracts.GetContent()) {
//        result.value = it
        it?.let {
            val json = FileHelper.readTextFromUri(context.contentResolver, it)
            val success = viewModel.restoreFromJson(json ?: "")
            val msg = if (success) "导入成功" else "导入失败"
            canClick.value = !success
            scope.launch {
                snackbarHostState.showSnackbar(msg)
                onClick.invoke()
                canClick.value = true
            }
        }

    }

    Scaffold(
        topBar = {
            TopAppBar(
                colors = TopAppBarDefaults.topAppBarColors(
                    containerColor = MaterialTheme.colorScheme.primary,
                    titleContentColor = Color.White,
                ),
                title = {
                    Text("首页")
                },
            )
        },
        snackbarHost = {
            SnackbarHost(hostState = snackbarHostState)
        },

        ) { innerPadding ->

        Box(
            modifier = Modifier
                .fillMaxSize()
                .padding(innerPadding)
        ) {

            Button(
                onClick = {
                    //通过系统的文件浏览器选择一个文件
                    launcher.launch("application/json")
                },
                enabled = canClick.value,
                modifier = Modifier
                    .fillMaxWidth()
                    .padding(horizontal = 15.dp)
                    .padding(top = 100.dp)
                    .align(Alignment.TopCenter)
                    .height(50.dp)
            ) {
                Text(text = "导入JSON文件数据")
            }

            Button(
                onClick = { onClick.invoke() },
                enabled = canClick.value,
                modifier = Modifier
                    .fillMaxWidth()
                    .padding(horizontal = 15.dp)
                    .padding(top = 25.dp)
                    .align(Alignment.TopCenter)
                    .height(50.dp)
            ) {
                Text(text = "手动添加数据")
            }
        }
    }
}
