package com.gensee.multi_instance.ui.page

import android.Manifest
import android.content.Context
import android.content.pm.PackageManager
import android.os.Environment
import android.util.Log
import android.widget.Toast
import androidx.activity.ComponentActivity
import androidx.activity.compose.BackHandler
import androidx.activity.compose.rememberLauncherForActivityResult
import androidx.activity.result.contract.ActivityResultContracts
import androidx.compose.foundation.layout.Box
import androidx.compose.foundation.layout.fillMaxSize
import androidx.compose.foundation.layout.height
import androidx.compose.foundation.layout.padding
import androidx.compose.foundation.layout.width
import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.filled.ArrowBack
import androidx.compose.material.icons.filled.ArrowForward
import androidx.compose.material.icons.filled.Send
import androidx.compose.material3.Button
import androidx.compose.material3.ExperimentalMaterial3Api
import androidx.compose.material3.Icon
import androidx.compose.material3.IconButton
import androidx.compose.material3.MaterialTheme
import androidx.compose.material3.Scaffold
import androidx.compose.material3.SnackbarHost
import androidx.compose.material3.SnackbarHostState
import androidx.compose.material3.Text
import androidx.compose.material3.TopAppBar
import androidx.compose.material3.TopAppBarDefaults
import androidx.compose.runtime.Composable
import androidx.compose.runtime.mutableStateOf
import androidx.compose.runtime.remember
import androidx.compose.runtime.rememberCoroutineScope
import androidx.compose.ui.Alignment
import androidx.compose.ui.Modifier
import androidx.compose.ui.graphics.Color
import androidx.compose.ui.platform.LocalContext
import androidx.compose.ui.unit.dp
import androidx.core.content.ContextCompat
import androidx.lifecycle.viewmodel.compose.viewModel
import com.gensee.multi_instance.ui.DemoInitParam
import com.gensee.multi_instance.ui.view.DragLazyVerticalGrid
import com.gensee.multi_instance.ui.view.InputVideoInfoDialog
import com.gensee.multi_instance.ui.viewmodel.InitParamsViewModel
import com.gensee.multi_instance.utils.FileHelper
import com.google.gson.Gson
import kotlinx.coroutines.launch

/**
 *  author : guohaonan
 *  date : 2024/1/18 15:21
 *  description :
 */
@OptIn(ExperimentalMaterial3Api::class)
@Composable
fun AddItemPage(
    last: (() -> Unit)? = null,
    next: (() -> Unit)? = null,
    initParamsViewModel: InitParamsViewModel = viewModel()
) {
    val context = LocalContext.current
    val openAlertDialog = remember { mutableStateOf(false) }

    var needModifyInitParam = remember { mutableStateOf<DemoInitParam?>(null) }

    val infoList = initParamsViewModel.videoInfoList

    val scope = rememberCoroutineScope()
    val snackbarHostState = remember { SnackbarHostState() }

    Scaffold(
        topBar = {
            TopAppBar(
                colors = TopAppBarDefaults.topAppBarColors(
                    containerColor = MaterialTheme.colorScheme.primary,
                    titleContentColor = Color.White,
                ),
                title = {
                    Text("数据列表")
                },
                actions = {
                    IconButton(onClick = {
                        next?.invoke()
                    }) {
                        Icon(
                            imageVector = Icons.Default.ArrowForward,
                            contentDescription = "Localized description",
                            tint = Color.White
                        )
                    }
                },
                navigationIcon = {
                    IconButton(onClick = {
                        last?.invoke()
                    }) {
                        Icon(
                            imageVector = Icons.Filled.ArrowBack,
                            contentDescription = "Localized description",
                            tint = Color.White
                        )
                    }
                },

                )
        },
        snackbarHost = {
            SnackbarHost(hostState = snackbarHostState)
        },

        ) { innerPadding ->
        DragLazyVerticalGrid(innerPadding = innerPadding, onItemClick = { isAddBtn, index ->
            if (isAddBtn) {
                openAlertDialog.value = true
            } else {
                needModifyInitParam.value = infoList.get(index)
                openAlertDialog.value = true
            }
        })


    }
    BackHandler {
        last?.invoke()
    }


    if (openAlertDialog.value) {
        InputVideoInfoDialog(onConfirmation = {
            openAlertDialog.value = false
            if (it == needModifyInitParam.value) {
                initParamsViewModel.updateItem(it)
            } else {
                initParamsViewModel.addItem(it)
            }
            initParamsViewModel.save(context)
            needModifyInitParam.value = null
        }, onDismissRequest = {
            openAlertDialog.value = false
            needModifyInitParam.value = null
        }, onDelete = {
            openAlertDialog.value = false
            initParamsViewModel.deleteItem(it)
            initParamsViewModel.save(context)
            needModifyInitParam.value = null
        },defaultParams = needModifyInitParam.value)


    }
}







