package com.gensee.multi_instance.demo.player.adapter;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.TextView;

import com.gensee.multi_instance.R;
import com.gensee.routine.UserInfo;

import java.util.ArrayList;
import java.util.List;

public class UserListAdapter extends BaseAdapter {
	public static final long PUBLIC_CHAT_TAG = -1000;
	private Context mContext;
	private TextView mTextView;
	private List<UserInfo> mList;
	private UserInfo publicUserInfo;

	public UserListAdapter(Context context) {

		this.mContext = context;
		mList = new ArrayList<UserInfo>();

		
		//构造公聊的UserInfo信息,
//	    publicUserInfo = new UserInfo(PUBLIC_CHAT_TAG, context.getResources().getString(R.string.public_chat), -1, -1);
//	    mList.add(publicUserInfo);
	}

	public void addInfo(UserInfo info) {

		int i = 0;
		for (i = 0; i < mList.size(); i++) {
			UserInfo user = mList.get(i);
			if (user.getUserId() == info.getUserId()) {
				user.update(info);
				notifyDataSetChanged();
				break;
			}
		}
		if (i >= mList.size()) {

			mList.add(info);
			notifyDataSetChanged();
		}

	}

	public void clear() {
		mList.clear();
		notifyDataSetChanged();
	}

	public void leaveInfo(UserInfo info) {

		mList.remove(info);
		notifyDataSetChanged();
	}

	@Override
	public int getCount() {
		if (mList == null)
			return 0;
		return mList.size();
	}

	@Override
	public Object getItem(int position) {

		return position < getCount()?mList.get(position):null;
	}

	@Override
	public long getItemId(int position) {

		return position;
	}

	@Override
	public View getView(int position, View convertView, ViewGroup parent) {

		if (convertView == null)
			convertView = LayoutInflater.from(mContext).inflate(
					R.layout.user_item, null);
		mTextView = (TextView) convertView
				.findViewById(R.id.text_useritem_nickname);
		mTextView.setText(mList.get(position).getName());
		return convertView;
	}

	public List<UserInfo> getmList() {
		return mList;
	}


	public void cleanUsers(){
		mList.clear();
		if (publicUserInfo != null) {
			mList.add(publicUserInfo);
		}
		notifyDataSetChanged();
	}

}
