package com.gensee.multi_instance.demo.player;

import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView.OnItemClickListener;
import android.widget.ListView;

import androidx.fragment.app.Fragment;

import com.gensee.multi_instance.demo.player.adapter.UserListAdapter;
import com.gensee.routine.UserInfo;

public class UsersFragment extends Fragment {

	
	private ListView mUsersListview;
	private OnItemClickListener clickListener;
	private UserListAdapter mUsersAdapter;
	public void setClickListener(OnItemClickListener clickListener) {
		this.clickListener = clickListener;
	}

	public UsersFragment() {
	}

	@Override
	public View onCreateView(LayoutInflater inflater,
			ViewGroup container, Bundle savedInstanceState) {
		if(mUsersListview == null){
			mUsersListview = new ListView(getActivity());
			mUsersListview.setOnItemClickListener(clickListener);
			mUsersAdapter = new UserListAdapter(getActivity().getApplicationContext());
			mUsersListview.setAdapter(mUsersAdapter);
		}
		return mUsersListview;
	}
	
	@Override
	public void onDestroy() {
		super.onDestroy();
		if (null != mUsersAdapter) {
			mUsersAdapter.clear();
		}
	}

	public void addInfo(UserInfo userInfo) {
		mUsersAdapter.addInfo(userInfo);
	}

	public void leaveInfo(UserInfo userInfo) {
		mUsersAdapter.leaveInfo(userInfo);
	}

	public void cleanUsers(){
		mUsersAdapter.cleanUsers();
	}
}
