package com.gensee.multi_instance.demo.player;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.CheckBox;
import android.widget.CompoundButton;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.fragment.app.Fragment;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;

import com.gensee.multi_instance.R;
import com.gensee.player.Player;
import com.gensee.routine.UserInfo;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@SuppressLint("ValidFragment")
public class NotifyFragment extends Fragment {

	private RecyclerView recyclerView;
	private TextAdapter textAdapter;
	private List<String> textList = new ArrayList<>();

	private boolean autoScroll = true;

	public NotifyFragment() {

	}

	@Override
	public void onCreate(Bundle savedInstanceState) {

		super.onCreate(savedInstanceState);
	}

	@Override
	public View onCreateView(LayoutInflater inflater, ViewGroup container,
			Bundle savedInstanceState) {

		View view = inflater.inflate(R.layout.imnotify, container,false);

		recyclerView = view.findViewById(R.id.recyclerView);
		recyclerView.setLayoutManager(new LinearLayoutManager(getContext()));

		textAdapter = new TextAdapter(textList);
		recyclerView.setAdapter(textAdapter);

		((CheckBox)view.findViewById(R.id.checkbox)).setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener() {
			@Override
			public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
				autoScroll = isChecked;
			}
		});

		return view;
	}

	public Player getPlayer() {
		return ((PlayerFragment)getParentFragment()).getPlayer();
	}

	SimpleDateFormat sdf = new SimpleDateFormat("HH:mm:ss");
	public void addText(String text) {

		String dateString = sdf.format(new Date());
		textList.add("["+dateString+"] "+text);
		if (getView() == null) {
			return;
		}
		getView().post(new Runnable() {
			@Override
			public void run() {
//				textAdapter.notifyItemInserted(textList.size() - 1); // 通知适配器刷新
				textAdapter.notifyDataSetChanged();
				if (autoScroll) {
					recyclerView.scrollToPosition(textList.size() - 1); // 滚动到新添加的项目
				}

			}
		});

	}


	public class TextAdapter extends RecyclerView.Adapter<TextAdapter.TextViewHolder> {

		private List<String> textList;

		public TextAdapter(List<String> textList) {
			this.textList = textList;
		}

		@NonNull
		@Override
		public TextViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
			View view = LayoutInflater.from(parent.getContext())
					.inflate(android.R.layout.simple_list_item_1, parent, false);
			return new TextViewHolder(view);
		}

		@Override
		public void onBindViewHolder(@NonNull TextViewHolder holder, int position) {
			holder.textView.setText(textList.get(position));
		}

		@Override
		public int getItemCount() {
			return textList.size();
		}

		public  class TextViewHolder extends RecyclerView.ViewHolder {
			TextView textView;

			public TextViewHolder(@NonNull View itemView) {
				super(itemView);
				textView = itemView.findViewById(android.R.id.text1);
			}
		}
	}

}
