package com.gensee.multi_instance

import androidx.appcompat.app.AppCompatActivity
import android.os.Bundle
import android.os.Parcelable
import android.util.Log
import android.widget.TextView
import androidx.fragment.app.Fragment
import androidx.fragment.app.FragmentActivity
import androidx.viewpager.widget.ViewPager
import androidx.viewpager2.adapter.FragmentStateAdapter
import androidx.viewpager2.widget.ViewPager2
import com.gensee.common.GenseeConfig
import com.gensee.entity.InitParam
import com.gensee.multi_instance.demo.player.PlayerFragment
import com.gensee.multi_instance.demo.vod.VodPageFragment
import com.gensee.multi_instance.ui.DemoInitParam
import com.gensee.multi_instance.ui.LiveType
import com.gensee.utils.GenseeLog
import java.util.ArrayList

class PageActivity : AppCompatActivity() {
    private val TAG = "PageActivity"
    private lateinit var mParamsList:ArrayList<DemoInitParam>
    private var pageNum:Int = 0

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        setContentView(R.layout.activity_page)
        mParamsList = intent.getSerializableExtra("list") as ArrayList<DemoInitParam>

        val viewPager2 = findViewById<ViewPager2>(R.id.viewpage2)
        viewPager2.orientation = ViewPager2.ORIENTATION_VERTICAL
        viewPager2.adapter = PagerAdapter(this,mParamsList)
        viewPager2.offscreenPageLimit = DemoConfig.preloadNum
    }

    public fun addPageNum() {
        pageNum++
        findViewById<TextView>(R.id.tv_page_number).setText("当前同时存在页面数："+pageNum)
        GenseeLog.i("Tag","当前同时存在页面数："+pageNum)
    }

    fun reducePageNum() {
        pageNum--
        findViewById<TextView>(R.id.tv_page_number).setText("当前同时存在页面数："+pageNum)
        GenseeLog.i("Tag","当前同时存在页面数："+pageNum)
    }
}

class PagerAdapter(private val context: FragmentActivity, private val params: List<DemoInitParam>) :
    FragmentStateAdapter(context) {

    override fun createFragment(position: Int): Fragment {
        val initParam = params.get(position)
        if (initParam.liveType == LiveType.LIVE) {
            return PlayerFragment.newInstance(initParam)
        } else {
            return VodPageFragment.newInstance(initParam)
        }
    }


    override fun getItemCount(): Int {
        return params.size
    }
}