/*
 * Decompiled with CFR 0.152.
 */
package cn.robotpen.utils.screen;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.os.Handler;
import android.os.Looper;
import android.support.annotation.ColorInt;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AbsListView;
import android.widget.ListAdapter;
import android.widget.ListView;
import cn.robotpen.utils.screen.FileUtil;
import cn.robotpen.utils.screen.LogUtils;
import java.util.ArrayList;
import java.util.List;

public class ViewToImageUtil {
    public static int mBackgroundColor = 0;

    public static void generateImage(ViewGroup viewGroup, OnImageSavedCallback mOnImageSavedCallback) {
        ViewToImageUtil.generateImage(viewGroup, 0, 0, mOnImageSavedCallback);
    }

    public static void generateImage(final ViewGroup viewGroup, int width, @ColorInt int backgroundColor, final OnImageSavedCallback mOnImageSavedCallback) {
        mBackgroundColor = backgroundColor;
        final Bitmap bitmap = ViewToImageUtil.generateBigBitmap(viewGroup, width);
        new Thread(new Runnable(){

            @Override
            public void run() {
                final String destPath = FileUtil.createImageFile(viewGroup.getContext()).getAbsolutePath();
                FileUtil.compressBitmapToFile(bitmap, destPath);
                new Handler(Looper.getMainLooper()).post(new Runnable(){

                    @Override
                    public void run() {
                        if (mOnImageSavedCallback != null) {
                            mOnImageSavedCallback.onFinishCallback(destPath);
                        }
                    }
                });
                bitmap.recycle();
                System.gc();
            }
        }).start();
    }

    public static Bitmap generateBigBitmap(ViewGroup viewGroup, int width) {
        if (width > 0) {
            viewGroup.measure(View.MeasureSpec.makeMeasureSpec((int)width, (int)0x40000000), View.MeasureSpec.makeMeasureSpec((int)0, (int)0));
        } else if (viewGroup.getWidth() <= 0) {
            viewGroup.measure(View.MeasureSpec.makeMeasureSpec((int)0, (int)0), View.MeasureSpec.makeMeasureSpec((int)0, (int)0));
        } else {
            width = viewGroup.getWidth();
        }
        width = width > 0 ? width : viewGroup.getMeasuredWidth();
        LogUtils.d(width + "");
        LogUtils.d(String.format("width=%s, measuredWidth=%s, height=%s, measuredHeight=%s", viewGroup.getWidth(), viewGroup.getMeasuredWidth(), viewGroup.getHeight(), viewGroup.getMeasuredHeight()));
        int height = 0;
        List<BitmapWithHeight> list = ViewToImageUtil.getWholeViewToBitmap(viewGroup, new ArrayList<BitmapWithHeight>());
        for (BitmapWithHeight item : list) {
            height += item.height;
        }
        return ViewToImageUtil.generateBigBitmap(list, width, height);
    }

    public static Bitmap generateBigBitmap(List<BitmapWithHeight> list, int width, int height) {
        Bitmap bigBitmap = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.RGB_565);
        Canvas bigCanvas = new Canvas(bigBitmap);
        bigCanvas.drawColor(mBackgroundColor);
        Paint paint = new Paint();
        int iHeight = 0;
        for (BitmapWithHeight item : list) {
            Bitmap bmp = item.bitmap;
            bigCanvas.drawBitmap(bmp, 0.0f, (float)iHeight, paint);
            iHeight += bmp.getHeight();
        }
        return bigBitmap;
    }

    public static BitmapWithHeight getWholeViewToBitmap(View view, int width) {
        return ViewToImageUtil.getSimpleViewToBitmap(view, width);
    }

    public static List<BitmapWithHeight> getWholeViewToBitmap(ViewGroup viewGroup, List<BitmapWithHeight> list) {
        int width = viewGroup.getMeasuredWidth();
        if (viewGroup instanceof ListView) {
            list.addAll(ViewToImageUtil.getWholeListViewItemsToBitmap((ListView)viewGroup));
        } else if (viewGroup instanceof RecyclerView) {
            list.add(ViewToImageUtil.getWholeViewToBitmap((View)viewGroup, width));
        } else if (viewGroup instanceof AbsListView) {
            list.add(ViewToImageUtil.getWholeViewToBitmap((View)viewGroup, width));
        } else {
            int count = viewGroup.getChildCount();
            for (int i = 0; i < count; ++i) {
                View child = viewGroup.getChildAt(i);
                if (ViewToImageUtil.isScrollableView(child)) {
                    ViewToImageUtil.getWholeViewToBitmap((ViewGroup)child, list);
                    continue;
                }
                list.add(ViewToImageUtil.getWholeViewToBitmap(child, width));
            }
        }
        return list;
    }

    private static boolean isScrollableView(View viewGroup) {
        return viewGroup instanceof ListView || viewGroup instanceof AbsListView;
    }

    public static BitmapWithHeight getSimpleViewToBitmap(View view, int width) {
        if (view.getWidth() <= 0 || view.getHeight() <= 0) {
            view.measure(View.MeasureSpec.makeMeasureSpec((int)width, (int)0x40000000), View.MeasureSpec.makeMeasureSpec((int)0, (int)0));
            view.layout(0, 0, view.getMeasuredWidth(), view.getMeasuredHeight());
        }
        view.setDrawingCacheEnabled(true);
        view.buildDrawingCache();
        return new BitmapWithHeight(view.getDrawingCache(), view.getMeasuredHeight());
    }

    public static List<BitmapWithHeight> getWholeRecyclerViewItemsToBitmap(RecyclerView recyclerView) {
        ArrayList<BitmapWithHeight> list = new ArrayList<BitmapWithHeight>();
        if (recyclerView == null || recyclerView.getAdapter() == null) {
            return list;
        }
        if (recyclerView.getLayoutManager() instanceof LinearLayoutManager) {
            LinearLayoutManager manager = (LinearLayoutManager)recyclerView.getLayoutManager();
            if (manager.getOrientation() == 1) {
                int count = manager.getItemCount();
                LogUtils.w(count + "");
                for (int i = 0; i < count; ++i) {
                    View childView = manager.findViewByPosition(i);
                    if (childView == null) continue;
                    list.add(ViewToImageUtil.getSimpleViewToBitmap(childView, recyclerView.getMeasuredWidth()));
                }
            } else {
                list.add(ViewToImageUtil.getSimpleViewToBitmap((View)recyclerView, recyclerView.getMeasuredWidth()));
            }
        }
        return list;
    }

    public static List<BitmapWithHeight> getWholeListViewItemsToBitmap(ListView listView) {
        ArrayList<BitmapWithHeight> list = new ArrayList<BitmapWithHeight>();
        if (listView == null || listView.getAdapter() == null) {
            return list;
        }
        ListAdapter adapter = listView.getAdapter();
        int count = adapter.getCount();
        for (int i = 0; i < count; ++i) {
            View childView = adapter.getView(i, null, (ViewGroup)listView);
            list.add(ViewToImageUtil.getSimpleViewToBitmap(childView, listView.getMeasuredWidth()));
        }
        return list;
    }

    public static class BitmapWithHeight {
        public Bitmap bitmap;
        public int height;

        public BitmapWithHeight() {
        }

        public BitmapWithHeight(Bitmap bitmap, int height) {
            this.bitmap = bitmap;
            this.height = height;
        }
    }

    public static interface OnImageSavedCallback {
        public void onFinishCallback(String var1);
    }
}

