/*
 * Decompiled with CFR 0.152.
 */
package cn.robotpen.utils.screen;

import android.view.View;

public class MeasureUtil {
    public static int getSpecSize(int measureSpec) {
        return View.MeasureSpec.getSize((int)measureSpec);
    }

    public static String getSpecModeName(int measureSpec) {
        int specMode = View.MeasureSpec.getMode((int)measureSpec);
        if (specMode == 0x40000000) {
            return "EXACTLY";
        }
        if (specMode == Integer.MIN_VALUE) {
            return "AT_MOST";
        }
        return "UNSPECIFIED";
    }

    public static int resolveSize(int size, int measureSpec) {
        int result = size;
        int specMode = View.MeasureSpec.getMode((int)measureSpec);
        int specSize = View.MeasureSpec.getSize((int)measureSpec);
        switch (specMode) {
            case 0: {
                result = size;
                break;
            }
            case -2147483648: {
                result = Math.min(size, specSize);
                break;
            }
            case 0x40000000: {
                result = specSize;
            }
        }
        return result;
    }

    public static String getViewSizeInfo(View view) {
        if (view == null) {
            return "null";
        }
        return String.format("width=%s, measuredWidth=%s, height=%s, measuredHeight=%s", view.getWidth(), view.getMeasuredWidth(), view.getHeight(), view.getMeasuredHeight());
    }
}

