/*
 * Decompiled with CFR 0.152.
 */
package cn.robotpen.utils.screen;

import android.util.Log;
import java.lang.reflect.Method;
import java.util.ArrayList;

public class LogUtils {
    public static boolean mLogEnable;
    public static final String PREFIX = "LogUtils--";
    private static String mClassname;
    private static ArrayList<String> mMethods;

    public static void init(boolean logEnable) {
        mLogEnable = logEnable;
    }

    public static void d(String tag, String msg) {
        if (mLogEnable) {
            Log.d((String)tag, (String)LogUtils.getMsgWithLineNumber(msg));
        }
    }

    public static void e(String tag, String msg) {
        if (mLogEnable) {
            Log.e((String)tag, (String)LogUtils.getMsgWithLineNumber(msg));
        }
    }

    public static void i(String tag, String msg) {
        if (mLogEnable) {
            Log.i((String)tag, (String)LogUtils.getMsgWithLineNumber(msg));
        }
    }

    public static void w(String tag, String msg) {
        if (mLogEnable) {
            Log.w((String)tag, (String)LogUtils.getMsgWithLineNumber(msg));
        }
    }

    public static void v(String tag, String msg) {
        if (mLogEnable) {
            Log.v((String)tag, (String)LogUtils.getMsgWithLineNumber(msg));
        }
    }

    public static void d(String msg) {
        if (mLogEnable) {
            String[] content = LogUtils.getMsgAndTagWithLineNumber(msg);
            Log.d((String)content[0], (String)content[1]);
        }
    }

    public static void e(String msg) {
        if (mLogEnable) {
            String[] content = LogUtils.getMsgAndTagWithLineNumber(msg);
            Log.e((String)content[0], (String)content[1]);
        }
    }

    public static void i(String msg) {
        if (mLogEnable) {
            String[] content = LogUtils.getMsgAndTagWithLineNumber(msg);
            Log.i((String)content[0], (String)content[1]);
        }
    }

    public static void i() {
        if (mLogEnable) {
            String[] content = LogUtils.getMsgAndTagWithLineNumber("");
            Log.i((String)content[0], (String)content[1]);
        }
    }

    public static void w(String msg) {
        if (mLogEnable) {
            String[] content = LogUtils.getMsgAndTagWithLineNumber(msg);
            Log.w((String)content[0], (String)content[1]);
        }
    }

    public static void v(String msg) {
        if (mLogEnable) {
            String[] content = LogUtils.getMsgAndTagWithLineNumber(msg);
            Log.v((String)content[0], (String)content[1]);
        }
    }

    public static String getMsgWithLineNumber(String msg) {
        try {
            for (StackTraceElement st : new Throwable().getStackTrace()) {
                if (mClassname.equals(st.getClassName()) || mMethods.contains(st.getMethodName())) continue;
                int b = st.getClassName().lastIndexOf(".") + 1;
                String message = st.getClassName().substring(b) + "->" + st.getMethodName() + "():" + st.getLineNumber() + msg;
                return message;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return msg;
    }

    public static String[] getMsgAndTagWithLineNumber(String msg) {
        try {
            for (StackTraceElement st : new Throwable().getStackTrace()) {
                if (mClassname.equals(st.getClassName()) || mMethods.contains(st.getMethodName())) continue;
                int b = st.getClassName().lastIndexOf(".") + 1;
                String TAG = PREFIX + st.getClassName().substring(b);
                String message = st.getMethodName() + "():" + st.getLineNumber() + "->" + msg;
                String[] content = new String[]{TAG, message};
                return content;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new String[]{"universal tag", msg};
    }

    static {
        Method[] ms;
        mLogEnable = true;
        mClassname = LogUtils.class.getName();
        mMethods = new ArrayList();
        for (Method m : ms = LogUtils.class.getDeclaredMethods()) {
            mMethods.add(m.getName());
        }
    }
}

