/*
 * Decompiled with CFR 0.152.
 */
package cn.robotpen.utils.screen;

import android.content.Context;
import android.graphics.Bitmap;
import android.os.Environment;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import cn.robotpen.utils.screen.LogUtils;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;

public class FileUtil {
    public static int MAX_PIC_MEMORY_SIZE = 1500;
    public static int MAX_PIC_WIDTH = 720;
    public static int MAX_PIC_HEIGHT = 480;
    public static int LONG_PIC_MAX_WIDTH = 100;

    public static String getBasePath(Context context) {
        return FileUtil.getStoragePath("123");
    }

    public static String getStoragePath(String baseName) {
        String path = "";
        if ("mounted".equals(Environment.getExternalStorageState()) && TextUtils.isEmpty((CharSequence)path)) {
            path = Environment.getExternalStorageDirectory().getAbsolutePath();
        }
        File file = new File(path + "/" + baseName);
        LogUtils.d(file.getPath());
        LogUtils.d(file.getAbsolutePath());
        file.mkdirs();
        return file.getAbsolutePath() + "/";
    }

    public static File createImageFile(Context context) {
        return FileUtil.createImageFile(context, null);
    }

    public static File createImageFile(Context context, @Nullable String name) {
        String timeStamp = new SimpleDateFormat("yyyyMMdd_HHmmss").format(new Date());
        name = TextUtils.isEmpty((CharSequence)name) ? timeStamp : "";
        File file = new File(FileUtil.getBasePath(context) + name + ".jpg");
        try {
            file.createNewFile();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return file;
    }

    public static void compressBitmapToFile(Bitmap bmp, String outFile) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            int options = 100;
            bmp.compress(Bitmap.CompressFormat.PNG, options, (OutputStream)baos);
            while (baos.toByteArray().length / 1024 > MAX_PIC_MEMORY_SIZE && options > 0) {
                baos.reset();
                bmp.compress(Bitmap.CompressFormat.JPEG, options -= 10, (OutputStream)baos);
            }
            FileOutputStream fos = new FileOutputStream(outFile);
            fos.write(baos.toByteArray());
            fos.flush();
            fos.close();
        }
        catch (OutOfMemoryError e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

