/*
 * Decompiled with CFR 0.152.
 */
package cn.robotpen.utils.log;

import cn.robotpen.utils.log.CLog;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.util.Random;

public class FileLog {
    public static void printFile(String tag, File targetDirectory, String fileName, String headString, String msg) {
        String string = fileName = fileName == null ? FileLog.getFileName() : fileName;
        if (FileLog.save(targetDirectory, fileName, msg)) {
            CLog.d(tag, headString + " save log success ! location is >>>" + targetDirectory.getAbsolutePath() + "/" + fileName);
        } else {
            CLog.e(tag, headString + "save log fails !");
        }
    }

    private static boolean save(File dic, String fileName, String msg) {
        File file = new File(dic, fileName);
        try {
            FileOutputStream outputStream = new FileOutputStream(file, true);
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)outputStream, "UTF-8");
            outputStreamWriter.write(msg);
            outputStreamWriter.flush();
            ((OutputStream)outputStream).close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return false;
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return false;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    private static String getFileName() {
        Random random = new Random();
        return "KLog_" + Long.toString(System.currentTimeMillis() + (long)random.nextInt(10000)).substring(4) + ".txt";
    }
}

