/*
 * Decompiled with CFR 0.152.
 */
package cn.robotpen.utils;

import android.content.Context;
import android.net.Uri;
import android.support.annotation.NonNull;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;

public class UriDecoder {
    private Context context;

    public UriDecoder(Context context) {
        this.context = context;
    }

    public static UriDecoder instance(Context context) {
        return new UriDecoder(context);
    }

    public final File decodeToFile(@NonNull Uri uri, @NonNull String fileName) {
        String saveDir = this.context.getCacheDir().getAbsolutePath() + File.separator;
        return this.decodeToFile(uri, saveDir, fileName);
    }

    public final File decodeToFile(@NonNull Uri uri, @NonNull String saveDir, @NonNull String fileName) {
        File f = new File(saveDir + fileName);
        try {
            int len;
            InputStream in = this.context.getContentResolver().openInputStream(uri);
            FileOutputStream fout = new FileOutputStream(f);
            byte[] buffer = new byte[8192];
            while ((len = in.read(buffer)) != -1) {
                fout.write(buffer, 0, len);
            }
            fout.flush();
            fout.close();
            in.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        return f;
    }
}

