/*
 * Decompiled with CFR 0.152.
 */
package cn.robotpen.utils;

import android.annotation.SuppressLint;
import android.content.Context;
import android.database.Cursor;
import android.hardware.Camera;
import android.net.Uri;
import android.os.Build;
import android.provider.DocumentsContract;
import android.provider.MediaStore;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class SystemUtil {
    public static int dip2px(Context context, float dipValue) {
        return (int)SystemUtil.dip2pxf(context, dipValue);
    }

    public static float dip2pxf(Context context, float dipValue) {
        float scale = context.getResources().getDisplayMetrics().density;
        return dipValue * scale + 0.5f;
    }

    public static boolean checkCameraHardware(Context context) {
        return context.getPackageManager().hasSystemFeature("android.hardware.camera");
    }

    public static boolean checkPermissionsGranted(int[] grantResults) {
        if (grantResults.length > 0) {
            boolean flag = true;
            for (int i = 0; i < grantResults.length; ++i) {
                if (grantResults[i] == 0) continue;
                flag = false;
                break;
            }
            return flag;
        }
        return false;
    }

    public static int getFaceCameraIndex() {
        int result = -1;
        Camera.CameraInfo cameraInfo = new Camera.CameraInfo();
        int cameraCount = Camera.getNumberOfCameras();
        for (int i = 0; i < cameraCount; ++i) {
            Camera.getCameraInfo((int)i, (Camera.CameraInfo)cameraInfo);
            if (cameraInfo.facing != 1) continue;
            result = 1;
            break;
        }
        return result;
    }

    public static String getRealFilePath(Context context, Uri uri) {
        Cursor cursor;
        if (null == uri) {
            return null;
        }
        if (Build.VERSION.SDK_INT >= 24) {
            return SystemUtil.getRealPathFromURI_API24(context, uri);
        }
        String scheme = uri.getScheme();
        String data = null;
        if (scheme == null) {
            data = uri.getPath();
        } else if ("file".equals(scheme)) {
            data = uri.getPath();
        } else if ("content".equals(scheme) && null != (cursor = context.getContentResolver().query(uri, new String[]{"_data"}, null, null, null))) {
            int index;
            if (cursor.moveToFirst() && (index = cursor.getColumnIndex("_data")) > -1) {
                data = cursor.getString(index);
            }
            cursor.close();
        }
        return data;
    }

    @SuppressLint(value={"NewApi"})
    public static String getRealPathFromURI_API24(Context context, Uri uri) {
        String filePath = "";
        String wholeID = DocumentsContract.getDocumentId((Uri)uri);
        String id = wholeID.split(":")[1];
        String[] column = new String[]{"_data"};
        String sel = "_id=?";
        Cursor cursor = context.getContentResolver().query(MediaStore.Images.Media.EXTERNAL_CONTENT_URI, column, sel, new String[]{id}, null);
        int columnIndex = cursor.getColumnIndex(column[0]);
        if (cursor.moveToFirst()) {
            filePath = cursor.getString(columnIndex);
        }
        cursor.close();
        return filePath;
    }

    public static byte[] toByteArray(Object obj) {
        byte[] bytes = null;
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            ObjectOutputStream oos = new ObjectOutputStream(bos);
            oos.writeObject(obj);
            oos.flush();
            bytes = bos.toByteArray();
            oos.close();
            bos.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return bytes;
    }

    public static Object toObject(byte[] bytes) {
        Object obj = null;
        try {
            ByteArrayInputStream bis = new ByteArrayInputStream(bytes);
            ObjectInputStream ois = new ObjectInputStream(bis);
            obj = ois.readObject();
            ois.close();
            bis.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        catch (ClassNotFoundException ex) {
            ex.printStackTrace();
        }
        return obj;
    }
}

