/*
 * Decompiled with CFR 0.152.
 */
package cn.robotpen.utils;

import android.text.TextUtils;
import android.util.Base64;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public class StringUtil {
    private static final String MAC_NAME = "HmacSHA1";
    private static final String ENCODING = "UTF-8";

    public static String getDecodeStr(String value) {
        if (StringUtil.isNotEmpty(value)) {
            try {
                value = URLDecoder.decode(value, ENCODING);
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
        return value;
    }

    public static String getEncodeStr(String value) {
        if (StringUtil.isNotEmpty(value)) {
            try {
                value = URLEncoder.encode(value, ENCODING);
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
        return value;
    }

    public static String getJpgNameForUrl(String url) {
        String result = null;
        Pattern p = Pattern.compile("/[^/]+\\.jpg?", 2);
        Matcher m = p.matcher(url);
        if (m.find() && !TextUtils.isEmpty((CharSequence)(result = m.group()))) {
            result = result.substring(1, result.length() - 4);
        }
        return result;
    }

    public static String getFormatMsg(String value) {
        if (StringUtil.isNotEmpty(value)) {
            Pattern p = Pattern.compile("\\n+");
            Matcher m = p.matcher(value);
            value = m.replaceAll("\n");
        }
        return value;
    }

    public static String getFormatCleanInvalid(String value) {
        if (StringUtil.isNotEmpty(value)) {
            Pattern p = Pattern.compile("\\s*|\t|\r|\n");
            Matcher m = p.matcher(value);
            value = m.replaceAll("");
        }
        return value;
    }

    public static String decodeBase64(String text) {
        try {
            return new String(Base64.decode((byte[])text.getBytes(), (int)0), "utf-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return text;
    }

    public static String encodeBase64(String text) {
        return Base64.encodeToString((byte[])text.getBytes(), (int)10);
    }

    public String getAccessToken(String data, String secretKey) {
        try {
            String encodedSign = StringUtil.encodeToString(this.hmac_sha1(data, secretKey));
            return encodedSign;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String encodeToString(String data) {
        try {
            return StringUtil.encodeToString(data.getBytes(ENCODING));
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String encodeToString(byte[] data) {
        return Base64.encodeToString((byte[])data, (int)10);
    }

    public static byte[] decode(String data) {
        return Base64.decode((String)data, (int)10);
    }

    private byte[] hmac_sha1(String encryptText, String encryptKey) throws Exception {
        byte[] data = encryptKey.getBytes(ENCODING);
        SecretKeySpec secretKey = new SecretKeySpec(data, MAC_NAME);
        Mac mac = Mac.getInstance(MAC_NAME);
        mac.init(secretKey);
        byte[] text = encryptText.getBytes(ENCODING);
        return mac.doFinal(text);
    }

    public static String HmacSHA1Encrypt(String encryptText, String encryptKey) throws Exception {
        byte[] data = encryptKey.getBytes(ENCODING);
        SecretKeySpec secretKey = new SecretKeySpec(data, MAC_NAME);
        Mac mac = Mac.getInstance(MAC_NAME);
        mac.init(secretKey);
        byte[] text = encryptText.getBytes(ENCODING);
        byte[] digest = mac.doFinal(text);
        StringBuilder sBuilder = StringUtil.bytesToHexString(digest);
        return sBuilder.toString();
    }

    public static StringBuilder bytesToHexString(byte[] bytesArray) {
        if (bytesArray == null) {
            return null;
        }
        StringBuilder sBuilder = new StringBuilder();
        for (byte b : bytesArray) {
            String hv = String.format("%02x", b);
            sBuilder.append(hv);
        }
        return sBuilder;
    }

    public static String hmacSHA1Encrypt(byte[] encryptData, String encryptKey) throws Exception {
        byte[] data = encryptKey.getBytes(ENCODING);
        SecretKeySpec secretKey = new SecretKeySpec(data, MAC_NAME);
        Mac mac = Mac.getInstance(MAC_NAME);
        mac.init(secretKey);
        byte[] digest = mac.doFinal(encryptData);
        StringBuilder sBuilder = StringUtil.bytesToHexString(digest);
        return sBuilder.toString();
    }

    public static String byte2String(byte[] data) {
        if (data != null && data.length > 0) {
            StringBuilder stringBuilder = new StringBuilder(data.length);
            for (byte byteChar : data) {
                stringBuilder.append(String.format("%02X ", byteChar));
            }
            return stringBuilder.toString();
        }
        return null;
    }

    public static String base64_urlsafe_encode(byte[] data) {
        return Base64.encodeToString((byte[])data, (int)2);
    }

    public static String stringToMD5(String string) {
        byte[] hash;
        try {
            hash = MessageDigest.getInstance("MD5").digest(string.getBytes(ENCODING));
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            return null;
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
        StringBuilder hex = new StringBuilder(hash.length * 2);
        for (byte b : hash) {
            if ((b & 0xFF) < 16) {
                hex.append("0");
            }
            hex.append(Integer.toHexString(b & 0xFF));
        }
        return hex.toString();
    }

    public static boolean isMobileNumber(String mobiles) {
        String telRegex = "[1][358]\\d{9}";
        if (TextUtils.isEmpty((CharSequence)mobiles)) {
            return false;
        }
        return mobiles.matches(telRegex);
    }

    public static boolean isEmail(String email) {
        String str = "^([a-zA-Z0-9]*[-_]?[a-zA-Z0-9]+)*@([a-zA-Z0-9]*[-_]?[a-zA-Z0-9]+)+[\\.][A-Za-z]{2,3}([\\.][A-Za-z]{2})?$";
        Pattern p = Pattern.compile(str);
        Matcher m = p.matcher(email);
        return m.matches();
    }

    public static boolean isEmpty(String s) {
        return s == null || s.trim().length() == 0;
    }

    public static boolean isNotEmpty(String s) {
        return !StringUtil.isEmpty(s);
    }

    public static boolean isPwd(String str) {
        boolean b = false;
        if (StringUtil.isEmpty(str)) {
            return b;
        }
        Pattern p = null;
        Matcher m = null;
        p = Pattern.compile("^[a-z0-9A-Z]{6,16}$");
        m = p.matcher(str);
        b = m.matches();
        return b;
    }
}

