/*
 * Decompiled with CFR 0.152.
 */
package cn.robotpen.utils;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class GZipUtil {
    public static final int BUFFER = 1024;
    public static final String EXT = ".gz";

    public static byte[] compress(byte[] data) throws Exception {
        if (data == null || data.length == 0) {
            return data;
        }
        ByteArrayInputStream bais = new ByteArrayInputStream(data);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        GZipUtil.compress(bais, baos);
        data = baos.toByteArray();
        baos.flush();
        baos.close();
        bais.close();
        return data;
    }

    public static byte[] decompress(byte[] data) throws Exception {
        if (data == null || data.length == 0) {
            return data;
        }
        ByteArrayInputStream bais = new ByteArrayInputStream(data);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        GZipUtil.decompress(bais, baos);
        data = baos.toByteArray();
        baos.flush();
        baos.close();
        bais.close();
        return data;
    }

    public static void compress(InputStream is, OutputStream os) throws Exception {
        int count;
        GZIPOutputStream gos = new GZIPOutputStream(os);
        byte[] data = new byte[1024];
        while ((count = is.read(data, 0, 1024)) != -1) {
            gos.write(data, 0, count);
        }
        gos.finish();
        gos.close();
    }

    public static void decompress(InputStream is, OutputStream os) throws Exception {
        int count;
        GZIPInputStream gis = new GZIPInputStream(is);
        byte[] data = new byte[1024];
        while ((count = gis.read(data, 0, 1024)) != -1) {
            os.write(data, 0, count);
        }
        gis.close();
    }
}

